/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.beans.BeanUtils;
import org.netbeans.modules.beans.EventSetPattern;
import org.netbeans.modules.beans.IdxPropertyPattern;
import org.netbeans.modules.beans.PatternAnalyser;
import org.netbeans.modules.beans.PropertyPattern;

public class TmpPattern {

    public static class EventSet {
        ExecutableElement addListenerMethod;
        ExecutableElement removeListenerMethod;
        boolean isUnicast;
        TypeMirror type;
        String name;

        public EventSet(CompilationInfo ci, ExecutableElement addListenerMethod, ExecutableElement removeListenerMethod) {
            if (addListenerMethod == null || removeListenerMethod == null) {
                throw new NullPointerException();
            }
            this.addListenerMethod = addListenerMethod;
            this.removeListenerMethod = removeListenerMethod;
            this.isUnicast = this.testUnicast(ci);
            this.type = this.findEventSetType();
            this.name = this.findEventSetName();
        }

        EventSet(EventSet x, EventSet y) {
            this.addListenerMethod = y.addListenerMethod;
            this.removeListenerMethod = y.removeListenerMethod;
            this.isUnicast = y.isUnicast;
            this.type = y.type;
            this.name = y.name;
        }

        EventSetPattern createPattern(PatternAnalyser analyser) {
            return new EventSetPattern(analyser, this.addListenerMethod, this.removeListenerMethod, this.name, this.type, this.isUnicast);
        }

        private TypeMirror findEventSetType() {
            return this.addListenerMethod.getParameters().get(0).asType();
        }

        private String findEventSetName() {
            String compound = BeanUtils.nameAsString(this.addListenerMethod).substring(3);
            this.name = Introspector.decapitalize(compound);
            return this.name;
        }

        private boolean testUnicast(CompilationInfo ci) {
            return BeanUtils.isThrowing(ci, this.addListenerMethod, "java.util.TooManyListenersException");
        }
    }

    public static class IdxProperty
    extends Property {
        private ExecutableElement indexedGetterMethod;
        private ExecutableElement indexedSetterMethod;
        private TypeMirror indexedType;

        public IdxProperty(CompilationInfo ci, ExecutableElement getterMethod, ExecutableElement setterMethod, ExecutableElement indexedGetterMethod, ExecutableElement indexedSetterMethod) throws IntrospectionException {
            super(ci, getterMethod, setterMethod);
            this.indexedGetterMethod = indexedGetterMethod;
            this.indexedSetterMethod = indexedSetterMethod;
            this.indexedType = this.findIndexedPropertyType(ci);
            if (this.type == null && this.indexedType != null) {
                this.type = ci.getTypes().getArrayType(this.indexedType);
            }
            this.name = this.findIndexedPropertyName();
        }

        IdxProperty(CompilationInfo javac, Property x, Property y) {
            super(javac, x, y);
            if (x instanceof IdxProperty) {
                IdxProperty ix = (IdxProperty)x;
                this.indexedGetterMethod = ix.indexedGetterMethod;
                this.indexedSetterMethod = ix.indexedSetterMethod;
                this.indexedType = ix.indexedType;
                TypeMirror typeMirror = this.type = this.type == null ? ix.type : this.type;
            }
            if (y instanceof IdxProperty) {
                IdxProperty iy = (IdxProperty)y;
                if (iy.indexedGetterMethod != null) {
                    this.indexedGetterMethod = iy.indexedGetterMethod;
                }
                if (iy.indexedSetterMethod != null) {
                    this.indexedSetterMethod = iy.indexedSetterMethod;
                }
                this.indexedType = iy.indexedType;
                this.type = this.type == null ? iy.type : this.type;
            }
            this.name = this.findIndexedPropertyName();
        }

        @Override
        public IdxPropertyPattern createPattern(PatternAnalyser analyser) throws IntrospectionException {
            return new IdxPropertyPattern(analyser, this.getterMethod, this.setterMethod, this.indexedGetterMethod, this.indexedSetterMethod, this.estimatedField, this.type, this.indexedType, this.name);
        }

        private TypeMirror findIndexedPropertyType(CompilationInfo javac) throws IntrospectionException {
            TypeMirror propType;
            List<? extends VariableElement> params;
            this.indexedType = null;
            if (this.indexedGetterMethod != null) {
                params = this.indexedGetterMethod.getParameters();
                if (params.size() != 1) {
                    throw new IntrospectionException("bad indexed read method arg count");
                }
                VariableElement param = params.get(0);
                if (param.asType().getKind() != TypeKind.INT) {
                    throw new IntrospectionException("not int index to indexed read method");
                }
                this.indexedType = this.indexedGetterMethod.getReturnType();
                if (this.indexedType.getKind() == TypeKind.VOID) {
                    throw new IntrospectionException("indexed read method return void");
                }
            }
            if (this.indexedSetterMethod != null) {
                params = this.indexedSetterMethod.getParameters();
                if (params.size() != 2) {
                    throw new IntrospectionException("bad indexed write method arg count");
                }
                VariableElement param1 = params.get(0);
                if (param1.asType().getKind() != TypeKind.INT) {
                    throw new IntrospectionException("non int index to indexed write method");
                }
                VariableElement param2 = params.get(1);
                if (this.indexedType != null && !javac.getTypes().isSameType(this.indexedType, param2.asType())) {
                    throw new IntrospectionException("type mismatch between indexed read and write methods");
                }
                this.indexedType = param2.asType();
            }
            if (!((propType = this.type) == null || propType.getKind() == TypeKind.ARRAY && javac.getTypes().isSameType(this.indexedType, ((ArrayType)propType).getComponentType()))) {
                throw new IntrospectionException("type mismatch between property type and indexed type");
            }
            return this.indexedType;
        }

        String findIndexedPropertyName() {
            String superName = this.findPropertyName();
            if (superName == null) {
                String methodName = null;
                if (this.indexedGetterMethod != null) {
                    methodName = BeanUtils.nameAsString(this.indexedGetterMethod);
                } else if (this.indexedSetterMethod != null) {
                    methodName = BeanUtils.nameAsString(this.indexedSetterMethod);
                } else {
                    throw new InternalError("Indexed property with all methods == null");
                }
                return methodName.startsWith("is") ? Introspector.decapitalize(methodName.substring(2)) : Introspector.decapitalize(methodName.substring(3));
            }
            return superName;
        }
    }

    public static class Property {
        ExecutableElement getterMethod;
        ExecutableElement setterMethod;
        VariableElement estimatedField;
        TypeMirror type;
        String name;

        public Property(CompilationInfo javac, ExecutableElement getterMethod, ExecutableElement setterMethod) throws IntrospectionException {
            this.getterMethod = getterMethod;
            this.setterMethod = setterMethod;
            this.type = this.findPropertyType(javac);
            this.name = this.findPropertyName();
        }

        Property(CompilationInfo javac, Property x, Property y) {
            ExecutableElement xr = x.getterMethod;
            ExecutableElement yr = y.getterMethod;
            this.getterMethod = xr;
            if (yr != null) {
                this.getterMethod = yr;
            }
            if (xr != null && yr != null && xr.getEnclosingElement() == yr.getEnclosingElement() && xr.getReturnType().getKind() == TypeKind.BOOLEAN && yr.getReturnType().getKind() == TypeKind.BOOLEAN && BeanUtils.nameAsString(xr).indexOf("is") == 0 && BeanUtils.nameAsString(yr).indexOf("get") == 0) {
                this.getterMethod = xr;
            }
            this.setterMethod = x.setterMethod;
            if (y.setterMethod != null) {
                this.setterMethod = y.setterMethod;
            }
            try {
                this.type = this.findPropertyType(javac);
            }
            catch (IntrospectionException ex) {
                throw new IllegalStateException("Mixing invalid PropertyPattrens", ex);
            }
            this.name = this.findPropertyName();
        }

        public PropertyPattern createPattern(PatternAnalyser analyser) throws IntrospectionException {
            return new PropertyPattern(analyser, this.getterMethod, this.setterMethod, this.estimatedField, this.type, this.name);
        }

        TypeMirror findPropertyType(CompilationInfo javac) throws IntrospectionException {
            TypeMirror resolvedType = null;
            if (this.getterMethod != null) {
                if (!this.getterMethod.getParameters().isEmpty()) {
                    throw new IntrospectionException("bad read method arg count");
                }
                resolvedType = this.getterMethod.getReturnType();
                if (resolvedType.getKind() == TypeKind.VOID) {
                    throw new IntrospectionException("read method " + this.getterMethod.getSimpleName() + " returns void");
                }
            }
            if (this.setterMethod != null) {
                List<? extends VariableElement> params = this.setterMethod.getParameters();
                if (params.size() != 1) {
                    throw new IntrospectionException("bad write method arg count");
                }
                VariableElement param = params.get(0);
                if (resolvedType != null && !javac.getTypes().isSameType(resolvedType, param.asType())) {
                    throw new IntrospectionException("type mismatch between read and write methods");
                }
                resolvedType = param.asType();
            }
            return resolvedType;
        }

        String findPropertyName() {
            String methodName = null;
            if (this.getterMethod != null) {
                methodName = BeanUtils.nameAsString(this.getterMethod);
            } else if (this.setterMethod != null) {
                methodName = BeanUtils.nameAsString(this.setterMethod);
            } else {
                return null;
            }
            return methodName.startsWith("is") ? Introspector.decapitalize(methodName.substring(2)) : Introspector.decapitalize(methodName.substring(3));
        }
    }
}

