/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.dependencies;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.swing.text.BadLocationException;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lsp.TextEdit;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.dependencies.AbstractWorker;
import org.netbeans.modules.gradle.dependencies.RewriteContext;
import org.netbeans.modules.gradle.java.queries.GradleScope;
import org.netbeans.modules.project.dependency.ArtifactSpec;
import org.netbeans.modules.project.dependency.Dependency;
import org.netbeans.modules.project.dependency.DependencyChangeException;
import org.netbeans.modules.project.dependency.DependencyResult;
import org.netbeans.modules.project.dependency.SourceLocation;
import org.openide.util.Exceptions;

public class DependencyAdder
extends AbstractWorker {
    public DependencyAdder(Project project, RewriteContext context) {
        super(project, context);
    }

    @Override
    protected void throwDependencyConflicts() throws DependencyChangeException {
        if (!this.offending.isEmpty()) {
            throw new DependencyChangeException(this.request, DependencyChangeException.Reason.CONFLICT, this.offending);
        }
    }

    @Override
    protected boolean checkDependencyConflicts(Dependency existing, Dependency d) throws DependencyChangeException {
        ArtifactSpec existingA = existing.getArtifact();
        ArtifactSpec toAdd = d.getArtifact();
        GradleScope s = this.getScope(d);
        if (!existingA.getGroupId().equals(toAdd.getGroupId()) || !existingA.getArtifactId().equals(toAdd.getArtifactId())) {
            return true;
        }
        if (!existing.getScope().equals((Object)s) && !existing.getScope().name().equals(s.getTargetConfigurationName())) {
            return true;
        }
        String existingC = existingA.getClassifier();
        if (existingA != null && !Objects.equals(existingC, toAdd.getClassifier())) {
            return true;
        }
        this.recordConflict(d, existing);
        return false;
    }

    public static String[] gavSplit(String gav) {
        int versionEnd;
        int firstColon = gav.indexOf(58);
        int versionColon = gav.indexOf(58, firstColon + 1);
        int n = versionEnd = versionColon > firstColon ? gav.indexOf(58, versionColon + 1) : -1;
        if (firstColon == -1 || versionColon == -1 || firstColon == versionColon) {
            throw new IllegalArgumentException("Invalid GAV format: '" + gav + "'");
        }
        int end = versionEnd == -1 ? gav.length() : versionEnd;
        return new String[]{gav.substring(0, firstColon), gav.substring(firstColon + 1, versionColon), gav.substring(versionColon + 1, end)};
    }

    private StringBuilder appendDependencyDecl(StringBuilder sb, Dependency d) throws DependencyChangeException {
        GradleScope gs = this.getScope(d);
        sb.append(gs.getTargetConfigurationName()).append("('");
        ArtifactSpec a = d.getArtifact();
        sb.append(a.getGroupId()).append(':').append(a.getArtifactId());
        if (a.getVersionSpec() != null) {
            sb.append(':').append(a.getVersionSpec());
        }
        sb.append("')");
        return sb;
    }

    void generateDependencyBlockAtEnd() throws DependencyChangeException {
        int start = this.lineDoc.getLength();
        StringBuilder sb = new StringBuilder();
        sb.append("dependencies {\n");
        for (Dependency d : this.accepted) {
            sb.append("    ");
            this.appendDependencyDecl(sb, d);
            sb.append("\n");
        }
        sb.append("}\n");
        this.textEdits.add(new TextEdit(start, start, sb.toString()));
    }

    @Override
    protected void generateDependencies() throws DependencyChangeException {
        if (this.accepted.isEmpty()) {
            return;
        }
        DependencyResult current = this.context.getCurrentDependencies();
        List roots = current.getRoot().getChildren();
        try {
            SourceLocation loc = current.getDeclarationRange(null, "container");
            if (loc == null) {
                this.generateDependencyBlockAtEnd();
                return;
            }
            int dependencyIndent = Math.max(0, LineDocumentUtils.getLineFirstNonWhitespace((LineDocument)this.lineDoc, (int)loc.getStartOffset()) - LineDocumentUtils.getLineStart((LineDocument)this.lineDoc, (int)loc.getStartOffset()));
            int declarationIndent = dependencyIndent + 4;
            for (int i = roots.size() - 1; i >= 0; ++i) {
                Dependency d = (Dependency)roots.get(i);
                SourceLocation l2 = current.getDeclarationRange(d, null);
                if (l2 == null) continue;
                SourceLocation container = current.getDeclarationRange(d, "container");
                if (container != null) {
                    l2 = container;
                }
                declarationIndent = Math.max(0, LineDocumentUtils.getLineFirstNonWhitespace((LineDocument)this.lineDoc, (int)l2.getStartOffset()) - LineDocumentUtils.getLineStart((LineDocument)this.lineDoc, (int)l2.getStartOffset()));
                break;
            }
            int start = LineDocumentUtils.getLineStart((LineDocument)this.lineDoc, (int)loc.getEndOffset());
            int nonWhite = LineDocumentUtils.getLineFirstNonWhitespace((LineDocument)this.lineDoc, (int)loc.getEndOffset());
            StringBuilder toInsert = new StringBuilder();
            StringBuilder suffix = new StringBuilder();
            if (!"}".equals(this.lineDoc.getText(nonWhite, 1))) {
                toInsert.append("\n");
                DependencyAdder.indent(suffix, loc.getEndOffset() - 1 - start);
                start = loc.getEndOffset() - 1;
            }
            for (Dependency d : this.accepted) {
                this.appendDependencyDecl(DependencyAdder.indent(toInsert, declarationIndent), d).append('\n');
            }
            toInsert.append((CharSequence)suffix);
            this.textEdits.add(new TextEdit(start, start, toInsert.toString()));
        }
        catch (IOException | BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

