/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared;

import java.awt.Image;
import java.io.IOException;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.swing.Action;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodModel;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.ComponentMethodViewStrategy;
import org.openide.actions.OpenAction;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class MethodNode
extends AbstractNode
implements OpenCookie {
    private final ClasspathInfo cpInfo;
    private final String implBean;
    private final FileObject implBeanFO;
    private final MethodModel method;
    private final ComponentMethodViewStrategy cmvs;

    public MethodNode(ClasspathInfo cpInfo, MethodModel method, String implBean, ComponentMethodViewStrategy cmvs) {
        this(cpInfo, method, implBean, cmvs, new InstanceContent());
    }

    private MethodNode(ClasspathInfo cpInfo, MethodModel method, String implBean, ComponentMethodViewStrategy cmvs, InstanceContent ic) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)ic));
        ic.add((Object)this);
        ic.add((Object)method);
        this.cpInfo = cpInfo;
        this.method = method;
        this.implBean = implBean;
        this.cmvs = cmvs;
        this.implBeanFO = MethodNode.getFileObject(cpInfo, implBean);
    }

    public Image getIcon(int type) {
        Image badge = this.cmvs.getBadge(this.method);
        Image icon = this.cmvs.getIcon(this.method);
        if (badge != null) {
            return ImageUtilities.mergeImages((Image)icon, (Image)badge, (int)7, (int)7);
        }
        return icon;
    }

    public String getName() {
        return this.method.getName();
    }

    public boolean canDestroy() {
        final boolean[] result = new boolean[]{false};
        try {
            JavaSource javaSource = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[0]);
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    if ("findByPrimaryKey".equals(MethodNode.this.method.getName())) {
                        if (MethodNode.this.isEntityBeanMethod()) {
                            result[0] = false;
                        }
                    } else if (MethodNode.this.method.getModifiers().contains((Object)Modifier.ABSTRACT) && (MethodNode.this.isGetter(MethodNode.this.method) || MethodNode.this.isSetter(MethodNode.this.method)) && MethodNode.this.isEntityBeanMethod()) {
                        result[0] = false;
                    }
                    result[0] = true;
                }
            }, true);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        return result[0];
    }

    public void destroy() throws IOException {
        if (this.implBeanFO != null) {
            this.cmvs.deleteImplMethod(this.method, this.implBean, this.implBeanFO);
        }
        super.destroy();
    }

    public Action[] getActions(boolean context) {
        return new Action[0];
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    public void open() {
        this.cmvs.openMethod(this.method, this.implBean, this.implBeanFO);
    }

    private boolean isEntityBeanMethod() throws IOException {
        final boolean[] result = new boolean[]{false};
        JavaSource javaSource = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[0]);
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController controller) throws IOException {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                Elements elements = controller.getElements();
                TypeElement entityBean = elements.getTypeElement("javax.ejb.EntityBean");
                TypeElement entityBeanJakarta = elements.getTypeElement("jakarta.ejb.EntityBean");
                TypeElement implBeanElement = elements.getTypeElement(MethodNode.this.implBean);
                if (implBeanElement != null && entityBean != null) {
                    result[0] = result[0] | controller.getTypes().isSubtype(implBeanElement.asType(), entityBean.asType());
                }
                if (implBeanElement != null && entityBeanJakarta != null) {
                    result[0] = result[0] | controller.getTypes().isSubtype(implBeanElement.asType(), entityBeanJakarta.asType());
                }
            }
        }, true);
        return result[0];
    }

    private boolean isGetter(MethodModel method) {
        boolean isVoid = "void".equals(method.getReturnType());
        return method.getName().indexOf("get") == 0 && !isVoid && method.getParameters().size() == 0;
    }

    private boolean isSetter(MethodModel method) {
        boolean isVoid = "void".equals(method.getReturnType());
        return method.getName().indexOf("set") == 0 && isVoid && method.getParameters().size() == 1;
    }

    private static FileObject getFileObject(ClasspathInfo cpInfo, final String className) {
        final FileObject[] result = new FileObject[1];
        try {
            JavaSource javaSource = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]);
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = controller.getElements().getTypeElement(className);
                    if (typeElement != null) {
                        result[0] = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)typeElement), (ClasspathInfo)controller.getClasspathInfo());
                    }
                }
            }, true);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        return result[0];
    }
}

