/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.fakepeer;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import org.netbeans.modules.form.fakepeer.FakeComponentPeer;
import org.netbeans.modules.form.fakepeer.FakePeerUtils;

class FakeButtonPeer
extends FakeComponentPeer {
    private static final Insets MARGINS = new Insets(4, 8, 4, 8);

    FakeButtonPeer(Button target) {
        super(target);
    }

    @Override
    Component createDelegate() {
        return new Delegate();
    }

    public void setLabel(String label) {
    }

    private class Delegate
    extends Component {
        Delegate() {
            this.setBackground(SystemColor.control);
            this.setForeground(SystemColor.controlText);
        }

        @Override
        public void paint(Graphics g) {
            Button target = (Button)FakeButtonPeer.this._target;
            Dimension sz = target.getSize();
            g.setColor(target.getBackground());
            FakePeerUtils.drawButton(g, 0, 0, sz.width, sz.height);
            String label = target.getLabel();
            if (label == null) {
                return;
            }
            g.setFont(target.getFont());
            FontMetrics fm = g.getFontMetrics();
            int w = fm.stringWidth(label);
            int h = fm.getHeight() - fm.getDescent();
            int x = (sz.width - w) / 2;
            int y = (sz.height - h) / 2 + h - 2;
            if (target.isEnabled()) {
                g.setColor(target.getForeground());
            } else {
                g.setColor(SystemColor.controlLtHighlight);
                g.drawString(label, x + 1, y + 1);
                g.setColor(SystemColor.controlShadow);
            }
            g.drawString(label, x, y);
        }

        @Override
        public Dimension getMinimumSize() {
            String label = ((Button)FakeButtonPeer.this._target).getLabel();
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int w = fm.stringWidth(label);
            int h = fm.getHeight();
            return new Dimension(w + FakeButtonPeer.MARGINS.left + FakeButtonPeer.MARGINS.right, h + FakeButtonPeer.MARGINS.top + FakeButtonPeer.MARGINS.bottom);
        }
    }
}

