/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.maven;

import java.io.IOException;
import java.util.List;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.modules.jshell.launch.ShellAgent;
import org.netbeans.modules.jshell.launch.ShellLaunchManager;
import org.netbeans.modules.jshell.project.LaunchedProjectOpener;
import org.netbeans.modules.jshell.project.ShellProjectUtils;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.ExecutionResultChecker;
import org.netbeans.modules.maven.api.execute.LateBoundPrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class MavenShellLauncher
implements PrerequisitesChecker,
LateBoundPrerequisitesChecker,
ExecutionResultChecker {
    private static final String PLACEHOLDER_JSHELL_ARGS = "${jshell.args}";
    private static final String PROPERTY_EXEC_ARGS = "exec.args";
    private static final String PROPERTY_JSHELL_KEY = "jshell.authKey";
    private static final String PROPERTY_JSHELL_AGENT = "jshell.agent";

    public boolean checkRunConfig(RunConfig config) {
        return true;
    }

    public void executionResult(RunConfig config, ExecutionContext res, int resultCode) {
        String s = (String)config.getProperties().get(PROPERTY_JSHELL_KEY);
        if (s == null) {
            return;
        }
        RequestProcessor.getDefault().post(() -> ShellLaunchManager.getInstance().destroyAgent(s));
    }

    public boolean checkRunConfig(RunConfig config, ExecutionContext con) {
        ShellAgent agent;
        boolean ok;
        boolean enabled = Boolean.parseBoolean((String)config.getProperties().get("jshell.run.enable"));
        if (!enabled) {
            return true;
        }
        LaunchedProjectOpener.init();
        Project project = config.getProject();
        boolean isDebug = config.getActionName().equals("debug");
        boolean bl = ok = isDebug || config.getActionName().equals("run");
        if (!ok) {
            return true;
        }
        ShellLaunchManager mgr = ShellLaunchManager.getInstance();
        try {
            agent = mgr.openForProject(project, isDebug);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
        agent.setIO(con.getInputOutput(), config.getTaskDisplayName());
        JavaPlatform platform = ShellProjectUtils.findPlatform(project);
        List<String> args = ShellLaunchManager.buildLocalJVMAgentArgs(platform, agent, config.getProperties()::get);
        String agentString = args.get(args.size() - 1);
        args.addAll(ShellProjectUtils.launchVMOptions(project));
        String execArgs = (String)config.getProperties().get(PROPERTY_EXEC_ARGS);
        if (execArgs != null) {
            StringBuilder sb = new StringBuilder();
            for (String a : args) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(ShellProjectUtils.quoteCmdArg(a));
            }
            String newArgs = execArgs.contains(PLACEHOLDER_JSHELL_ARGS) ? execArgs.replace(PLACEHOLDER_JSHELL_ARGS, sb.toString()) : sb.append(" ").append(execArgs).toString();
            config.setProperty(PROPERTY_EXEC_ARGS, newArgs);
        }
        config.setProperty(PROPERTY_JSHELL_AGENT, agentString);
        config.setProperty(PROPERTY_JSHELL_KEY, agent.getAuthorizationKey());
        return true;
    }
}

