/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.actions;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.gradle.actions.ActionMappingScanner;
import org.netbeans.modules.gradle.api.execute.ActionMapping;
import org.netbeans.modules.gradle.spi.actions.GradleActionsProvider;
import org.openide.util.Lookup;
import org.xml.sax.SAXException;

public class MappingContainer {
    private static MappingContainer defaultInstance;
    final MappingContainer parent;
    Set<ActionMapping> mappings = new HashSet<ActionMapping>();

    public MappingContainer(MappingContainer parent) {
        this.parent = parent;
    }

    public ActionMapping findMapping(String action, Set<String> plugins) {
        ActionMapping result = null;
        for (ActionMapping mapping : this.mappings) {
            if (!mapping.getName().equals(action) || !mapping.isApplicable(plugins) || result != null && result.compareTo(mapping) >= 0) continue;
            result = mapping;
        }
        if (result == null && this.parent != null) {
            result = this.parent.findMapping(action, plugins);
        }
        return result;
    }

    public void addMappings(Collection<ActionMapping> mappings) {
        this.mappings.addAll(mappings);
    }

    public static MappingContainer getDefault() {
        if (defaultInstance == null) {
            DefaultContainer instance = new DefaultContainer();
            instance.initialize();
            defaultInstance = instance;
        }
        return defaultInstance;
    }

    private static class DefaultContainer
    extends MappingContainer {
        DefaultContainer() {
            super(null);
        }

        void initialize() {
            Collection all = Lookup.getDefault().lookupAll(GradleActionsProvider.class);
            for (GradleActionsProvider provider : all) {
                try {
                    InputStream is = provider.defaultActionMapConfig();
                    try {
                        if (is == null) continue;
                        Set<ActionMapping> load = ActionMappingScanner.loadMappings(is);
                        this.addMappings(load);
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (IOException | ParserConfigurationException | SAXException exception) {}
            }
        }
    }
}

