/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.indent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.web.indent.api.LexUtilities;
import org.netbeans.modules.web.indent.api.embedding.JoinedTokenSequence;
import org.netbeans.modules.web.indent.api.support.AbstractIndenter;
import org.netbeans.modules.web.indent.api.support.IndentCommand;
import org.netbeans.modules.web.indent.api.support.IndenterContextData;

public class CssIndenter
extends AbstractIndenter<CssTokenId> {
    private Stack<CssStackItem> stack = null;
    private int preservedLineIndentation = -1;
    private boolean inComment = false;
    private boolean previousCommentLineStartsWithAsterix = false;
    private boolean inMedia = false;

    public CssIndenter(Context context) {
        super(CssTokenId.language(), context);
    }

    private Stack<CssStackItem> getStack() {
        return this.stack;
    }

    protected boolean isWhiteSpaceToken(Token<CssTokenId> token) {
        return token.id() == CssTokenId.WS;
    }

    private boolean isCommentToken(Token<CssTokenId> token) {
        return token.id() == CssTokenId.COMMENT;
    }

    protected void reset() {
        this.stack = new Stack();
        this.inComment = false;
        this.previousCommentLineStartsWithAsterix = false;
        this.inMedia = false;
    }

    protected int getFormatStableStart(JoinedTokenSequence<CssTokenId> ts, int startOffset, int endOffset, AbstractIndenter.OffsetRanges rangesToIgnore) {
        ts.move(endOffset, false);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return LexUtilities.getTokenSequenceStartOffset(ts);
        }
        int balance = 0;
        do {
            Token token;
            TokenId id;
            if ((id = (token = ts.token()).id()) == CssTokenId.IDENT && ts.offset() < startOffset && balance == 0) {
                int[] index = ts.index();
                ts.moveNext();
                Token tk = LexUtilities.findNext(ts, Arrays.asList(CssTokenId.WS));
                ts.moveIndex(index);
                ts.moveNext();
                if (tk == null || tk.id() != CssTokenId.LBRACE) continue;
                if (ts.movePrevious() && (tk = LexUtilities.findPrevious(ts, Arrays.asList(CssTokenId.WS, CssTokenId.IDENT, CssTokenId.MEDIA_SYM, CssTokenId.COMMA, CssTokenId.GREATER, CssTokenId.PLUS))) != null) {
                    ts.moveNext();
                    tk = LexUtilities.findNext(ts, Arrays.asList(CssTokenId.WS));
                }
                return ts.offset();
            }
            if (id == CssTokenId.RBRACE) {
                ++balance;
                continue;
            }
            if (id == CssTokenId.LBRACE) {
                --balance;
                continue;
            }
            if (id != CssTokenId.MEDIA_SYM || ts.offset() >= startOffset || balance != 0) continue;
            return ts.offset();
        } while (ts.movePrevious());
        return LexUtilities.getTokenSequenceStartOffset(ts);
    }

    private void getIndentFromState(List<IndentCommand> iis, boolean updateState, int lineStartOffset) {
        Stack<CssStackItem> blockStack = this.getStack();
        int lastUnprocessedItem = blockStack.size();
        int i = blockStack.size() - 1;
        while (i >= 0 && !((CssStackItem)blockStack.get(i)).processed.booleanValue()) {
            lastUnprocessedItem = i--;
        }
        for (i = lastUnprocessedItem; i < blockStack.size(); ++i) {
            IndentCommand ii;
            CssStackItem item = (CssStackItem)blockStack.get(i);
            assert (!item.processed.booleanValue()) : item;
            if (item.state == StackItemState.IN_MEDIA || item.state == StackItemState.IN_RULE) {
                ii = new IndentCommand(IndentCommand.Type.INDENT, lineStartOffset);
                if (item.indent != -1) {
                    ii.setFixedIndentSize(item.indent);
                }
                iis.add(ii);
                if (!updateState) continue;
                item.processed = Boolean.TRUE;
                continue;
            }
            if (item.state == StackItemState.IN_VALUE) {
                ii = new IndentCommand(IndentCommand.Type.CONTINUE, lineStartOffset);
                if (item.indent != -1) {
                    ii.setFixedIndentSize(item.indent);
                }
                iis.add(ii);
                continue;
            }
            if (item.state != StackItemState.RULE_FINISHED && item.state != StackItemState.MEDIA_FINISHED) continue;
            ii = new IndentCommand(IndentCommand.Type.RETURN, lineStartOffset);
            iis.add(ii);
            if (!updateState) continue;
            item.processed = Boolean.TRUE;
            blockStack.remove(i);
            --i;
        }
    }

    protected List<IndentCommand> getLineIndent(IndenterContextData<CssTokenId> context, List<IndentCommand> preliminaryNextLineIndent) throws BadLocationException {
        Stack<CssStackItem> blockStack = this.getStack();
        ArrayList<IndentCommand> iis = new ArrayList<IndentCommand>();
        this.getIndentFromState(iis, true, context.getLineStartOffset());
        JoinedTokenSequence ts = context.getJoinedTokenSequences();
        ts.move(context.getLineStartOffset());
        boolean ruleWasDefined = false;
        boolean mediaWasDefined = false;
        int lastLBrace = -1;
        while (!context.isBlankLine() && ts.moveNext() && (ts.isCurrentTokenSequenceVirtual() && ts.offset() < context.getLineEndOffset() || ts.offset() <= context.getLineEndOffset())) {
            CssStackItem item;
            CssStackItem state;
            Token token = ts.token();
            if (token == null || ts.embedded() != null) continue;
            if (lastLBrace != -1 && token.id() != CssTokenId.WS) {
                state = blockStack.peek();
                assert (state.state == StackItemState.IN_RULE || state.state == StackItemState.IN_MEDIA);
                if (!this.isCommentToken((Token<CssTokenId>)token)) {
                    state.indent = ts.offset() - context.getLineNonWhiteStartOffset();
                }
                lastLBrace = -1;
            }
            if (token.id() == CssTokenId.LBRACE) {
                if (this.inMedia) {
                    this.inMedia = false;
                    lastLBrace = ts.offset();
                    blockStack.push(new CssStackItem(StackItemState.IN_MEDIA));
                    mediaWasDefined = true;
                    continue;
                }
                if (this.isInState(blockStack, StackItemState.IN_VALUE)) {
                    blockStack.pop();
                }
                state = new CssStackItem(StackItemState.IN_RULE);
                lastLBrace = ts.offset();
                blockStack.push(state);
                ruleWasDefined = true;
                continue;
            }
            if (token.id() == CssTokenId.COLON) {
                if (this.isInState(blockStack, StackItemState.IN_VALUE) || !this.isInState(blockStack, StackItemState.IN_RULE)) continue;
                blockStack.push(new CssStackItem(StackItemState.IN_VALUE));
                continue;
            }
            if (token.id() == CssTokenId.SEMI) {
                if (!this.isInState(blockStack, StackItemState.IN_VALUE)) continue;
                item = blockStack.pop();
                assert (item.state == StackItemState.IN_VALUE);
                continue;
            }
            if (token.id() == CssTokenId.RBRACE) {
                if (this.isInState(blockStack, StackItemState.IN_RULE)) {
                    item = blockStack.pop();
                    if (item.state == StackItemState.IN_VALUE) {
                        item = blockStack.pop();
                    } else if (item.state == StackItemState.RULE_FINISHED) {
                        ListIterator listIterator = blockStack.listIterator();
                        while (listIterator.hasNext()) {
                            CssStackItem stackItem = (CssStackItem)listIterator.next();
                            if (stackItem.state != StackItemState.IN_RULE) continue;
                            item = stackItem;
                            listIterator.remove();
                            break;
                        }
                        blockStack.push(new CssStackItem(StackItemState.RULE_FINISHED));
                    }
                    assert (item.state == StackItemState.IN_RULE) : item;
                    if (ts.offset() == context.getLineNonWhiteStartOffset()) {
                        iis.add(new IndentCommand(IndentCommand.Type.RETURN, context.getLineStartOffset()));
                        continue;
                    }
                    if (ruleWasDefined) continue;
                    blockStack.push(new CssStackItem(StackItemState.RULE_FINISHED));
                    continue;
                }
                if (!this.isInState(blockStack, StackItemState.IN_MEDIA)) continue;
                item = blockStack.pop();
                if (item.state == StackItemState.RULE_FINISHED) {
                    item = blockStack.pop();
                    blockStack.push(new CssStackItem(StackItemState.RULE_FINISHED));
                }
                assert (item.state == StackItemState.IN_MEDIA) : item;
                if (ts.offset() == context.getLineNonWhiteStartOffset()) {
                    iis.add(new IndentCommand(IndentCommand.Type.RETURN, context.getLineStartOffset()));
                    continue;
                }
                if (mediaWasDefined) continue;
                blockStack.push(new CssStackItem(StackItemState.MEDIA_FINISHED));
                continue;
            }
            if (this.isCommentToken((Token<CssTokenId>)token)) {
                int start = context.getLineStartOffset();
                if (start < ts.offset()) {
                    start = ts.offset();
                }
                int commentEndOffset = ts.offset() + ts.token().text().toString().trim().length() - 1;
                int end = context.getLineEndOffset();
                if (end > commentEndOffset) {
                    end = commentEndOffset;
                }
                if (start > end) {
                    assert (!this.inComment) : "token=" + token.text() + " start=" + start + " end=" + end;
                    continue;
                }
                if (start == ts.offset()) {
                    if (end >= commentEndOffset) continue;
                    this.inComment = true;
                    int lineStart = LineDocumentUtils.getLineStartOffset((LineDocument)this.getDocument(), (int)ts.offset());
                    this.preservedLineIndentation = start - lineStart;
                    continue;
                }
                if (end == commentEndOffset) {
                    String text = this.getDocument().getText(start, end - start + 1).trim();
                    if (!text.startsWith("*/") || this.previousCommentLineStartsWithAsterix) {
                        IndentCommand ic = new IndentCommand(IndentCommand.Type.PRESERVE_INDENTATION, context.getLineStartOffset());
                        ic.setFixedIndentSize(this.preservedLineIndentation);
                        iis.add(ic);
                    }
                    assert (this.inComment) : "token=" + token.text() + " start=" + start + " end=" + end;
                    this.inComment = false;
                    this.preservedLineIndentation = -1;
                    continue;
                }
                assert (this.inComment) : "token=" + token.text() + " start=" + start + " end=" + end;
                IndentCommand ic = new IndentCommand(IndentCommand.Type.PRESERVE_INDENTATION, context.getLineStartOffset());
                ic.setFixedIndentSize(this.preservedLineIndentation);
                iis.add(ic);
                this.previousCommentLineStartsWithAsterix = this.getDocument().getText(start, end - start + 1).trim().startsWith("*");
                continue;
            }
            if (token.id() != CssTokenId.MEDIA_SYM || blockStack.size() != 0) continue;
            this.inMedia = true;
        }
        if (context.isBlankLine() && this.inComment && iis.isEmpty()) {
            IndentCommand ic = new IndentCommand(IndentCommand.Type.PRESERVE_INDENTATION, context.getLineStartOffset());
            ic.setFixedIndentSize(this.preservedLineIndentation);
            iis.add(ic);
        }
        if (iis.isEmpty()) {
            iis.add(new IndentCommand(IndentCommand.Type.NO_CHANGE, context.getLineStartOffset()));
        }
        if (context.getNextLineStartOffset() != -1) {
            this.getIndentFromState(preliminaryNextLineIndent, false, context.getNextLineStartOffset());
            if (preliminaryNextLineIndent.isEmpty()) {
                preliminaryNextLineIndent.add(new IndentCommand(IndentCommand.Type.NO_CHANGE, context.getNextLineStartOffset()));
            }
        }
        return iis;
    }

    private boolean isInState(Stack<CssStackItem> stack, StackItemState state) {
        for (CssStackItem item : stack) {
            if (item.state != state) continue;
            return true;
        }
        return false;
    }

    private static class CssStackItem {
        private StackItemState state;
        private Boolean processed = false;
        private int indent;

        private CssStackItem(StackItemState state) {
            this.state = state;
            this.indent = -1;
        }

        public String toString() {
            return "CssStackItem[state=" + (Object)((Object)this.state) + ",indent=" + this.indent + ",processed=" + this.processed + "]";
        }
    }

    private static enum StackItemState {
        IN_MEDIA,
        IN_RULE,
        IN_VALUE,
        RULE_FINISHED,
        MEDIA_FINISHED;

    }
}

