/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.outputlabel;

import java.io.IOException;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.api.InputHolder;
import org.primefaces.component.outputlabel.OutputLabel;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;

public class OutputLabelRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        OutputLabel label = (OutputLabel)component;
        String clientId = label.getClientId();
        String value = ComponentUtils.getValueToRender(context, (UIComponent)label);
        UIComponent target = null;
        String targetClientId = null;
        UIInput input = null;
        String styleClass = label.getStyleClass();
        styleClass = styleClass == null ? "ui-outputlabel ui-widget" : "ui-outputlabel ui-widget " + styleClass;
        String _for = label.getFor();
        if (_for != null) {
            target = SearchExpressionFacade.resolveComponent(context, (UIComponent)label, _for);
            String string = targetClientId = target instanceof InputHolder ? ((InputHolder)target).getInputClientId() : target.getClientId(context);
            if (target instanceof UIInput) {
                input = (UIInput)target;
                if (value != null && (input.getAttributes().get("label") == null || input.getValueExpression("label") == null)) {
                    ValueExpression ve = label.getValueExpression("value");
                    if (ve != null) {
                        input.setValueExpression("label", ve);
                    } else {
                        String labelString = value;
                        int colonPos = labelString.lastIndexOf(":");
                        if (colonPos != -1) {
                            labelString = labelString.substring(0, colonPos);
                        }
                        input.getAttributes().put("label", labelString);
                    }
                }
                if (!input.isValid()) {
                    styleClass = styleClass + " ui-state-error";
                }
            }
        }
        writer.startElement("label", (UIComponent)label);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "id");
        this.renderPassThruAttributes(context, (UIComponent)label, HTML.LABEL_ATTRS);
        if (target != null) {
            writer.writeAttribute("for", (Object)targetClientId, "for");
        }
        if (value != null) {
            if (label.isEscape()) {
                writer.writeText((Object)value, "value");
            } else {
                writer.write(value);
            }
        }
        this.renderChildren(context, (UIComponent)label);
        if (input != null && input.isRequired()) {
            writer.startElement("span", (UIComponent)label);
            writer.writeAttribute("class", (Object)"ui-outputlabel-rfi", null);
            writer.write("*");
            writer.endElement("span");
        }
        writer.endElement("label");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

