/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.project.ui.Hacks;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.OpenProjectListSettings;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ProjectContainerProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class ProjectChooserAccessory
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private RequestProcessor.Task updateSubprojectsTask;
    private RequestProcessor.Task displayNameTask;
    private RequestProcessor RP;
    private RequestProcessor RP2;
    ModelUpdater modelUpdater;
    private Map<Project, Set<? extends Project>> subprojectsCache = new HashMap<Project, Set<? extends Project>>();
    private JCheckBox jCheckBoxPrime;
    private JCheckBox jCheckBoxSubprojects;
    private JLabel jLabelProjectName;
    private JList jListSubprojects;
    private JScrollPane jScrollPaneSubprojects;
    private JTextField jTextFieldProjectName;

    public ProjectChooserAccessory(JFileChooser chooser, boolean isOpenSubprojects, boolean trustAndPrime) {
        this.initComponents();
        this.modelUpdater = new ModelUpdater();
        this.RP = new RequestProcessor(ModelUpdater.class.getName(), 1);
        this.RP2 = new RequestProcessor(ModelUpdater.class.getName(), 1);
        this.updateSubprojectsTask = this.RP.create((Runnable)this.modelUpdater);
        this.updateSubprojectsTask.setPriority(1);
        this.jCheckBoxSubprojects.setSelected(isOpenSubprojects);
        this.jCheckBoxSubprojects.addActionListener(this);
        this.jCheckBoxPrime.setSelected(trustAndPrime);
        this.jCheckBoxPrime.addActionListener(this);
        chooser.addPropertyChangeListener(this);
        this.jListSubprojects.setModel(new DefaultListModel());
        this.setAccessoryEnablement(false, 0, 0);
    }

    private void initComponents() {
        this.jLabelProjectName = new JLabel();
        this.jTextFieldProjectName = new JTextField();
        this.jCheckBoxPrime = new JCheckBox();
        this.jCheckBoxSubprojects = new JCheckBox();
        this.jScrollPaneSubprojects = new JScrollPane();
        this.jListSubprojects = new JList();
        this.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 0));
        this.setLayout(new GridBagLayout());
        this.jLabelProjectName.setLabelFor(this.jTextFieldProjectName);
        Mnemonics.setLocalizedText((JLabel)this.jLabelProjectName, (String)NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_ProjectName_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jLabelProjectName, gridBagConstraints);
        this.jLabelProjectName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"AN_ProjectName"));
        this.jLabelProjectName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"AD_ProjectName"));
        this.jTextFieldProjectName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jTextFieldProjectName, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxPrime, (String)NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_Prime_CheckBox"));
        this.jCheckBoxPrime.setToolTipText(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_Prime_CheckBoxTooltipText"));
        this.jCheckBoxPrime.setMargin(new Insets(2, 0, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jCheckBoxPrime, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxSubprojects, (String)NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_Subprojects_CheckBox"));
        this.jCheckBoxSubprojects.setMargin(new Insets(2, 0, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jCheckBoxSubprojects, gridBagConstraints);
        this.jCheckBoxSubprojects.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"ACSD_ProjectChooserAccessory_jCheckBoxSubprojects"));
        this.jListSubprojects.setSelectionMode(0);
        this.jListSubprojects.setEnabled(false);
        this.jScrollPaneSubprojects.setViewportView(this.jListSubprojects);
        this.jListSubprojects.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"ACSN_ProjectChooserAccessory_jListSubprojects"));
        this.jListSubprojects.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"ACSD_ProjectChooserAccessory_jListSubprojects"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPaneSubprojects, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jCheckBoxSubprojects) {
            OpenProjectListSettings.getInstance().setOpenSubprojects(this.jCheckBoxSubprojects.isSelected());
        }
        if (e.getSource() == this.jCheckBoxPrime) {
            OpenProjectListSettings.getInstance().setTrustAndPrime(this.jCheckBoxPrime.isSelected());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("SelectedFileChangedProperty".equals(e.getPropertyName()) || "SelectedFilesChangedProperty".equals(e.getPropertyName())) {
            JFileChooser chooser = (JFileChooser)e.getSource();
            final ListModel spListModel = this.jListSubprojects.getModel();
            final File[] projectDirs = chooser.isMultiSelectionEnabled() ? chooser.getSelectedFiles() : new File[]{chooser.getSelectedFile()};
            this.jTextFieldProjectName.setText(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"MSG_PrjChooser_WaitMessage"));
            if (this.displayNameTask != null) {
                this.displayNameTask.cancel();
            }
            this.displayNameTask = this.RP2.post(new Runnable(){

                @Override
                public void run() {
                    final ArrayList<Project> projects = new ArrayList<Project>(projectDirs.length);
                    final ArrayList<String> projectNames = new ArrayList<String>(projectDirs.length);
                    for (File dir : projectDirs) {
                        if (dir == null) continue;
                        if (Thread.interrupted()) {
                            return;
                        }
                        Project project = ProjectChooserAccessory.getProject(FileUtil.normalizeFile((File)dir));
                        if (project == null) continue;
                        projects.add(project);
                        projectNames.add(ProjectUtils.getInformation((Project)project).getDisplayName());
                    }
                    if (Thread.interrupted()) {
                        return;
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!projects.isEmpty()) {
                                ProjectChooserAccessory.this.setAccessoryEnablement(true, projects.size(), ProjectChooserAccessory.countPrimable(projects));
                                if (projects.size() == 1) {
                                    String projectName = (String)projectNames.get(0);
                                    ProjectChooserAccessory.this.jTextFieldProjectName.setText(projectName);
                                    ProjectChooserAccessory.this.jTextFieldProjectName.setToolTipText(projectName);
                                } else {
                                    ProjectChooserAccessory.this.jTextFieldProjectName.setText(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_Multiselection", (Object)projects.size()));
                                    StringBuffer toolTipText = new StringBuffer("<html>");
                                    for (String str : projectNames) {
                                        toolTipText.append(str);
                                        toolTipText.append("<br>");
                                    }
                                    toolTipText.setLength(toolTipText.length() - "<br>".length());
                                    toolTipText.append("</html>");
                                    ProjectChooserAccessory.this.jTextFieldProjectName.setToolTipText(toolTipText.toString());
                                }
                                if (spListModel instanceof DefaultListModel) {
                                    ((DefaultListModel)spListModel).clear();
                                } else {
                                    ProjectChooserAccessory.this.jListSubprojects.setListData(new String[0]);
                                }
                                if (ProjectChooserAccessory.this.modelUpdater != null) {
                                    ProjectChooserAccessory.this.modelUpdater.projects = projects;
                                    ProjectChooserAccessory.this.updateSubprojectsTask.schedule(100);
                                }
                            } else {
                                ProjectChooserAccessory.this.jTextFieldProjectName.setText("");
                                if (ProjectChooserAccessory.this.modelUpdater != null) {
                                    ProjectChooserAccessory.this.modelUpdater.projects = null;
                                }
                                if (spListModel instanceof DefaultListModel) {
                                    ((DefaultListModel)spListModel).clear();
                                } else {
                                    ProjectChooserAccessory.this.jListSubprojects.setListData(new String[0]);
                                }
                                ProjectChooserAccessory.this.setAccessoryEnablement(false, 0, 0);
                                if (projectDirs.length == 1 && projectDirs[0] != null) {
                                    File dir = FileUtil.normalizeFile((File)projectDirs[0]);
                                    FileObject fo = FileUtil.toFileObject((File)dir);
                                    ProjectManager.getDefault().clearNonProjectCache();
                                    if (fo != null && fo.isFolder() && ProjectManager.getDefault().isProject(fo)) {
                                        try {
                                            Project prj = ProjectManager.getDefault().findProject(fo);
                                            if (prj == null) {
                                                ProjectChooserAccessory.this.jTextFieldProjectName.setText(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_Unrecognized"));
                                                ProjectChooserAccessory.this.jLabelProjectName.setEnabled(true);
                                                ProjectChooserAccessory.this.jTextFieldProjectName.setEnabled(true);
                                            }
                                        }
                                        catch (IOException x) {
                                            String msg = Exceptions.findLocalizedMessage((Throwable)x);
                                            if (msg == null) {
                                                msg = x.getLocalizedMessage();
                                            }
                                            ProjectChooserAccessory.this.jTextFieldProjectName.setText(msg);
                                            ProjectChooserAccessory.this.jTextFieldProjectName.setCaretPosition(0);
                                            Color error = UIManager.getColor("nb.errorForeground");
                                            if (error != null) {
                                                ProjectChooserAccessory.this.jTextFieldProjectName.setForeground(error);
                                            }
                                            ProjectChooserAccessory.this.jLabelProjectName.setEnabled(true);
                                            ProjectChooserAccessory.this.jTextFieldProjectName.setEnabled(true);
                                        }
                                    }
                                }
                            }
                        }
                    });
                }
            }, 100, 1);
        } else if ("directoryChanged".equals(e.getPropertyName())) {
            this.setAccessoryEnablement(false, 0, 0);
        }
    }

    private static int countPrimable(Iterable<Project> projects) {
        int cnt = 0;
        for (Project p : projects) {
            Lookup lkp = p.getLookup();
            ActionProvider ap = (ActionProvider)lkp.lookup(ActionProvider.class);
            if (ap == null) {
                ++cnt;
                continue;
            }
            if (!Arrays.asList(ap.getSupportedActions()).contains("prime") || !ap.isActionEnabled("prime", lkp)) continue;
            ++cnt;
        }
        return cnt;
    }

    private static Project getProject(File dir) {
        return OpenProjectList.fileToProject(dir);
    }

    private static ProjectManager.Result getProjectResult(File dir) {
        FileObject fo = FileUtil.toFileObject((File)dir);
        if (fo != null && fo.isFolder()) {
            return ProjectManager.getDefault().isProject2(fo);
        }
        return null;
    }

    private void setAccessoryEnablement(boolean enable, int numberOfProjects, int numberOfPrimable) {
        this.jLabelProjectName.setEnabled(enable);
        this.jTextFieldProjectName.setEnabled(enable);
        this.jTextFieldProjectName.setForeground(null);
        this.jCheckBoxSubprojects.setEnabled(enable);
        this.jCheckBoxPrime.setEnabled(numberOfPrimable > 0);
        this.jScrollPaneSubprojects.setEnabled(enable);
    }

    private static String relativizePath(File f1, File f2) {
        if (f1 == null || f2 == null) {
            return null;
        }
        if (!CollocationQuery.areCollocated((File)f1, (File)f2)) {
            return null;
        }
        StringBuffer b = new StringBuffer();
        File base = f1;
        String filepath = f2.getAbsolutePath();
        while (!filepath.startsWith(ProjectChooserAccessory.slashify(base.getAbsolutePath()))) {
            if ((base = base.getParentFile()) == null) {
                return null;
            }
            if (base.equals(f2)) {
                b.append("..");
                return b.toString();
            }
            b.append("../");
        }
        URI u = Utilities.toURI((File)base).relativize(Utilities.toURI((File)f2));
        assert (!u.isAbsolute()) : u + " from " + f1 + " and " + f2 + " with common root " + base;
        b.append(u.getPath());
        if (b.charAt(b.length() - 1) == '/') {
            b.setLength(b.length() - 1);
        }
        return b.toString();
    }

    private static String slashify(String path) {
        if (path.endsWith(File.separator)) {
            return path;
        }
        return path + File.separatorChar;
    }

    public static JFileChooser createProjectChooser(boolean defaultAccessory) {
        File d;
        ProjectManager.getDefault().clearNonProjectCache();
        OpenProjectListSettings opls = OpenProjectListSettings.getInstance();
        ProjectFileChooser chooser = new ProjectFileChooser();
        chooser.setFileSelectionMode(1);
        if ("GTK".equals(UIManager.getLookAndFeel().getID())) {
            chooser.putClientProperty("GTKFileChooser.showDirectoryIcons", Boolean.TRUE);
        }
        chooser.setApproveButtonText(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"BTN_PrjChooser_ApproveButtonText"));
        chooser.setApproveButtonMnemonic(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"MNM_PrjChooser_ApproveButtonText").charAt(0));
        chooser.setApproveButtonToolTipText(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"BTN_PrjChooser_ApproveButtonTooltipText"));
        chooser.setDialogTitle(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_Title"));
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(ProjectDirFilter.INSTANCE);
        chooser.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"AN_ProjectChooserAccessory"));
        chooser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectChooserAccessory.class, (String)"AD_ProjectChooserAccessory"));
        if (defaultAccessory) {
            chooser.setAccessory(new ProjectChooserAccessory(chooser, opls.isOpenSubprojects(), opls.isTrustAndPrime()));
        }
        File currDir = null;
        String dir = opls.getLastOpenProjectDir();
        if (dir != null && (d = new File(dir)).exists() && d.isDirectory()) {
            currDir = d;
        }
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, currDir);
        new ProjectFileView(chooser);
        return chooser;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.modelUpdater != null) {
            this.modelUpdater.cancel();
        }
        if (this.updateSubprojectsTask != null) {
            this.updateSubprojectsTask.cancel();
        }
        if (this.displayNameTask != null) {
            this.displayNameTask.cancel();
        }
        this.modelUpdater = null;
        this.subprojectsCache = null;
        this.updateSubprojectsTask = null;
        this.displayNameTask = null;
    }

    class ModelUpdater
    implements Runnable,
    Cancellable {
        volatile List<Project> projects;
        private DefaultListModel subprojectsToSet;
        private boolean cancel = false;

        ModelUpdater() {
        }

        @Override
        public void run() {
            if (!SwingUtilities.isEventDispatchThread()) {
                if (this.cancel) {
                    return;
                }
                List<Project> currentProjects = this.projects;
                if (currentProjects == null) {
                    return;
                }
                Map<Project, Set<? extends Project>> cache = ProjectChooserAccessory.this.subprojectsCache;
                if (cache == null) {
                    return;
                }
                ProjectChooserAccessory.this.jListSubprojects.setListData(new String[]{NbBundle.getMessage(ProjectChooserAccessory.class, (String)"MSG_PrjChooser_WaitMessage")});
                ArrayList<Project> subprojects = new ArrayList<Project>(currentProjects.size() * 5);
                for (Project p : currentProjects) {
                    if (this.cancel) {
                        return;
                    }
                    this.addSubprojects(p, subprojects, cache);
                }
                if (this.cancel) {
                    return;
                }
                ArrayList<Object> subprojectNames = new ArrayList<Object>(subprojects.size());
                if (!subprojects.isEmpty()) {
                    String pattern = NbBundle.getMessage(ProjectChooserAccessory.class, (String)"LBL_PrjChooser_SubprojectName_Format");
                    File pDir = currentProjects.size() == 1 ? FileUtil.toFile((FileObject)currentProjects.get(0).getProjectDirectory()) : null;
                    for (Project p : subprojects) {
                        if (this.cancel) {
                            return;
                        }
                        FileObject spDir = p.getProjectDirectory();
                        String relPath = null;
                        if (pDir != null) {
                            relPath = ProjectChooserAccessory.relativizePath(pDir, FileUtil.toFile((FileObject)spDir));
                        }
                        if (relPath == null) {
                            relPath = FileUtil.getFileDisplayName((FileObject)spDir);
                        }
                        String displayName = MessageFormat.format(pattern, ProjectUtils.getInformation((Project)p).getDisplayName(), relPath);
                        subprojectNames.add(displayName);
                    }
                    subprojectNames.sort(Collator.getInstance());
                }
                if (currentProjects != this.projects || this.cancel) {
                    return;
                }
                DefaultListModel<String> listModel = new DefaultListModel<String>();
                for (String string : subprojectNames) {
                    listModel.addElement(string);
                }
                this.subprojectsToSet = listModel;
                if (this.cancel) {
                    return;
                }
                SwingUtilities.invokeLater(this);
                return;
            }
            if (this.projects == null) {
                ListModel spListModel = ProjectChooserAccessory.this.jListSubprojects.getModel();
                if (spListModel instanceof DefaultListModel) {
                    ((DefaultListModel)spListModel).clear();
                } else {
                    ProjectChooserAccessory.this.jListSubprojects.setListData(new String[0]);
                }
                ProjectChooserAccessory.this.jCheckBoxSubprojects.setEnabled(false);
            } else {
                ProjectChooserAccessory.this.jListSubprojects.setModel(this.subprojectsToSet);
                ProjectChooserAccessory.this.jCheckBoxSubprojects.setEnabled(!this.subprojectsToSet.isEmpty());
                this.projects = null;
            }
        }

        void addSubprojects(Project p, List<Project> result, Map<Project, Set<? extends Project>> cache) {
            if (this.cancel) {
                return;
            }
            Set subprojects = cache.get(p);
            boolean recurse = true;
            if (subprojects == null) {
                ProjectContainerProvider pcp = (ProjectContainerProvider)p.getLookup().lookup(ProjectContainerProvider.class);
                if (pcp != null) {
                    ProjectContainerProvider.Result res = pcp.getContainedProjects();
                    if (res.isRecursive()) {
                        recurse = false;
                    }
                    if (this.cancel) {
                        return;
                    }
                    subprojects = res.getProjects();
                } else {
                    SubprojectProvider spp = (SubprojectProvider)p.getLookup().lookup(SubprojectProvider.class);
                    if (spp != null) {
                        if (this.cancel) {
                            return;
                        }
                        subprojects = spp.getSubprojects();
                    } else {
                        subprojects = Collections.emptySet();
                    }
                }
                cache.put(p, subprojects);
            }
            for (Project sp : subprojects) {
                if (this.cancel) {
                    return;
                }
                if (result.contains(sp)) continue;
                result.add(sp);
                if (!recurse) continue;
                this.addSubprojects(sp, result, cache);
            }
        }

        public boolean cancel() {
            this.cancel = true;
            return true;
        }
    }

    private static class ProjectFileChooser
    extends JFileChooser {
        private ProjectFileChooser() {
        }

        @Override
        public void approveSelection() {
            File selectedFile = this.getSelectedFile();
            if (selectedFile != null) {
                File dir = FileUtil.normalizeFile((File)selectedFile);
                FileObject fo = FileUtil.toFileObject((File)dir);
                if (fo != null && fo.isFolder() && ProjectManager.getDefault().isProject(fo)) {
                    super.approveSelection();
                } else {
                    this.setCurrentDirectory(dir);
                }
            }
        }
    }

    private static class ProjectDirFilter
    extends FileFilter {
        private static final FileFilter INSTANCE = new ProjectDirFilter();

        private ProjectDirFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return !"CVS".equalsIgnoreCase(f.getName()) || !new File(f, "Entries").exists();
            }
            return false;
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(ProjectDirFilter.class, (String)"LBL_PrjChooser_ProjectDirectoryFilter_Name");
        }
    }

    private static class ProjectFileView
    extends FileView
    implements Runnable {
        private final JFileChooser chooser;
        private final Map<File, Icon> knownProjectIcons = new HashMap<File, Icon>();
        private final RequestProcessor.Task task = Hacks.RP.create((Runnable)this);
        private File lookingForIcon;

        public ProjectFileView(JFileChooser chooser) {
            this.chooser = chooser;
            chooser.setFileView(this);
            this.task.setPriority(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Icon getIcon(File f) {
            if (f == null) {
                return null;
            }
            ProjectFileView projectFileView = this;
            synchronized (projectFileView) {
                Icon icon = this.knownProjectIcons.get(f);
                if (icon != null) {
                    return icon;
                }
            }
            if (!f.toString().matches("/[^/]+") && f.getParentFile() != null) {
                projectFileView = this;
                synchronized (projectFileView) {
                    if (this.lookingForIcon == null) {
                        this.lookingForIcon = f;
                        this.task.schedule(20);
                    }
                }
            }
            try {
                return this.chooser.getFileSystemView().getSystemIcon(f);
            }
            catch (NullPointerException ex) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Icon icon;
            if (!this.lookingForIcon.isDirectory()) {
                ProjectFileView projectFileView = this;
                synchronized (projectFileView) {
                    this.lookingForIcon = null;
                }
                return;
            }
            File d = FileUtil.normalizeFile((File)this.lookingForIcon);
            ProjectManager.Result r = ProjectChooserAccessory.getProjectResult(d);
            if (r != null) {
                icon = r.getIcon();
                if (icon == null) {
                    Project p = ProjectChooserAccessory.getProject(d);
                    icon = p != null ? ProjectUtils.getInformation((Project)p).getIcon() : this.chooser.getFileSystemView().getSystemIcon(this.lookingForIcon);
                }
            } else {
                try {
                    icon = this.chooser.getFileSystemView().getSystemIcon(this.lookingForIcon);
                }
                catch (NullPointerException ex) {
                    icon = null;
                }
            }
            ProjectFileView projectFileView = this;
            synchronized (projectFileView) {
                this.knownProjectIcons.put(this.lookingForIcon, icon);
                this.lookingForIcon = null;
            }
            this.chooser.repaint();
        }
    }
}

