/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli.commands;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.subversion.client.cli.Parser;
import org.netbeans.modules.subversion.client.cli.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class UpdateCommand
extends SvnCommand {
    private final File[] files;
    private final boolean recursive;
    private final SVNRevision rev;
    private boolean ignoreExternals;
    private long revision;

    public UpdateCommand(File[] files, SVNRevision rev, boolean recursive, boolean ignoreExternals) {
        this.files = files;
        this.recursive = recursive;
        this.rev = rev;
        this.ignoreExternals = ignoreExternals;
    }

    @Override
    protected int getCommand() {
        return 4;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("update");
        if (!this.recursive) {
            arguments.add("-N");
        }
        if (this.rev != null) {
            arguments.add(this.rev);
        }
        if (this.ignoreExternals) {
            arguments.add("--ignore-externals");
        }
        arguments.add("--force");
        for (File file : this.files) {
            arguments.add(file);
        }
        this.setCommandWorkingDirectory(this.files[0]);
    }

    public long getRevision() {
        return this.revision;
    }

    @Override
    protected void notify(Parser.Line line) {
        if (line.getRevision() != -1L) {
            this.revision = line.getRevision();
        }
    }
}

