/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.export;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.diff.options.AccessibleJFileChooser;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.ui.export.ExportPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class Export
implements DocumentListener,
FocusListener,
ActionListener {
    private static final String SCAN_AFTER_EXPORT = "scan_after_export";
    private static final String EXPORT_FROM_DIRECTORY = "exportFromDirectory";
    private final File fromFile;
    private ExportPanel panel;
    private final JButton okButton;
    private final JButton cancelButton;
    private final DialogDescriptor dialogDescriptor;

    public Export(File fromFile, boolean localChanges) {
        this.fromFile = fromFile;
        this.panel = new ExportPanel();
        this.panel.scanCheckBox.setSelected(SvnModuleConfig.getDefault().getPreferences().getBoolean(SCAN_AFTER_EXPORT, false));
        this.panel.exportFromTextField.setText(fromFile.getAbsolutePath());
        this.panel.browseToFolderButton.addActionListener(this);
        this.panel.exportToTextField.getDocument().addDocumentListener(this);
        this.panel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Export.class, (String)"CTL_ExportDialog_Title"));
        this.okButton = new JButton(NbBundle.getMessage(Export.class, (String)"CTL_Export"));
        this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Export.class, (String)"CTL_Export"));
        this.cancelButton = new JButton(NbBundle.getMessage(Export.class, (String)"CTL_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Export.class, (String)"CTL_Cancel"));
        this.dialogDescriptor = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(Export.class, (String)"CTL_ExportDialog_Title"), true, new Object[]{this.okButton, this.cancelButton}, (Object)this.okButton, 0, null, null);
        this.okButton.setEnabled(false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Export.class, (String)"CTL_ExportDialog_Title"));
        this.validateUserInput();
    }

    private void validateUserInput() {
        String toPath = this.panel.exportToTextField.getText().trim();
        if (toPath.equals("")) {
            this.okButton.setEnabled(false);
            this.setErrorText(NbBundle.getMessage(Export.class, (String)"MSG_MISSING_TO_FOLDER"));
            return;
        }
        this.resetErrorText();
        this.okButton.setEnabled(true);
    }

    void setErrorText(String txt) {
        this.panel.invalidValuesLabel.setVisible(true);
        this.panel.invalidValuesLabel.setText(txt);
    }

    private void resetErrorText() {
        this.panel.invalidValuesLabel.setVisible(false);
        this.panel.invalidValuesLabel.setText("");
    }

    File getToFile() {
        return new File(this.panel.exportToTextField.getText());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validateUserInput();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validateUserInput();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.validateUserInput();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.validateUserInput();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.panel.browseToFolderButton) {
            this.onBrowse();
        }
    }

    boolean showDialog() {
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Export.class, (String)"CTL_ExportDialog_Title"));
        dialog.setVisible(true);
        return this.dialogDescriptor.getValue() == this.okButton;
    }

    private void onBrowse() {
        File defaultDir = this.defaultWorkingDirectory();
        AccessibleJFileChooser fileChooser = new AccessibleJFileChooser(NbBundle.getMessage(Export.class, (String)"ACSD_BrowseFolder"), defaultDir);
        fileChooser.setDialogTitle(NbBundle.getMessage(Export.class, (String)"BK0010"));
        fileChooser.setMultiSelectionEnabled(false);
        FileFilter[] old = fileChooser.getChoosableFileFilters();
        for (int i = 0; i < old.length; ++i) {
            FileFilter fileFilter = old[i];
            fileChooser.removeChoosableFileFilter(fileFilter);
        }
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(Export.class, (String)"BK0008");
            }
        });
        fileChooser.setFileSelectionMode(1);
        fileChooser.showDialog(this.panel, NbBundle.getMessage(Export.class, (String)"BK0009"));
        File f = fileChooser.getSelectedFile();
        if (f != null) {
            this.panel.exportToTextField.setText(f.getAbsolutePath());
        }
    }

    private File defaultWorkingDirectory() {
        File projectFolder;
        String coDir;
        File defaultDir = null;
        String current = this.panel.exportFromTextField.getText();
        if (current != null && !current.trim().equals("")) {
            File currentFile;
            for (currentFile = new File(current); currentFile != null && !currentFile.exists(); currentFile = currentFile.getParentFile()) {
            }
            if (currentFile != null) {
                defaultDir = currentFile.isFile() ? currentFile.getParentFile() : currentFile;
            }
        }
        if (defaultDir == null && (coDir = SvnModuleConfig.getDefault().getPreferences().get(EXPORT_FROM_DIRECTORY, null)) != null) {
            defaultDir = new File(coDir);
        }
        if (defaultDir == null && (projectFolder = ProjectChooser.getProjectsFolder()).exists() && projectFolder.isDirectory()) {
            defaultDir = projectFolder;
        }
        if (defaultDir == null) {
            defaultDir = new File(System.getProperty("user.home"));
        }
        return defaultDir;
    }

    File getFromFile() {
        return this.fromFile;
    }

    boolean getScanAfterExport() {
        return this.panel.scanCheckBox.isSelected();
    }
}

