/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.modules.Dependency;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public abstract class OperationWizardModel {
    private Set<UpdateElement> primaryElements;
    private Set<UpdateElement> requiredElements = null;
    private Set<UpdateElement> customHandledElements = null;
    private Set<UpdateElement> allElements = null;
    private HashMap<UpdateElement, Collection<UpdateElement>> required2primary = new HashMap();
    private JButton originalCancel = null;
    private JButton originalNext = null;
    private JButton originalFinish = null;
    private boolean reconized = false;
    static Dimension PREFFERED_DIMENSION = new Dimension(530, 400);
    private static int MAX_TO_REPORT = 3;
    static String MORE_BROKEN_PLUGINS = "OperationWizardModel_MoreBrokenPlugins";
    private TreeMap<String, Set<UpdateElement>> dep2plugins = null;
    private Callable<OperationContainer> refreshCallable;
    private Set<String> missingModules = new HashSet<String>();

    abstract OperationType getOperation();

    abstract OperationContainer getBaseContainer();

    OperationContainer getInstallContainer() {
        return null;
    }

    abstract OperationContainer<OperationSupport> getCustomHandledContainer();

    public Set<UpdateElement> getPrimaryUpdateElements() {
        if (this.primaryElements == null) {
            this.primaryElements = new HashSet<UpdateElement>();
            for (OperationContainer.OperationInfo info : this.getBaseInfos()) {
                this.primaryElements.add(info.getUpdateElement());
            }
        }
        return this.primaryElements;
    }

    public boolean hasRequiredUpdateElements() {
        return !this.getRequiredUpdateElements().isEmpty();
    }

    public Set<UpdateElement> getRequiredUpdateElements() {
        if (this.requiredElements == null) {
            this.requiredElements = new HashSet<UpdateElement>();
            this.dep2plugins = new TreeMap();
            for (OperationContainer.OperationInfo info : this.getBaseInfos()) {
                Set reqs = info.getRequiredElements();
                Set broken = info.getBrokenDependencies();
                if (!broken.isEmpty()) {
                    for (String brokenDep : broken) {
                        if (brokenDep.toLowerCase().startsWith("package")) {
                            if (!brokenDep.contains("VirtualMachineManager")) continue;
                            brokenDep = "package";
                        } else if (brokenDep.toLowerCase().startsWith("module ")) {
                            String modName = brokenDep.substring(7).trim();
                            Set deps = Dependency.create((int)1, (String)modName);
                            for (Dependency d : deps) {
                                if (UpdateManager.getDefault().getUpdateUnits().stream().anyMatch(m -> m.getCodeName().equals(d.getName()))) continue;
                                this.missingModules.add(d.getName());
                            }
                        }
                        if (this.dep2plugins.get(brokenDep) == null) {
                            this.dep2plugins.put(brokenDep, new HashSet());
                        }
                        this.dep2plugins.get(brokenDep).add(info.getUpdateElement());
                    }
                    if (this.dep2plugins.keySet().size() >= MAX_TO_REPORT) {
                        this.dep2plugins.put(MORE_BROKEN_PLUGINS, null);
                        break;
                    }
                }
                for (UpdateElement el : reqs) {
                    if (this.required2primary.get(el) == null) {
                        this.required2primary.put(el, new HashSet());
                    }
                    this.required2primary.get(el).add(info.getUpdateElement());
                }
                this.requiredElements.addAll(reqs);
            }
            HashSet<UpdateElement> pending = new HashSet<UpdateElement>();
            for (UpdateElement el : this.requiredElements) {
                if (el == null || el.getUpdateUnit() == null || !el.getUpdateUnit().isPending()) continue;
                pending.add(el);
            }
            if (!pending.isEmpty()) {
                Logger.getLogger(OperationWizardModel.class.getName()).log(Level.INFO, "Required UpdateElements " + pending + " cannot be in pending state.");
                this.requiredElements.removeAll(pending);
            }
            this.addRequiredElements(this.requiredElements);
            this.requiredElements.removeAll(this.getPrimaryUpdateElements());
        }
        return this.requiredElements;
    }

    public boolean hasBrokenDependencies() {
        return !this.getBrokenDependency2Plugins().isEmpty();
    }

    public boolean hasCustomComponents() {
        return !this.getCustomHandledContainer().listAll().isEmpty();
    }

    public boolean hasStandardComponents() {
        return !this.getBaseContainer().listAll().isEmpty();
    }

    public Set<String> getMissingModules() {
        return this.missingModules;
    }

    public Set<UpdateElement> getCustomHandledComponents() {
        if (this.customHandledElements == null) {
            this.customHandledElements = new HashSet<UpdateElement>();
            for (OperationContainer.OperationInfo<OperationSupport> info : this.getCustomHandledInfos()) {
                this.customHandledElements.add(info.getUpdateElement());
                this.customHandledElements.addAll(info.getRequiredElements());
            }
        }
        return this.customHandledElements;
    }

    private List<OperationContainer.OperationInfo<OperationSupport>> getCustomHandledInfos() {
        return this.getCustomHandledContainer().listAll();
    }

    private List<OperationContainer.OperationInfo> getBaseInfos() {
        return this.getBaseContainer().listAll();
    }

    public SortedMap<String, Set<UpdateElement>> getBrokenDependency2Plugins() {
        if (this.dep2plugins != null) {
            return this.dep2plugins;
        }
        this.dep2plugins = new TreeMap();
        for (OperationContainer.OperationInfo info : this.getBaseInfos()) {
            Set broken = info.getBrokenDependencies();
            if (broken.isEmpty()) continue;
            for (String brokenDep : broken) {
                if (brokenDep.toLowerCase().startsWith("package")) {
                    brokenDep = "package";
                }
                if (this.dep2plugins.get(brokenDep) == null) {
                    this.dep2plugins.put(brokenDep, new HashSet());
                }
                this.dep2plugins.get(brokenDep).add(info.getUpdateElement());
            }
            if (this.dep2plugins.keySet().size() < MAX_TO_REPORT) continue;
            this.dep2plugins.put(MORE_BROKEN_PLUGINS, null);
            break;
        }
        return this.dep2plugins;
    }

    public Collection<UpdateElement> findPrimaryPlugins(UpdateElement el) {
        Collection<UpdateElement> res = new HashSet<UpdateElement>(Collections.singleton(el));
        if (this.required2primary.containsKey(el)) {
            res = this.required2primary.get(el);
        }
        return res;
    }

    public Set<UpdateElement> getAllUpdateElements() {
        if (this.allElements == null) {
            this.allElements = new HashSet<UpdateElement>(this.getPrimaryUpdateElements());
            this.allElements.addAll(this.getRequiredUpdateElements());
            assert (this.allElements.size() == this.getPrimaryUpdateElements().size() + this.getRequiredUpdateElements().size()) : "Primary [" + this.getPrimaryUpdateElements().size() + "] plus Required [" + this.getRequiredUpdateElements().size() + "] is All [" + this.allElements.size() + "] ";
        }
        return this.allElements;
    }

    public Set<UpdateElement> getAllVisibleUpdateElements() {
        HashSet<UpdateElement> visible = new HashSet<UpdateElement>();
        visible.addAll(this.getPrimaryVisibleUpdateElements());
        visible.addAll(this.getRequiredVisibleUpdateElements());
        return visible;
    }

    public Set<UpdateElement> getPrimaryVisibleUpdateElements() {
        Set<UpdateElement> primary = this.getPrimaryUpdateElements();
        Set<UpdateElement> visible = OperationWizardModel.getVisibleUpdateElements(primary, false, this.getOperation());
        return visible;
    }

    public Set<UpdateElement> getRequiredVisibleUpdateElements() {
        Set<UpdateElement> required = this.getRequiredUpdateElements();
        Set<UpdateElement> visible = OperationWizardModel.getVisibleUpdateElements(required, true, this.getOperation());
        return visible;
    }

    private static Set<UpdateElement> getVisibleUpdateElements(Set<UpdateElement> all, boolean canBeEmpty, OperationType operationType) {
        if (Utilities.modulesOnly() || OperationType.LOCAL_DOWNLOAD == operationType) {
            return all;
        }
        if (OperationType.UPDATE == operationType) {
            Set<UpdateElement> visible = new HashSet<UpdateElement>();
            HashSet<UpdateUnit> visibleUnits = new HashSet<UpdateUnit>();
            for (UpdateElement el : all) {
                if (visibleUnits.contains(el.getUpdateUnit())) continue;
                if (UpdateManager.TYPE.KIT_MODULE == el.getUpdateUnit().getType()) {
                    visible.add(el);
                    visibleUnits.add(el.getUpdateUnit());
                    continue;
                }
                UpdateUnit visibleAncestor = el.getUpdateUnit().getVisibleAncestor();
                if (visibleAncestor != null) {
                    visibleUnits.add(visibleAncestor);
                    visible.add(visibleAncestor.getInstalled());
                    continue;
                }
                visible.add(el);
                visibleUnits.add(el.getUpdateUnit());
            }
            if (visible.isEmpty() && !canBeEmpty) {
                visible = all;
            }
            return visible;
        }
        Set<UpdateElement> visible = new HashSet<UpdateElement>();
        for (UpdateElement el : all) {
            if (UpdateManager.TYPE.KIT_MODULE != el.getUpdateUnit().getType()) continue;
            visible.add(el);
        }
        if (visible.isEmpty() && !canBeEmpty) {
            visible = all;
        }
        return visible;
    }

    public void modifyOptionsForDoClose(WizardDescriptor wd) {
        this.modifyOptionsForDoClose(wd, false);
    }

    public void modifyOptionsForFailed(final WizardDescriptor wd) {
        this.recognizeButtons(wd);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                wd.setOptions((Object[])new JButton[]{OperationWizardModel.this.getOriginalCancel(wd)});
            }
        });
    }

    public void modifyOptionsForEndInstall(WizardDescriptor wd) {
        this.modifyOptionsForDoClose(wd, false);
    }

    public void modifyOptionsForDoClose(final WizardDescriptor wd, final boolean canCancel) {
        this.recognizeButtons(wd);
        final JButton b = this.getOriginalFinish(wd);
        Mnemonics.setLocalizedText((AbstractButton)b, (String)this.getBundle("InstallUnitWizardModel_Buttons_Close"));
        SwingUtilities.invokeLater(new Runnable(){
            int cnt;

            @Override
            public void run() {
                Object[] objectArray;
                b.requestFocus();
                if (this.cnt++ > 0) {
                    return;
                }
                b.setDefaultCapable(true);
                if (canCancel) {
                    JButton[] jButtonArray = new JButton[2];
                    jButtonArray[0] = b;
                    objectArray = jButtonArray;
                    jButtonArray[1] = OperationWizardModel.this.getOriginalCancel(wd);
                } else {
                    Object[] objectArray2 = new JButton[1];
                    objectArray = objectArray2;
                    objectArray2[0] = b;
                }
                Object[] arr = objectArray;
                wd.setOptions(arr);
                wd.setClosingOptions(arr);
                SwingUtilities.invokeLater(this);
            }
        });
    }

    public void modifyOptionsForStartWizard(WizardDescriptor wd) {
        this.recognizeButtons(wd);
        this.removeFinish(wd);
        Mnemonics.setLocalizedText((AbstractButton)this.getOriginalNext(wd), (String)NbBundle.getMessage(InstallUnitWizardModel.class, (String)"InstallUnitWizardModel_Buttons_MnemonicNext", (Object)this.getBundle("InstallUnitWizardModel_Buttons_Next")));
    }

    public void modifyOptionsForContinue(final WizardDescriptor wd, boolean canFinish) {
        this.recognizeButtons(wd);
        if (canFinish) {
            final JButton b = this.getOriginalFinish(wd);
            Mnemonics.setLocalizedText((AbstractButton)b, (String)this.getBundle("InstallUnitWizardModel_Buttons_Close"));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    wd.setOptions((Object[])new JButton[]{b});
                }
            });
        } else {
            this.removeFinish(wd);
            Mnemonics.setLocalizedText((AbstractButton)this.getOriginalNext(wd), (String)NbBundle.getMessage(InstallUnitWizardModel.class, (String)"InstallUnitWizardModel_Buttons_MnemonicNext", (Object)this.getBundle("InstallUnitWizardModel_Buttons_Next")));
        }
    }

    public void modifyOptionsContinueWithCancel(final WizardDescriptor wd) {
        Object[] arr;
        final JButton b = this.getOriginalNext(wd);
        JButton c = this.getOriginalCancel(wd);
        Object[] opts = wd.getOptions();
        final Object[] closingArr = new Object[]{c};
        if (!Arrays.asList(opts).contains(c)) {
            int n;
            ArrayList<Object> newOpts = new ArrayList<Object>(Arrays.asList(opts));
            Object o = wd.getProperty("OperationWizardModel_disabledCancel");
            int n2 = n = o == null ? -1 : newOpts.indexOf(o);
            if (n > -1) {
                newOpts.set(n, c);
            } else {
                n = newOpts.indexOf(b);
                if (n == -1) {
                    n = newOpts.size();
                }
                newOpts.add(n, c);
            }
            arr = newOpts.toArray();
        } else {
            arr = opts;
        }
        SwingUtilities.invokeLater(new Runnable(){
            int cnt;

            @Override
            public void run() {
                b.requestFocus();
                if (this.cnt++ > 0) {
                    return;
                }
                b.setDefaultCapable(true);
                wd.setOptions(arr);
                wd.setClosingOptions(closingArr);
                SwingUtilities.invokeLater(this);
            }
        });
    }

    public void modifyOptionsForInstall(WizardDescriptor wd) {
        this.recognizeButtons(wd);
        this.getOriginalNext(wd).setEnabled(false);
    }

    public void modifyOptionsForDoOperation(WizardDescriptor wd, int panelType) {
        this.recognizeButtons(wd);
        this.removeFinish(wd);
        block0 : switch (this.getOperation()) {
            case LOCAL_DOWNLOAD: {
                if (Containers.forUpdateNbms().listAll().isEmpty()) {
                    Mnemonics.setLocalizedText((AbstractButton)this.getOriginalNext(wd), (String)this.getBundle("InstallUnitWizardModel_Buttons_Install"));
                    break;
                }
                Mnemonics.setLocalizedText((AbstractButton)this.getOriginalNext(wd), (String)this.getBundle("InstallUnitWizardModel_Buttons_Update"));
                break;
            }
            case INSTALL: {
                Mnemonics.setLocalizedText((AbstractButton)this.getOriginalNext(wd), (String)this.getBundle("InstallUnitWizardModel_Buttons_Install"));
                break;
            }
            case UPDATE: {
                Mnemonics.setLocalizedText((AbstractButton)this.getOriginalNext(wd), (String)this.getBundle("InstallUnitWizardModel_Buttons_Update"));
                break;
            }
            case UNINSTALL: {
                Mnemonics.setLocalizedText((AbstractButton)this.getOriginalNext(wd), (String)this.getBundle("UninstallUnitWizardModel_Buttons_Uninstall"));
                break;
            }
            case ENABLE: {
                if (this.hasComponentsToInstall()) {
                    switch (panelType) {
                        case 1: {
                            Mnemonics.setLocalizedText((AbstractButton)this.getOriginalNext(wd), (String)this.getBundle("InstallUnitWizardModel_Buttons_Install"));
                            break block0;
                        }
                        case 2: {
                            Mnemonics.setLocalizedText((AbstractButton)this.getOriginalNext(wd), (String)this.getBundle("UninstallUnitWizardModel_Buttons_TurnOn"));
                            break block0;
                        }
                    }
                    Mnemonics.setLocalizedText((AbstractButton)this.getOriginalNext(wd), (String)NbBundle.getMessage(InstallUnitWizardModel.class, (String)"InstallUnitWizardModel_Buttons_MnemonicNext", (Object)this.getBundle("InstallUnitWizardModel_Buttons_Next")));
                    break;
                }
                Mnemonics.setLocalizedText((AbstractButton)this.getOriginalNext(wd), (String)this.getBundle("UninstallUnitWizardModel_Buttons_TurnOn"));
                break;
            }
            case DISABLE: {
                Mnemonics.setLocalizedText((AbstractButton)this.getOriginalNext(wd), (String)this.getBundle("UninstallUnitWizardModel_Buttons_TurnOff"));
                break;
            }
            default: {
                assert (false) : "Unknown operationType " + this.getOperation();
                break;
            }
        }
        this.getOriginalNext(wd).setEnabled(true);
    }

    public JButton getCancelButton(WizardDescriptor wd) {
        return this.getOriginalCancel(wd);
    }

    public void modifyOptionsForDisabledCancel(final WizardDescriptor wd) {
        this.recognizeButtons(wd);
        Object[] options = wd.getOptions();
        final ArrayList<JButton> newOptionsL = new ArrayList<JButton>();
        List<Object> optionsL = Arrays.asList(options);
        for (Object o : optionsL) {
            assert (o instanceof JButton) : o + " instanceof JButton";
            if (!(o instanceof JButton)) continue;
            JButton b = (JButton)o;
            if (b.equals(this.getOriginalCancel(wd))) {
                JButton disabledCancel = new JButton(b.getText());
                wd.putProperty("OperationWizardModel_disabledCancel", (Object)disabledCancel);
                disabledCancel.setEnabled(false);
                newOptionsL.add(disabledCancel);
                continue;
            }
            newOptionsL.add(b);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                wd.setOptions(newOptionsL.toArray());
            }
        });
    }

    public void doCleanup(boolean cancel) throws OperationException {
        this.getBaseContainer().removeAll();
        this.getCustomHandledContainer().removeAll();
    }

    public void recognizeButtons(WizardDescriptor wd) {
        if (!this.reconized) {
            Object[] options = wd.getOptions();
            assert (options != null) : "options: " + options;
            assert (options.length >= 4) : Arrays.asList(options) + " has lenght 4";
            assert (options[1] instanceof JButton) : options[1] + " instanceof JButton";
            this.originalNext = (JButton)options[1];
            assert (options[2] instanceof JButton) : options[2] + " instanceof JButton";
            this.originalFinish = (JButton)options[2];
            assert (options[3] instanceof JButton) : options[3] + " instanceof JButton";
            this.originalCancel = (JButton)options[3];
            this.reconized = true;
        }
    }

    private JButton getOriginalNext(WizardDescriptor wd) {
        return this.originalNext;
    }

    private JButton getOriginalCancel(WizardDescriptor wd) {
        return this.originalCancel;
    }

    private JButton getOriginalFinish(WizardDescriptor wd) {
        return this.originalFinish;
    }

    private void removeFinish(final WizardDescriptor wd) {
        Object[] options = wd.getOptions();
        final ArrayList<JButton> newOptionsL = new ArrayList<JButton>();
        List<Object> optionsL = Arrays.asList(options);
        for (Object o : optionsL) {
            JButton b;
            assert (o instanceof JButton) : o + " instanceof JButton";
            if (!(o instanceof JButton) || (b = (JButton)o).equals(this.originalFinish)) continue;
            newOptionsL.add(b);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                wd.setOptions(newOptionsL.toArray());
            }
        });
    }

    private void addRequiredElements(Set<UpdateElement> elems) {
        OperationContainer baseContainer = this.getBaseContainer();
        OperationContainer<OperationSupport> customContainer = this.getCustomHandledContainer();
        OperationContainer installContainer = this.getInstallContainer();
        for (UpdateElement el : elems) {
            if (el == null || el.getUpdateUnit() == null) {
                Logger.getLogger(OperationWizardModel.class.getName()).log(Level.INFO, "UpdateElement " + el + " cannot be null" + (String)(el == null ? "" : " or UpdateUnit " + el.getUpdateUnit() + " cannot be null"));
                continue;
            }
            if (UpdateManager.TYPE.CUSTOM_HANDLED_COMPONENT == el.getUpdateUnit().getType()) {
                customContainer.add(el);
                continue;
            }
            if (baseContainer.canBeAdded(el.getUpdateUnit(), el)) {
                baseContainer.add(el);
                continue;
            }
            if (installContainer == null || !installContainer.canBeAdded(el.getUpdateUnit(), el)) continue;
            installContainer.add(el);
        }
    }

    private String getBundle(String key) {
        return NbBundle.getMessage(InstallUnitWizardModel.class, (String)key);
    }

    public boolean hasComponentsToInstall() {
        OperationContainer oc = this.getInstallContainer();
        if (oc == null) {
            return false;
        }
        return !oc.listAll().isEmpty();
    }

    public void setRefreshCallable(Callable<OperationContainer> refreshCallable) {
        this.refreshCallable = refreshCallable;
    }

    protected void performRefresh() {
        this.requiredElements = null;
        this.dep2plugins = null;
        this.allElements = null;
        this.customHandledElements = null;
        this.primaryElements = null;
        if (this.refreshCallable != null) {
            try {
                this.refresh(this.refreshCallable.call());
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    protected void refresh(OperationContainer cont) {
    }

    public static enum OperationType {
        INSTALL,
        UNINSTALL,
        UPDATE,
        REVERT,
        ENABLE,
        DISABLE,
        LOCAL_DOWNLOAD;

    }
}

