/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.util.Enumeration;
import java.util.StringTokenizer;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.modules.PatchFor;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;
import org.openide.util.NbCollections;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.SystemAction;

@PatchFor(value=AbstractFileSystem.class)
public abstract class AbstractFileSystemCompat
extends FileSystem {
    private static SystemAction[] SYSTEM_ACTIONS;
    private static final SystemAction[] NO_SYSTEM_ACTIONS;

    @Deprecated
    public FileObject find(String aPackage, String name, String ext) {
        Enumeration st = NbCollections.checkedEnumerationByFilter((Enumeration)new StringTokenizer(aPackage, "."), String.class, (boolean)true);
        if (name == null || ext == null) {
            FileObject fo = this.afs().getAbstractRoot().find(st);
            return fo != null && fo.isFolder() ? fo : null;
        }
        Enumeration en = Enumerations.concat((Enumeration)st, (Enumeration)Enumerations.singleton((Object)(name + "." + ext)));
        return this.afs().getAbstractRoot().find(en);
    }

    private AbstractFileSystem afs() {
        return (AbstractFileSystem)this;
    }

    public SystemAction[] getActions() {
        if (!this.afs().isEnabledRefreshFolder()) {
            return NO_SYSTEM_ACTIONS;
        }
        if (SYSTEM_ACTIONS == null) {
            try {
                ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                if (l == null) {
                    l = ((Object)((Object)this)).getClass().getClassLoader();
                }
                Class<?> c = Class.forName("org.openide.actions.FileSystemRefreshAction", true, l);
                SystemAction ra = (SystemAction)SharedClassObject.findObject(c.asSubclass(SystemAction.class), (boolean)true);
                SYSTEM_ACTIONS = new SystemAction[]{ra};
            }
            catch (Exception ex) {
                SYSTEM_ACTIONS = NO_SYSTEM_ACTIONS;
            }
        }
        return SYSTEM_ACTIONS;
    }

    static {
        NO_SYSTEM_ACTIONS = new SystemAction[0];
    }
}

