/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.openide.awt.HtmlBrowser;

final class ConnectionErrorDlg
extends Box {
    private static final int MaxCharactersPerLineCount = 100;
    private static final String LINK_START = "[URL]";
    private static final String LINK_END = "[/URL]";
    private static final String FIELD_START = "[TTC]";
    private static final String FIELD_END = "[/TTC]";

    private ConnectionErrorDlg(Segment[] segments) {
        super(3);
        this.initComponents(segments);
    }

    static Object get(String msg) {
        Segment[] segments = ConnectionErrorDlg.parseMessage(msg);
        if (segments != null) {
            return new ConnectionErrorDlg(segments);
        }
        return msg;
    }

    static Segment[] parseMessage(String msg) {
        int t = 0;
        int l = 0;
        int f = 0;
        ArrayList<Segment> segments = null;
        do {
            int f2;
            int l2;
            boolean linkFirst;
            if (l >= 0) {
                l = msg.indexOf(LINK_START, l);
            }
            if (f >= 0) {
                f = msg.indexOf(FIELD_START, f);
            }
            if (l < 0 && f < 0 && segments == null) {
                return null;
            }
            if (segments == null) {
                segments = new ArrayList<Segment>();
            }
            int t2 = t;
            if (l > t) {
                t2 = l;
            }
            if (f > t && (l < 0 || f < l)) {
                t2 = f;
            }
            if (l < 0 && f < 0) {
                t2 = msg.length();
            }
            if (t2 > t) {
                int nl2;
                String text = msg.substring(t, t2);
                int nl = 0;
                while ((nl2 = text.indexOf(10, nl)) >= 0) {
                    segments.add(new Segment(SegmentKind.LABEL, text.substring(nl, nl2), true));
                    nl = nl2 + 1;
                }
                if (nl < text.length()) {
                    segments.add(new Segment(SegmentKind.LABEL, text.substring(nl)));
                }
            }
            t = t2;
            boolean bl = linkFirst = l >= 0 && (f < 0 || l < f);
            if (l >= 0 && linkFirst && (l2 = msg.indexOf(LINK_END, l += LINK_START.length())) > 0) {
                segments.add(new Segment(SegmentKind.LINK, msg.substring(l, l2)));
                t = l = l2 + LINK_END.length();
            }
            if (f < 0 || linkFirst || (f2 = msg.indexOf(FIELD_END, f += FIELD_START.length())) <= 0) continue;
            segments.add(new Segment(SegmentKind.FIELD, msg.substring(f, f2)));
            t = f = f2 + FIELD_END.length();
        } while (l > 0 || f > 0 || t < msg.length());
        return segments.toArray(new Segment[0]);
    }

    private void initComponents(Segment[] segments) {
        ArrayList<Segment> line = new ArrayList<Segment>();
        int i = 0;
        while (i < segments.length) {
            int l = segments[i].text.length();
            line.add(segments[i++]);
            while (i < segments.length && (l += segments[i].text.length()) <= 100) {
                boolean eol = segments[i].eol;
                line.add(segments[i++]);
                if (!eol) continue;
                break;
            }
            this.addLine(line);
            line.clear();
        }
    }

    private void addLine(List<Segment> line) {
        if (line.size() == 1) {
            this.addSegment(this, line.get(0));
        } else {
            Box lineBox = new Box(2);
            if (lineBox.getComponentOrientation().isLeftToRight()) {
                lineBox.setAlignmentX(0.0f);
            } else {
                lineBox.setAlignmentX(1.0f);
            }
            for (Segment s : line) {
                this.addSegment(lineBox, s);
            }
            this.add(lineBox);
        }
    }

    private void addSegment(Box box, Segment segment) {
        JComponent c;
        switch (segment.kind) {
            case FIELD: {
                JTextField f = new JTextField(segment.text);
                f.setEditable(false);
                Dimension preferredSize = f.getPreferredSize();
                f.setMinimumSize(preferredSize);
                f.setMaximumSize(preferredSize);
                f.setBorder(new EmptyBorder(f.getBorder().getBorderInsets(f)));
                c = f;
                break;
            }
            case LABEL: {
                c = new JLabel(segment.text);
                break;
            }
            case LINK: {
                String linkColor = UIManager.getBoolean("nb.dark.theme") ? "#A4A4FF" : "#0000FF";
                c = new JLabel("<html><u><font color=\"" + linkColor + "\">" + segment.text + "</font></u></html>");
                Dimension preferredSize = c.getPreferredSize();
                c.setMinimumSize(preferredSize);
                c.setMaximumSize(preferredSize);
                c.setCursor(Cursor.getPredefinedCursor(12));
                try {
                    final URL url = new URL(segment.text);
                    c.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                        }
                    });
                }
                catch (MalformedURLException malformedURLException) {}
                break;
            }
            default: {
                throw new IllegalStateException("Unknown segment kind: " + segment.kind);
            }
        }
        if (c.getComponentOrientation().isLeftToRight()) {
            c.setAlignmentX(0.0f);
        } else {
            c.setAlignmentX(1.0f);
        }
        box.add(c);
    }

    static final class Segment {
        final SegmentKind kind;
        final String text;
        final boolean eol;

        public Segment(SegmentKind kind, String text) {
            this(kind, text, false);
        }

        public Segment(SegmentKind kind, String text, boolean eol) {
            this.kind = kind;
            this.text = text;
            this.eol = eol;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Segment)) {
                return false;
            }
            Segment s = (Segment)obj;
            return this.kind == s.kind && this.text.equals(s.text) && this.eol == s.eol;
        }

        public int hashCode() {
            return this.kind.ordinal() + this.text.hashCode() + (this.eol ? 0x100000 : 0);
        }

        public String toString() {
            return "Segment(" + this.kind.name() + ")[" + this.text + "]" + (this.eol ? "\\n" : "");
        }
    }

    static enum SegmentKind {
        LABEL,
        LINK,
        FIELD;

    }
}

