/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.identity.model.UpdatePolicyDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdatePolicyRequest
extends BmcRequest<UpdatePolicyDetails> {
    private String policyId;
    private UpdatePolicyDetails updatePolicyDetails;
    private String ifMatch;

    public String getPolicyId() {
        return this.policyId;
    }

    public UpdatePolicyDetails getUpdatePolicyDetails() {
        return this.updatePolicyDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdatePolicyDetails getBody$() {
        return this.updatePolicyDetails;
    }

    public Builder toBuilder() {
        return new Builder().policyId(this.policyId).updatePolicyDetails(this.updatePolicyDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",policyId=").append(String.valueOf(this.policyId));
        sb.append(",updatePolicyDetails=").append(String.valueOf((Object)this.updatePolicyDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdatePolicyRequest)) {
            return false;
        }
        UpdatePolicyRequest other = (UpdatePolicyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.policyId, other.policyId) && Objects.equals((Object)this.updatePolicyDetails, (Object)other.updatePolicyDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.policyId == null ? 43 : this.policyId.hashCode());
        result = result * 59 + (this.updatePolicyDetails == null ? 43 : this.updatePolicyDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdatePolicyRequest, UpdatePolicyDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String policyId = null;
        private UpdatePolicyDetails updatePolicyDetails = null;
        private String ifMatch = null;

        public Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public Builder updatePolicyDetails(UpdatePolicyDetails updatePolicyDetails) {
            this.updatePolicyDetails = updatePolicyDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdatePolicyRequest o) {
            this.policyId(o.getPolicyId());
            this.updatePolicyDetails(o.getUpdatePolicyDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdatePolicyRequest build() {
            UpdatePolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdatePolicyDetails body) {
            this.updatePolicyDetails(body);
            return this;
        }

        public UpdatePolicyRequest buildWithoutInvocationCallback() {
            UpdatePolicyRequest request = new UpdatePolicyRequest();
            request.policyId = this.policyId;
            request.updatePolicyDetails = this.updatePolicyDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

