/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cloud.oracle.NotificationUtils;
import org.netbeans.modules.cloud.oracle.assets.Bundle;
import org.netbeans.modules.cloud.oracle.assets.DependenciesAnalyzer;
import org.netbeans.modules.cloud.oracle.assets.OpenProjectsFinder;
import org.netbeans.modules.cloud.oracle.assets.SuggestedItem;
import org.netbeans.modules.cloud.oracle.assets.Validator;
import org.netbeans.modules.cloud.oracle.assets.k8s.ClusterItem;
import org.netbeans.modules.cloud.oracle.bucket.BucketItem;
import org.netbeans.modules.cloud.oracle.compute.ComputeInstanceItem;
import org.netbeans.modules.cloud.oracle.database.DatabaseItem;
import org.netbeans.modules.cloud.oracle.developer.ContainerRepositoryItem;
import org.netbeans.modules.cloud.oracle.developer.MetricsNamespaceItem;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.netbeans.modules.cloud.oracle.vault.VaultItem;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public final class CloudAssets {
    private static final Logger LOG = Logger.getLogger(CloudAssets.class.getName());
    private static final String SUGGESTED = "Suggested";
    private static final String CLOUD_ASSETS_PATH = "CloudAssets";
    private static final String CLOUD_ASSETS_FILE = "default.json";
    private static CloudAssets instance = null;
    private boolean assetsLoaded = false;
    private Set<OCIItem> items = new HashSet<OCIItem>();
    private final Set<SuggestedItem> suggested = new HashSet<SuggestedItem>();
    private final Map<OCIItem, String> refNames = new HashMap<OCIItem, String>();
    private final ChangeSupport changeSupport;
    private final Gson gson;
    private final ItemsChangeListener itemsListener = new ItemsChangeListener();

    CloudAssets() {
        this.gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(OCID.class, (Object)new OCIDDeserializer()).create();
        this.changeSupport = new ChangeSupport((Object)this);
        ConnectionManager.getDefault().addConnectionListener(() -> {
            DatabaseConnection[] connections = ConnectionManager.getDefault().getConnections();
            HashSet<String> ocids = new HashSet<String>();
            for (int i = 0; i < connections.length; ++i) {
                String ocid = (String)connections[i].getConnectionProperties().get("OCID");
                if (ocid == null) continue;
                ocids.add(ocid);
            }
            boolean update = false;
            Iterator<OCIItem> it = this.items.iterator();
            while (it.hasNext()) {
                OCIItem item = it.next();
                if (ocids.contains(item.getKey().getValue()) || !"Database".equals(item.getKey().getPath())) continue;
                it.remove();
                update = true;
            }
            if (update) {
                this.update();
            }
        });
    }

    public static synchronized CloudAssets getDefault() {
        if (instance == null) {
            instance = new CloudAssets();
            instance.loadAssets();
        }
        return instance;
    }

    public synchronized boolean addItem(OCIItem newItem) {
        Parameters.notNull((CharSequence)"newItem cannot be null", (Object)newItem);
        long presentCount = this.items.stream().filter(i -> i.getKey().getPath().equals(newItem.getKey().getPath())).count();
        if ((long)newItem.maxInProject() > presentCount && this.isTenancyCompatible(newItem, true)) {
            if (newItem instanceof Validator) {
                Validator.Result result = ((Validator)((Object)newItem)).validate();
                if (result.status == Validator.ValidationStatus.WARNING) {
                    NotificationUtils.showWarningMessage(result.message);
                }
                if (result.status == Validator.ValidationStatus.ERROR) {
                    NotificationUtils.showWarningMessage(result.message);
                    return false;
                }
            }
            this.items.add(newItem);
            newItem.addChangeListener(this.itemsListener);
            this.update();
            this.storeAssets();
        }
        return true;
    }

    synchronized void removeItem(OCIItem item) {
        boolean update = false;
        item.removeChangeListener(this.itemsListener);
        if (this.refNames.remove(item) != null) {
            update = true;
        }
        if (this.items.remove(item)) {
            update = true;
        }
        if (update) {
            this.storeAssets();
            this.update();
        }
    }

    void update() {
        OpenProjectsFinder.getDefault().findOpenProjects().thenAccept(projects -> {
            DependenciesAnalyzer analyzer = new DependenciesAnalyzer();
            this.setSuggestions(analyzer.findSuggestions((Project[])projects));
        });
    }

    public synchronized String getTenancyId() {
        Optional ociItem = this.items.stream().findFirst();
        return ociItem == null || ociItem.isEmpty() ? null : ((OCIItem)ociItem.get()).getTenancyId();
    }

    public synchronized boolean isTenancyCompatible(OCIItem toCheck) {
        return this.isTenancyCompatible(toCheck, false);
    }

    public synchronized boolean isTenancyCompatible(OCIItem toCheck, boolean showWarning) {
        ArrayList<OCIItem> itemsMissingInfo = new ArrayList<OCIItem>();
        for (OCIItem item : this.items) {
            if (item != null && item.getTenancyId() == null) {
                itemsMissingInfo.add(item);
                continue;
            }
            if (!itemsMissingInfo.isEmpty() || item == null || toCheck.getTenancyId().equals(item.getTenancyId())) continue;
            if (showWarning) {
                NotificationUtils.showWarningMessage(Bundle.MSG_TenancyNotCompatible());
            }
            return false;
        }
        if (!itemsMissingInfo.isEmpty()) {
            this.suggestToAddItemsAgain(itemsMissingInfo);
            return false;
        }
        return true;
    }

    private void suggestToAddItemsAgain(List<OCIItem> itemsForRemoval) {
        String itemNames = itemsForRemoval.stream().map(OCIItem::getName).collect(Collectors.joining(", "));
        NotificationUtils.showWarningMessage(Bundle.MSG_AddItemsAgain(itemNames));
    }

    private synchronized void setSuggestions(Set<SuggestedItem> newSuggested) {
        this.suggested.clear();
        Set present = this.items.stream().map(i -> i.getKey().getPath()).collect(Collectors.toSet());
        for (SuggestedItem s : newSuggested) {
            if (present.contains(s.getPath())) continue;
            boolean add = true;
            for (String exclusivePath : s.getExclusivePaths()) {
                if (!present.contains(exclusivePath)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            this.suggested.add(s);
        }
        this.changeSupport.fireChange();
    }

    public Collection<OCIItem> getItems() {
        ArrayList<OCIItem> list = new ArrayList<OCIItem>(this.suggested);
        list.addAll(this.items);
        return list;
    }

    public List<OCIItem> getItems(String path) {
        ArrayList<OCIItem> result = new ArrayList<OCIItem>();
        for (OCIItem item : this.items) {
            if (path == null || !path.equals(item.getKey().getPath())) continue;
            result.add(item);
        }
        return result;
    }

    public Collection<OCIItem> getAssignedItems() {
        return Collections.unmodifiableCollection(this.items);
    }

    public <T extends OCIItem> T getItem(Class<T> clazz) {
        for (OCIItem item : this.items) {
            if (!clazz.isInstance(item)) continue;
            return (T)item;
        }
        return null;
    }

    public boolean itemExistWithoutReferanceName(Class<? extends OCIItem> cls) {
        return this.getReferenceNamesByClass(cls).isEmpty() && CloudAssets.getDefault().getItems().stream().anyMatch(item -> cls.isInstance(item));
    }

    public boolean referenceNameExist(String itemPath, String refName) {
        for (Map.Entry<OCIItem, String> refEntry : this.refNames.entrySet()) {
            if (!refEntry.getKey().getKey().getPath().equals(itemPath) || !refName.equals(refEntry.getValue())) continue;
            return true;
        }
        return false;
    }

    public void removeReferenceNameFor(OCIItem item) {
        this.refNames.remove(item);
    }

    public boolean setReferenceName(OCIItem item, String refName) {
        Parameters.notNull((CharSequence)"refName", (Object)refName);
        Parameters.notNull((CharSequence)"OCIItem", (Object)item);
        if (this.referenceNameExist(item.getKey().getPath(), refName)) {
            return false;
        }
        String oldRefName = this.refNames.get(item);
        this.refNames.put(item, refName);
        this.storeAssets();
        item.fireRefNameChanged(oldRefName, refName);
        return true;
    }

    public String getReferenceName(OCIItem item) {
        return this.refNames.get(item);
    }

    public List<String> getReferenceNamesByClass(Class<? extends OCIItem> cls) {
        return this.refNames.entrySet().stream().filter(entry -> cls.isInstance(entry.getKey())).map(entry -> (String)entry.getValue()).collect(Collectors.toList());
    }

    private void setReferenceName(String ocid, String refName) {
        for (OCIItem item : this.items) {
            if (!item.getKey().getValue().equals(ocid)) continue;
            this.refNames.put(item, refName);
            this.storeAssets();
            item.fireRefNameChanged(null, refName);
            return;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    synchronized void storeAssets() {
        if (!this.assetsLoaded) {
            return;
        }
        FileObject file = null;
        try {
            FileObject fo = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)CLOUD_ASSETS_PATH);
            file = fo.getFileObject(CLOUD_ASSETS_FILE);
            if (file == null) {
                file = fo.createData(CLOUD_ASSETS_FILE);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (file != null) {
            try (FileLock lock = file.lock();){
                OutputStream os = file.getOutputStream(lock);
                JsonWriter jsonWriter = this.gson.newJsonWriter((Writer)new OutputStreamWriter(os));
                jsonWriter.beginObject();
                jsonWriter.name("items").beginArray();
                for (OCIItem oCIItem : this.items) {
                    this.gson.toJson((Object)oCIItem, oCIItem.getClass(), jsonWriter);
                }
                jsonWriter.endArray();
                jsonWriter.name("referenceNames").beginArray();
                for (Map.Entry entry : this.refNames.entrySet()) {
                    jsonWriter.beginObject();
                    jsonWriter.name("ocid").value(((OCIItem)entry.getKey()).getKey().getValue());
                    jsonWriter.name("referenceName").value((String)entry.getValue());
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
                jsonWriter.endObject();
                jsonWriter.close();
                os.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void loadAssets() {
        String content;
        try {
            FileObject fo = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)CLOUD_ASSETS_PATH);
            FileObject file = fo.getFileObject(CLOUD_ASSETS_FILE);
            if (file == null) {
                return;
            }
            content = new String(file.asBytes());
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Unable to load assets", ex);
            return;
        }
        finally {
            this.assetsLoaded = true;
        }
        try (JsonReader reader = new JsonReader((Reader)new StringReader(content));){
            HashSet<OCIItem> loaded = new HashSet<OCIItem>();
            HashMap<String, String> loadingRefNames = new HashMap<String, String>();
            reader.beginObject();
            while (reader.hasNext()) {
                String rootObjName;
                switch (rootObjName = reader.nextName()) {
                    case "items": {
                        reader.beginArray();
                        while (reader.hasNext()) {
                            String path;
                            JsonElement element = JsonParser.parseReader((JsonReader)reader);
                            switch (path = element.getAsJsonObject().get("id").getAsJsonObject().get("path").getAsString()) {
                                case "Database": {
                                    loaded.add((OCIItem)this.gson.fromJson(element, DatabaseItem.class));
                                    break;
                                }
                                case "Bucket": {
                                    loaded.add((OCIItem)this.gson.fromJson(element, BucketItem.class));
                                    break;
                                }
                                case "Cluster": {
                                    loaded.add((OCIItem)this.gson.fromJson(element, ClusterItem.class));
                                    break;
                                }
                                case "ComputeInstance": {
                                    loaded.add((OCIItem)this.gson.fromJson(element, ComputeInstanceItem.class));
                                    break;
                                }
                                case "Vault": {
                                    loaded.add((OCIItem)this.gson.fromJson(element, VaultItem.class));
                                    break;
                                }
                                case "ContainerRepository": {
                                    loaded.add((OCIItem)this.gson.fromJson(element, ContainerRepositoryItem.class));
                                    break;
                                }
                                case "MetricsNamespace": {
                                    loaded.add((OCIItem)this.gson.fromJson(element, MetricsNamespaceItem.class));
                                }
                            }
                        }
                        reader.endArray();
                        break;
                    }
                    case "referenceNames": {
                        reader.beginArray();
                        while (reader.hasNext()) {
                            reader.beginObject();
                            String refOcid = null;
                            String refName = null;
                            while (reader.hasNext()) {
                                String name;
                                switch (name = reader.nextName()) {
                                    case "ocid": {
                                        refOcid = reader.nextString();
                                        break;
                                    }
                                    case "referenceName": {
                                        refName = reader.nextString();
                                        break;
                                    }
                                    default: {
                                        reader.skipValue();
                                    }
                                }
                                if (refOcid == null || refName == null) continue;
                                loadingRefNames.put(refOcid, refName);
                            }
                            reader.endObject();
                        }
                        reader.endArray();
                    }
                }
            }
            reader.endObject();
            for (OCIItem oCIItem : loaded) {
                oCIItem.addChangeListener(this.itemsListener);
            }
            this.items = loaded;
            for (Map.Entry entry : loadingRefNames.entrySet()) {
                this.setReferenceName((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (JsonIOException | JsonSyntaxException | IOException e) {
            LOG.log(Level.INFO, "Unable to load assets", e);
        }
        finally {
            this.assetsLoaded = true;
        }
    }

    private final class ItemsChangeListener
    implements PropertyChangeListener {
        private ItemsChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CloudAssets.this.storeAssets();
        }
    }

    private static final class OCIDDeserializer
    implements JsonDeserializer<OCID> {
        private OCIDDeserializer() {
        }

        public OCID deserialize(JsonElement json, Type type, JsonDeserializationContext jdc) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            String id = jsonObject.get("value").getAsString();
            String path = jsonObject.get("path").getAsString();
            return OCID.of(id, path);
        }
    }
}

