/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.nette2.ui.options;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.nette2.options.Nette2Options;
import org.netbeans.modules.php.nette2.ui.options.Bundle;
import org.netbeans.modules.php.nette2.ui.options.Nette2OptionsPanel;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class Nette2OptionsPanelController
extends OptionsPanelController
implements ChangeListener {
    static final String ID = "Nette2";
    public static final String OPTIONS_SUBPATH = "FrameworksAndTools/Nette2";
    private static final String LOADER_FILE = "loader.php";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private volatile boolean changed = false;
    private Nette2OptionsPanel nette2OptionsPanel;
    private boolean firstOpening = true;

    public static String getOptionsPath() {
        return "org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/FrameworksAndTools/Nette2";
    }

    public void update() {
        if (this.firstOpening || !this.isChanged()) {
            this.firstOpening = false;
            this.nette2OptionsPanel.setSandbox(this.getOptions().getSandbox());
            this.nette2OptionsPanel.setNetteDirectory(this.getOptions().getNetteDirectory());
        }
        this.changed = false;
    }

    private Nette2Options getOptions() {
        return Nette2Options.getInstance();
    }

    public void applyChanges() {
        this.getOptions().setSandbox(this.nette2OptionsPanel.getSandbox());
        this.getOptions().setNetteDirectory(this.nette2OptionsPanel.getNetteDirectory());
        this.changed = false;
    }

    public void cancel() {
        if (this.isChanged()) {
            this.nette2OptionsPanel.setSandbox(this.getOptions().getSandbox());
            this.nette2OptionsPanel.setNetteDirectory(this.getOptions().getNetteDirectory());
        }
    }

    public boolean isValid() {
        String warningNette = Nette2OptionsPanelController.validateNetteDirectory(this.nette2OptionsPanel.getNetteDirectory());
        if (warningNette != null) {
            this.nette2OptionsPanel.setWarning(warningNette);
            return true;
        }
        String warningSandbox = Nette2OptionsPanelController.validateSandbox(this.nette2OptionsPanel.getSandbox());
        if (warningSandbox != null) {
            this.nette2OptionsPanel.setWarning(warningSandbox);
            return true;
        }
        this.nette2OptionsPanel.setError(" ");
        return true;
    }

    public static String validateNetteDirectory(String netteDirectory) {
        File loaderPhp;
        String result = FileUtils.validateDirectory((String)Bundle.Nette2ValidationDirectory(), (String)netteDirectory, (boolean)false);
        if (result == null && (!(loaderPhp = new File(netteDirectory, LOADER_FILE)).exists() || loaderPhp.isDirectory())) {
            result = Bundle.Nette2DirectoryValidationWarning(LOADER_FILE);
        }
        return result;
    }

    public static String validateSandbox(String sandbox) {
        return FileUtils.validateDirectory((String)Bundle.Nette2ValidationSandbox(), (String)sandbox, (boolean)false);
    }

    public boolean isChanged() {
        String saved = this.getOptions().getNetteDirectory();
        String current = this.nette2OptionsPanel.getNetteDirectory().trim();
        if (saved == null ? !current.isEmpty() : !saved.equals(current)) {
            return true;
        }
        saved = this.getOptions().getSandbox();
        current = this.nette2OptionsPanel.getSandbox().trim();
        return saved == null ? !current.isEmpty() : !saved.equals(current);
    }

    public JComponent getComponent(Lookup masterLookup) {
        if (this.nette2OptionsPanel == null) {
            this.nette2OptionsPanel = new Nette2OptionsPanel();
            this.nette2OptionsPanel.addChangeListener(this);
        }
        return this.nette2OptionsPanel;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.changed) {
            this.changed = true;
            this.propertyChangeSupport.firePropertyChange("changed", false, true);
        }
        this.propertyChangeSupport.firePropertyChange("valid", null, null);
    }
}

