/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.explorer.dlg.AddConnectionWizard;
import org.netbeans.modules.db.explorer.dlg.ChoosingDriverUI;
import org.netbeans.modules.db.explorer.node.DriverNode;
import org.netbeans.modules.db.util.DriverListUtil;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class AddDriverDialog
extends JPanel {
    private static HelpCtx ADD_DRIVER_DIALOG_HELPCTX = new HelpCtx(AddDriverDialog.class);
    private DefaultListModel<String> dlm;
    private List<URL> drvs = new LinkedList<URL>();
    private boolean customizer = false;
    private ProgressHandle progressHandle;
    private JComponent progressComponent;
    private DialogDescriptor descriptor;
    private final ChoosingDriverUI wp;
    private static final Logger LOGGER = Logger.getLogger(AddDriverDialog.class.getName());
    private JDBCDriver drv;
    private final AddConnectionWizard wd;
    private volatile URLClassLoader jarClassLoader = null;
    private JButton browseButton;
    private JComboBox drvClassComboBox;
    private JLabel drvClassLabel;
    private JList drvList;
    private JLabel drvListLabel;
    private JScrollPane drvListScrollPane;
    private JButton findButton;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JPanel progressContainerPanel;
    private JLabel progressMessageLabel;
    private JButton removeButton;

    public static HelpCtx getHelpCtx() {
        return ADD_DRIVER_DIALOG_HELPCTX;
    }

    public AddDriverDialog(JDBCDriver driver, ChoosingDriverUI panel, AddConnectionWizard wd) {
        this.drv = driver;
        this.wp = panel;
        this.wd = wd;
        this.initComponents();
        if (wd != null) {
            this.drvClassLabel.setVisible(false);
            this.drvClassComboBox.setVisible(false);
            this.findButton.setVisible(false);
            this.nameLabel.setVisible(false);
            this.nameTextField.setVisible(false);
            this.progressMessageLabel.setVisible(false);
            this.progressContainerPanel.setVisible(false);
        }
        this.initAccessibility();
        this.dlm = (DefaultListModel)this.drvList.getModel();
        if (driver != null) {
            this.setDriver(driver);
        }
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddDriverDialog.this.updateState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddDriverDialog.this.updateState();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddDriverDialog.this.updateState();
            }
        };
        this.nameTextField.getDocument().addDocumentListener(documentListener);
        this.dlm.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent evt) {
                AddDriverDialog.this.updateState();
            }

            @Override
            public void intervalRemoved(ListDataEvent evt) {
                AddDriverDialog.this.updateState();
            }

            @Override
            public void contentsChanged(ListDataEvent evt) {
                AddDriverDialog.this.updateState();
            }
        });
        Component editorComponent = this.drvClassComboBox.getEditor().getEditorComponent();
        if (editorComponent instanceof JTextComponent) {
            ((JTextComponent)editorComponent).getDocument().addDocumentListener(documentListener);
        }
    }

    public void setDriver(JDBCDriver drv) {
        this.drv = drv;
        this.customizer = true;
        String fileName = null;
        this.dlm.clear();
        this.drvs.clear();
        this.jarClassLoader = null;
        URL[] urls = drv == null ? new URL[]{} : drv.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            URL localURL;
            FileObject fo;
            URL url = urls[i];
            if ("nbinst".equals(url.getProtocol()) && (fo = URLMapper.findFileObject((URL)url)) != null && (localURL = URLMapper.findURL((FileObject)fo, (int)1)) != null) {
                url = localURL;
            }
            if ((fo = URLMapper.findFileObject((URL)url)) != null) {
                File diskFile = FileUtil.toFile((FileObject)fo);
                if (diskFile != null) {
                    fileName = diskFile.getAbsolutePath();
                }
            } else if (url.getProtocol().equals("file")) {
                try {
                    fileName = new File(new URI(url.toExternalForm())).getAbsolutePath();
                }
                catch (URISyntaxException e) {
                    Exceptions.printStackTrace((Throwable)e);
                    fileName = null;
                }
            }
            if (fileName == null) continue;
            this.dlm.addElement(fileName);
            this.drvs.add(urls[i]);
        }
        if (urls.length == 0) {
            this.dlm.addElement(NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverMissingDriverFiles"));
        }
        this.drvClassComboBox.addItem(drv == null ? "" : drv.getClassName());
        this.drvClassComboBox.setSelectedItem(drv == null ? "" : drv.getClassName());
        this.nameTextField.setText(drv == null ? "" : drv.getDisplayName());
    }

    public JDBCDriver getDriver() {
        return this.drv;
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDriverDialog.class, (String)"ACS_AddDriverDialogA11yDesc"));
        this.drvListLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDriverDialog.class, (String)"ACS_AddDriverDriverFileA11yDesc"));
        this.drvList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddDriverDialog.class, (String)"ACS_AddDriverDriverFileListA11yName"));
        this.drvClassLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDriverDialog.class, (String)"ACS_AddDriverDriverDriverClassA11yDesc"));
        this.drvClassComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddDriverDialog.class, (String)"ACS_AddDriverDriverDriverClassComboBoxA11yName"));
        this.nameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDriverDialog.class, (String)"ACS_AddDriverDriverNameA11yDesc"));
        this.nameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddDriverDialog.class, (String)"ACS_AddDriverDriverNameTextFieldA11yName"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDriverDialog.class, (String)"ACS_AddDriverAddButtonA11yDesc"));
        this.findButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDriverDialog.class, (String)"ACS_AddDriverRemoveButtonA11yDesc"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDriverDialog.class, (String)"ACS_AddDriverFindButtonA11yDesc"));
        this.progressContainerPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddDriverDialog.class, (String)"ACS_AddDriverProgressBarA11yName"));
        this.progressContainerPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDriverDialog.class, (String)"ACS_AddDriverProgressBarA11yDesc"));
    }

    private void initComponents() {
        this.drvListLabel = new JLabel();
        this.drvListScrollPane = new JScrollPane();
        this.drvList = new JList();
        this.browseButton = new JButton();
        this.removeButton = new JButton();
        this.drvClassLabel = new JLabel();
        this.drvClassComboBox = new JComboBox();
        this.findButton = new JButton();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.progressMessageLabel = new JLabel();
        this.progressContainerPanel = new JPanel();
        FormListener formListener = new FormListener();
        this.drvListLabel.setLabelFor(this.drvList);
        Mnemonics.setLocalizedText((JLabel)this.drvListLabel, (String)NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverDriverFile"));
        this.drvList.setModel(new DefaultListModel());
        this.drvList.addListSelectionListener(formListener);
        this.drvListScrollPane.setViewportView(this.drvList);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverDriverAdd"));
        this.browseButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverDriverRemove"));
        this.removeButton.addActionListener(formListener);
        this.drvClassLabel.setLabelFor(this.drvClassComboBox);
        Mnemonics.setLocalizedText((JLabel)this.drvClassLabel, (String)NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverDriverClass"));
        this.drvClassComboBox.setEditable(true);
        this.drvClassComboBox.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.findButton, (String)NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverDriverFind"));
        this.findButton.addActionListener(formListener);
        this.nameLabel.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverDriverName"));
        Mnemonics.setLocalizedText((JLabel)this.progressMessageLabel, (String)" ");
        this.progressContainerPanel.setMinimumSize(new Dimension(20, 20));
        this.progressContainerPanel.setPreferredSize(new Dimension(20, 20));
        this.progressContainerPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.drvListLabel).addComponent(this.drvClassLabel).addComponent(this.nameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameTextField, -1, 258, Short.MAX_VALUE).addComponent(this.drvClassComboBox, 0, 258, Short.MAX_VALUE).addComponent(this.drvListScrollPane)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.removeButton).addComponent(this.browseButton).addComponent(this.findButton))).addComponent(this.progressMessageLabel, -1, 424, Short.MAX_VALUE).addComponent(this.progressContainerPanel, -1, 424, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.browseButton, this.findButton, this.removeButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.drvListScrollPane, -1, 64, Short.MAX_VALUE).addComponent(this.drvListLabel).addGroup(layout.createSequentialGroup().addComponent(this.browseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton))).addGap(24, 24, 24).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.drvClassComboBox, -2, -1, -2).addComponent(this.drvClassLabel).addComponent(this.findButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameTextField, -2, -1, -2).addComponent(this.nameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressContainerPanel, -2, -1, -2).addContainerGap()));
    }

    private void drvClassComboBoxActionPerformed(ActionEvent evt) {
        if (!this.customizer) {
            this.nameTextField.setText(DriverListUtil.findFreeName(DriverListUtil.getName((String)this.drvClassComboBox.getSelectedItem())));
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        this.stopProgress();
        ListSelectionModel lsm = this.drvList.getSelectionModel();
        int count = this.dlm.getSize();
        int i = 0;
        if (count < 1) {
            return;
        }
        do {
            if (lsm.isSelectedIndex(i)) {
                this.dlm.remove(i);
                this.drvs.remove(i);
                this.jarClassLoader = null;
                --count;
                continue;
            }
            ++i;
        } while (count != i);
        this.findDriverClass();
        if (this.wp != null) {
            this.wp.fireChangeEvent();
        }
        this.updateState();
    }

    private void findButtonActionPerformed(ActionEvent evt) {
        this.findDriverClassByInspection();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        this.stopProgress();
        FileChooserBuilder fileChooserBuilder = new FileChooserBuilder(AddDriverDialog.class);
        fileChooserBuilder.setTitle(NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriver_Chooser_Title"));
        fileChooserBuilder.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".jar") || f.getName().endsWith(".zip");
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriver_Chooser_Filter");
            }
        });
        File[] selectedFiles = fileChooserBuilder.showMultiOpenDialog();
        if (selectedFiles != null) {
            for (final File file : selectedFiles) {
                if (!file.isFile()) continue;
                if (this.dlm.contains(file.toString())) {
                    NotifyDescriptor.Message msgDesc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverDuplicateFile", (Object)file.toString()));
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)msgDesc);
                    continue;
                }
                if (this.drvs.isEmpty()) {
                    this.dlm.clear();
                }
                this.dlm.addElement(file.toString());
                try {
                    this.drvs.add(file.toURI().toURL());
                    this.jarClassLoader = null;
                }
                catch (MalformedURLException exc) {
                    LOGGER.log(Level.WARNING, "Unable to add driver jar file " + file.getAbsolutePath() + ": can not convert to URL", exc);
                }
                if (this.wd == null) continue;
                boolean privileged = this.wd.getAllPrivilegedNames().isEmpty();
                for (String name : this.wd.getAllPrivilegedNames()) {
                    if (!file.getName().startsWith(name)) continue;
                    privileged = true;
                    break;
                }
                if (privileged) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AddDriverDialog.this.notifyUser(null, false);
                        }
                    });
                    continue;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AddDriverDialog.this.notifyUser(NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverDialog_NotPrivilegedDriver", (Object)file.getName(), (Object)AddDriverDialog.this.wd.getPrivilegedName()), true);
                    }
                });
            }
            this.findDriverClass();
            if (this.wp != null) {
                this.wp.fireChangeEvent();
            }
        }
        this.updateState();
    }

    private void drvListValueChanged(ListSelectionEvent evt) {
        this.updateState();
    }

    private boolean isDriverClass(URLClassLoader jarloader, String className) {
        Class<?> clazz;
        try {
            clazz = jarloader.loadClass(className);
        }
        catch (Throwable t) {
            LOGGER.log(Level.FINE, null, t);
            LOGGER.log(Level.INFO, "Got an exception trying to load class " + className + " during search for JDBC drivers in  driver jar(s): " + t.getClass().getName() + ": " + t.getMessage() + ".  Skipping this class...");
            return false;
        }
        return Driver.class.isAssignableFrom(clazz);
    }

    public URL[] getDriverURLs() {
        return this.drvs.toArray(new URL[0]);
    }

    private void findDriverClass() {
        String[] drivers = DriverListUtil.getDrivers().toArray(new String[DriverListUtil.getDrivers().size()]);
        this.drvClassComboBox.removeAllItems();
        for (int i = 0; i < this.drvs.size(); ++i) {
            try {
                URL localURL;
                FileObject fo;
                URL url = this.drvs.get(i);
                if ("nbinst".equals(url.getProtocol()) && (fo = URLMapper.findFileObject((URL)url)) != null && (localURL = URLMapper.findURL((FileObject)fo, (int)1)) != null) {
                    url = localURL;
                }
                File file = new File(new URI(url.toExternalForm()));
                JarFile jf = new JarFile(file);
                for (int j = 0; j < drivers.length; ++j) {
                    if (jf.getEntry(drivers[j].replace('.', '/') + ".class") == null) continue;
                    this.addDriverClass(drivers[j]);
                }
                jf.close();
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        this.getJarClassLoader();
    }

    private void findDriverClassByInspection() {
        this.drvClassComboBox.removeAllItems();
        this.findButton.setEnabled(false);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                AddDriverDialog.this.startProgress();
                URLClassLoader jarloader = AddDriverDialog.this.getJarClassLoader();
                for (int i = 0; i < AddDriverDialog.this.dlm.size(); ++i) {
                    String file = AddDriverDialog.this.dlm.get(i);
                    try (JarFile jf = new JarFile(file);){
                        Enumeration<JarEntry> entries = jf.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            String className = entry.getName();
                            if (!className.endsWith(".class")) continue;
                            className = className.replace('/', '.');
                            if (!AddDriverDialog.this.isDriverClass(jarloader, className = className.substring(0, className.length() - 6))) continue;
                            if (AddDriverDialog.this.progressHandle != null) {
                                AddDriverDialog.this.addDriverClass(className);
                                continue;
                            }
                            AddDriverDialog.this.updateState();
                            return;
                        }
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                AddDriverDialog.this.stopProgress();
                AddDriverDialog.this.updateState();
            }
        }, 0);
    }

    private URLClassLoader getJarClassLoader() {
        this.jarClassLoader = new URLClassLoader(this.drvs.toArray(new URL[0]), this.getClass().getClassLoader());
        return this.jarClassLoader;
    }

    private void addDriverClass(String drv) {
        if (((DefaultComboBoxModel)this.drvClassComboBox.getModel()).getIndexOf(drv) < 0) {
            this.drvClassComboBox.addItem(drv);
        }
    }

    private void startProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AddDriverDialog.this.progressHandle = ProgressHandle.createHandle(null);
                AddDriverDialog.this.progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)AddDriverDialog.this.progressHandle);
                AddDriverDialog.this.progressContainerPanel.add((Component)AddDriverDialog.this.progressComponent, "Center");
                AddDriverDialog.this.progressHandle.start();
                AddDriverDialog.this.progressMessageLabel.setText(NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverProgressStart"));
            }
        });
    }

    private void stopProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AddDriverDialog.this.progressHandle != null) {
                    AddDriverDialog.this.progressHandle.finish();
                    AddDriverDialog.this.progressHandle = null;
                    AddDriverDialog.this.progressMessageLabel.setText(" ");
                    AddDriverDialog.this.progressContainerPanel.remove(AddDriverDialog.this.progressComponent);
                    AddDriverDialog.this.repaint();
                }
            }
        });
    }

    private void setDescriptor(DialogDescriptor descriptor) {
        this.descriptor = descriptor;
        this.updateState();
    }

    private void updateState() {
        boolean enable = this.getDriverURLs().length > 0;
        this.browseButton.setEnabled(this.drv != null || this.wp == null);
        this.removeButton.setEnabled(enable && this.drvList.getSelectedIndices().length > 0);
        this.findButton.setEnabled(enable && this.progressHandle == null && this.drvList.getModel().getSize() > 0);
        this.drvList.setEnabled(enable);
        String message = null;
        if (this.drvs.isEmpty()) {
            message = this.wd != null && this.wd.getDownloadFrom() != null ? NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverDownloadMissingFile", (Object)this.wd.getDownloadFrom(), (Object)this.wd.getPrivilegedName()) : NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverMissingFile");
        } else if (this.drvClassComboBox.getEditor().getItem().toString().length() == 0) {
            message = NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverMissingClass");
        } else if (this.jarClassLoader != null && !this.isDriverClass(this.jarClassLoader, this.drvClassComboBox.getEditor().getItem().toString())) {
            message = NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverNotJavaSqlDriver");
        } else if (this.nameTextField.getText().length() == 0) {
            message = NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverMissingName");
        } else if (!this.customizer && this.nameTextField.getText().length() > 0) {
            String newDisplayName = this.nameTextField.getText();
            for (JDBCDriver driver : JDBCDriverManager.getDefault().getDrivers()) {
                if (!driver.getDisplayName().equalsIgnoreCase(newDisplayName)) continue;
                message = NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverDuplicateName");
                break;
            }
        }
        this.notifyUser(message, false);
    }

    private void notifyUser(String message, boolean isWarning) {
        if (this.descriptor != null) {
            if (message != null) {
                if (isWarning) {
                    this.descriptor.getNotificationLineSupport().setWarningMessage(message);
                } else {
                    this.descriptor.getNotificationLineSupport().setInformationMessage(message);
                }
                this.descriptor.setValid(false);
            } else {
                this.descriptor.getNotificationLineSupport().clearMessages();
                this.descriptor.setValid(true);
            }
        } else if (this.wd != null) {
            if (message != null) {
                if (isWarning) {
                    this.wd.getNotificationLineSupport().setWarningMessage(message);
                } else {
                    this.wd.getNotificationLineSupport().setInformationMessage(message);
                }
            } else {
                this.wd.getNotificationLineSupport().clearMessages();
            }
        } else {
            Logger.getLogger(AddDriverDialog.class.getName()).log(Level.INFO, "DialogDescriptor or wizard is not set, cannot display message: " + message);
        }
    }

    public static JDBCDriver showDialog(DriverNode driverNode) {
        AddDriverDialog dlgPanel = new AddDriverDialog(driverNode == null ? null : driverNode.getDatabaseDriver().getJDBCDriver(), null, null);
        DialogDescriptor descriptor = new DialogDescriptor((Object)dlgPanel, NbBundle.getMessage(AddDriverDialog.class, (String)(driverNode == null ? "AddDriverDialogTitle" : "CustomizeDriverDialogTitle")));
        descriptor.setHelpCtx(AddDriverDialog.getHelpCtx());
        descriptor.createNotificationLineSupport();
        dlgPanel.setDescriptor(descriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.setVisible(true);
        JDBCDriver driver = null;
        if (DialogDescriptor.OK_OPTION == descriptor.getValue()) {
            JDBCDriver current = dlgPanel.getDriver();
            if (driverNode != null) {
                driverNode.destroy();
            }
            String drvClass = dlgPanel.getDriverClass();
            String displayName = dlgPanel.getDisplayName();
            if (current != null && !Arrays.equals(current.getURLs(), dlgPanel.getDriverURLs())) {
                JDBCDriver modified = JDBCDriver.create(current.getName(), displayName, drvClass, dlgPanel.getDriverURLs());
                try {
                    JDBCDriverManager.getDefault().removeDriver(current);
                    JDBCDriverManager.getDefault().addDriver(modified);
                }
                catch (DatabaseException ex) {
                    Logger.getLogger(AddDriverDialog.class.getName()).log(Level.WARNING, "Unable to modify driver " + current.getName() + " and add driver jar files " + Arrays.asList(dlgPanel.getDriverURLs()), ex);
                }
                driver = modified;
            } else {
                URL[] urls = dlgPanel.getDriverURLs();
                driver = JDBCDriver.create(displayName, displayName, drvClass, urls);
                try {
                    JDBCDriverManager.getDefault().addDriver(driver);
                }
                catch (DatabaseException ex) {
                    Logger.getLogger(AddDriverDialog.class.getName()).log(Level.WARNING, "Unable to add driver " + driver.getName() + " and add driver jar files " + Arrays.asList(dlgPanel.getDriverURLs()), ex);
                }
            }
        }
        return driver;
    }

    public static JDBCDriver showDialog() {
        return AddDriverDialog.showDialog(null);
    }

    private String getDriverClass() {
        return (String)this.drvClassComboBox.getSelectedItem();
    }

    private String getDisplayName() {
        return this.nameTextField.getText();
    }

    private class FormListener
    implements ActionListener,
    ListSelectionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == AddDriverDialog.this.browseButton) {
                AddDriverDialog.this.browseButtonActionPerformed(evt);
            } else if (evt.getSource() == AddDriverDialog.this.removeButton) {
                AddDriverDialog.this.removeButtonActionPerformed(evt);
            } else if (evt.getSource() == AddDriverDialog.this.drvClassComboBox) {
                AddDriverDialog.this.drvClassComboBoxActionPerformed(evt);
            } else if (evt.getSource() == AddDriverDialog.this.findButton) {
                AddDriverDialog.this.findButtonActionPerformed(evt);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            if (evt.getSource() == AddDriverDialog.this.drvList) {
                AddDriverDialog.this.drvListValueChanged(evt);
            }
        }
    }
}

