/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.jsui.vars.models;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.js.vars.DebuggerSupport;
import org.netbeans.modules.debugger.jpda.js.vars.JSVariable;
import org.netbeans.modules.debugger.jpda.js.vars.ScopeVariable;
import org.netbeans.modules.debugger.jpda.jsui.vars.models.JSWatchVar;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class VariablesJSTableModel
implements TableModelFilter {
    private final JPDADebugger debugger;

    public VariablesJSTableModel(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
    }

    public Object getValueAt(TableModel original, Object node, String columnID) throws UnknownTypeException {
        if (node instanceof JPDAWatch && !this.isEnabled((JPDAWatch)node)) {
            return original.getValueAt(node, columnID);
        }
        if (node instanceof JSWatchVar) {
            JSWatchVar jswv = (JSWatchVar)node;
            JSVariable jsVar = jswv.getJSVar();
            node = jsVar != null ? jsVar : jswv.getWatch();
        }
        if (node instanceof JSVariable) {
            JSVariable jsVar = (JSVariable)node;
            switch (columnID) {
                case "LocalsType": 
                case "WatchType": {
                    return "";
                }
                case "LocalsValue": 
                case "WatchValue": 
                case "LocalsToString": 
                case "WatchToString": {
                    return jsVar.getValue();
                }
            }
        } else {
            if (node instanceof ScopeVariable) {
                return "";
            }
            if (node instanceof ObjectVariable) {
                switch (columnID) {
                    case "LocalsType": 
                    case "WatchType": {
                        return "";
                    }
                    case "LocalsValue": 
                    case "WatchValue": 
                    case "LocalsToString": 
                    case "WatchToString": {
                        String excDescr;
                        if (node instanceof JPDAWatch && (excDescr = ((JPDAWatch)node).getExceptionDescription()) != null) {
                            int i = excDescr.indexOf(10);
                            if (i > 0) {
                                excDescr = excDescr.substring(0, i);
                            }
                            return excDescr;
                        }
                        return DebuggerSupport.getVarValue((JPDADebugger)this.debugger, (Variable)((ObjectVariable)node));
                    }
                }
            }
        }
        return original.getValueAt(node, columnID);
    }

    private boolean isEnabled(JPDAWatch jw) {
        try {
            Method getWatchMethod = jw.getClass().getMethod("getWatch", new Class[0]);
            getWatchMethod.setAccessible(true);
            Watch w = (Watch)getWatchMethod.invoke((Object)jw, new Object[0]);
            return w.isEnabled();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            return true;
        }
    }

    public boolean isReadOnly(TableModel original, Object node, String columnID) throws UnknownTypeException {
        if (node instanceof JSVariable || node instanceof ScopeVariable || node instanceof JSWatchVar) {
            return true;
        }
        return original.isReadOnly(node, columnID);
    }

    public void setValueAt(TableModel original, Object node, String columnID, Object value) throws UnknownTypeException {
        if (node instanceof JSVariable || node instanceof JSWatchVar) {
            return;
        }
        original.setValueAt(node, columnID, value);
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }
}

