/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table.celleditor;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressRunnable;
import org.openide.util.Cancellable;

class MonitorableCharacterStreamTransfer
implements ProgressRunnable<Exception>,
Cancellable {
    private Reader in;
    private Writer out;
    private int transfered;
    private Integer size;
    private boolean cancel;

    public MonitorableCharacterStreamTransfer(Reader in, Writer out, Integer knownsize) {
        this.in = in;
        this.out = out;
        this.size = knownsize;
    }

    public Exception run(ProgressHandle handle) {
        Exception result = null;
        if (handle != null && this.size != null) {
            handle.switchToDeterminate(this.size.intValue());
        }
        try {
            int read = 0;
            char[] buffer = new char[131072];
            while ((read = this.in.read(buffer)) > 0 && !this.cancel) {
                this.out.write(buffer, 0, read);
                this.transfered += read;
                if (handle == null || this.size == null) continue;
                handle.progress(this.transfered);
            }
        }
        catch (IOException ex) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return ex;
        }
        if (handle != null) {
            handle.finish();
        }
        return result;
    }

    public boolean cancel() {
        if (this.cancel) {
            return false;
        }
        this.cancel = true;
        return true;
    }

    public boolean isCancel() {
        return this.cancel;
    }
}

