/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.service;

import com.sun.xml.registry.common.ConnectionFactoryImpl;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;

public class JAXRService {
    Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.registry.service");
    private static JAXRService instance;

    private JAXRService() {
    }

    public static JAXRService getInstance() {
        if (instance == null) {
            instance = new JAXRService();
        }
        return instance;
    }

    void startService() {
        try {
            ConnectionFactoryImpl factory = new ConnectionFactoryImpl();
            InitialContext ctx = new InitialContext();
            ctx.rebind("javax.xml.registry.ConnectionFactory", (Object)factory);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    void stopService() {
        try {
            InitialContext ctx = new InitialContext();
            ctx.unbind("JAXRConnectionFactory");
            ctx.close();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            JAXRService.showUsage();
        }
        JAXRService service = JAXRService.getInstance();
        String command = args[0];
        if (command.equals("-startService")) {
            service.startService();
        } else if (command.equals("-stopService")) {
            service.stopService();
        } else {
            JAXRService.showUsage();
        }
    }

    private static void showUsage() {
        System.err.println("Must specify -startService or -stopService");
        System.exit(-1);
    }
}

