/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class IllegalInstanceOf
extends AbstractHint {
    private static Map<String, String> packagesToCheck = new HashMap<String, String>();

    public IllegalInstanceOf() {
        super(false, true, AbstractHint.HintSeverity.WARNING, new String[0]);
    }

    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.INSTANCE_OF);
    }

    public List<ErrorDescription> run(CompilationInfo info, TreePath treePath) {
        if (treePath.getLeaf().getKind() != Tree.Kind.INSTANCE_OF) {
            return null;
        }
        InstanceOfTree iot = (InstanceOfTree)treePath.getLeaf();
        TypeMirror leftTypeMirror = info.getTrees().getTypeMirror(new TreePath(treePath, iot.getExpression()));
        Element rightType = info.getTrees().getElement(new TreePath(treePath, iot.getType()));
        if (leftTypeMirror == null || leftTypeMirror.getKind() != TypeKind.DECLARED) {
            return null;
        }
        Element leftType = ((DeclaredType)leftTypeMirror).asElement();
        if (leftType == null || rightType == null || !leftType.getKind().isInterface() || !rightType.getKind().isInterface()) {
            return null;
        }
        TypeElement left = (TypeElement)leftType;
        TypeElement right = (TypeElement)rightType;
        if (left.getEnclosingElement().getKind() != ElementKind.PACKAGE || right.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
            return null;
        }
        PackageElement leftPackage = (PackageElement)left.getEnclosingElement();
        PackageElement rightPackage = (PackageElement)right.getEnclosingElement();
        String leftPackageFQN = leftPackage.getQualifiedName().toString();
        String rightPackageFQN = rightPackage.getQualifiedName().toString();
        if (packagesToCheck.containsKey(leftPackageFQN) && leftPackageFQN.equals(rightPackageFQN)) {
            String verifyClass = packagesToCheck.get(leftPackageFQN);
            TypeElement loadedVerify = info.getElements().getTypeElement(verifyClass);
            if (loadedVerify == null || !info.getTypes().isSubtype(left.asType(), loadedVerify.asType())) {
                return null;
            }
            if (!info.getTypes().isSubtype(right.asType(), loadedVerify.asType())) {
                return null;
            }
            int start = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), iot);
            int end = (int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), iot);
            return Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)NbBundle.getMessage(IllegalInstanceOf.class, (String)"MSG_IllegalInstanceOf"), (FileObject)info.getFileObject(), (int)start, (int)end));
        }
        return null;
    }

    public String getId() {
        return IllegalInstanceOf.class.getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(IllegalInstanceOf.class, (String)"LBL_IllegalInstanceOf");
    }

    public String getDescription() {
        return NbBundle.getMessage(IllegalInstanceOf.class, (String)"DSC_IllegalInstanceOf");
    }

    public void cancel() {
    }

    static {
        packagesToCheck.put("javax.lang.model.element", "javax.lang.model.element.Element");
        packagesToCheck.put("javax.lang.model.type", "javax.lang.model.type.TypeMirror");
        packagesToCheck.put("com.sun.source.tree", "com.sun.source.tree.Tree");
    }
}

