/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public final class MavenRepoURLHandler
extends URLStreamHandler {
    private static final URI CENTRAL_REPO_URI;

    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        String path = u.getPath();
        if (!path.startsWith("/")) {
            throw new IOException(path);
        }
        String stuff = path.substring(1);
        File m2Repo = new File(new File(new File(System.getProperty("user.home")), ".m2"), "repository");
        String[] pieces = stuff.split(":");
        URI uri = null;
        if (pieces.length < 4) {
            throw new IOException(stuff);
        }
        uri = this.relativeMavenURI(m2Repo.toURI(), pieces);
        File f = new File(uri);
        if (uri == null || !f.isFile()) {
            uri = this.relativeMavenURI(CENTRAL_REPO_URI, pieces);
        }
        return uri.toURL().openConnection();
    }

    private URI relativeMavenURI(URI m2Repo, String[] pieces) {
        URI groupId = m2Repo.resolve(pieces[0].replace('.', '/') + "/");
        URI dir = groupId.resolve(pieces[1] + "/").resolve(pieces[2] + "/");
        String fileName = pieces[1] + "-" + pieces[2];
        if (pieces.length == 5) {
            fileName = fileName + "-" + pieces[4];
        }
        fileName = fileName + "." + pieces[3];
        URI uri = dir.resolve(fileName);
        return uri;
    }

    static {
        try {
            CENTRAL_REPO_URI = new URI("https://repo.maven.apache.org/maven2/");
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

