/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.net;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class HttpServiceUtil {
    private HttpServiceUtil() {
    }

    public static int getHttpServicePort(BundleContext bc) {
        return HttpServiceUtil.getHttpServicePortProperty(bc, "org.osgi.service.http.port");
    }

    public static int getHttpServicePortSecure(BundleContext bc) {
        return HttpServiceUtil.getHttpServicePortProperty(bc, "org.osgi.service.http.port.secure");
    }

    /*
     * WARNING - void declaration
     */
    private static int getHttpServicePortProperty(BundleContext bc, String propertyName) {
        Object value;
        ServiceReference[] refs;
        try {
            refs = bc.getAllServiceReferences("org.osgi.service.http.HttpService", null);
        }
        catch (InvalidSyntaxException ex) {
            Logger logger = LoggerFactory.getLogger(HttpServiceUtil.class);
            logger.warn("This error should only be thrown if a filter could not be parsed. We don't use a filter...");
            return -1;
        }
        int port = -1;
        if (refs != null) {
            int candidate = Integer.MIN_VALUE;
            ServiceReference[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                block15: {
                    ServiceReference ref = serviceReferenceArray[n2];
                    value = ref.getProperty(propertyName);
                    if (value != null) {
                        int servicePort;
                        try {
                            servicePort = Integer.parseInt(value.toString());
                        }
                        catch (NumberFormatException ex) {
                            break block15;
                        }
                        value = ref.getProperty("service.ranking");
                        int serviceRanking = !(value instanceof Integer) ? 0 : (Integer)value;
                        if (serviceRanking >= candidate) {
                            candidate = serviceRanking;
                            port = servicePort;
                        }
                    }
                }
                ++n2;
            }
        }
        if (port > 0) {
            return port;
        }
        value = bc.getProperty(propertyName);
        if (value != null) {
            if (value instanceof String) {
                try {
                    return Integer.parseInt(value.toString());
                }
                catch (NumberFormatException candidate) {
                }
            } else {
                Object object = value;
                if (object instanceof Integer) {
                    void integerValue;
                    Integer candidate = (Integer)object;
                    Integer cfr_ignored_0 = (Integer)object;
                    return integerValue.intValue();
                }
            }
        }
        return -1;
    }
}

