/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.addon.marketplace;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.OpenHAB;
import org.openhab.core.addon.marketplace.MarketplaceHandlerException;
import org.openhab.core.util.UIDUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class MarketplaceBundleInstaller {
    private final Logger logger = LoggerFactory.getLogger(MarketplaceBundleInstaller.class);
    private static final Path BUNDLE_CACHE_PATH = Path.of(OpenHAB.getUserDataFolder(), "marketplace", "bundles");

    protected void addBundleToCache(String addonId, URL sourceUrl) throws MarketplaceHandlerException {
        try {
            String fileName = new File(sourceUrl.toURI().getPath()).getName();
            Path addonFile = this.getAddonCacheDirectory(addonId).resolve(fileName);
            Files.createDirectories(addonFile.getParent(), new FileAttribute[0]);
            InputStream source = sourceUrl.openStream();
            Files.copy(source, addonFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException | URISyntaxException e) {
            throw new MarketplaceHandlerException("Cannot copy bundle to local cache: " + e.getMessage(), e);
        }
    }

    protected void installFromCache(BundleContext bundleContext, String addonId) throws MarketplaceHandlerException {
        Path addonPath = this.getAddonCacheDirectory(addonId);
        if (Files.isDirectory(addonPath, new LinkOption[0])) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (Stream<Path> files = Files.list(addonPath);){
                    List<Path> bundleFiles = files.toList();
                    if (bundleFiles.size() != 1) {
                        throw new MarketplaceHandlerException("The local cache folder doesn't contain a single file: " + String.valueOf(addonPath), null);
                    }
                    Throwable throwable2 = null;
                    Object var9_13 = null;
                    try (FileInputStream fileInputStream = new FileInputStream(bundleFiles.get(0).toFile());){
                        Bundle bundle = bundleContext.installBundle(addonId, (InputStream)fileInputStream);
                        try {
                            bundle.start();
                        }
                        catch (BundleException e) {
                            this.logger.warn("The marketplace bundle was successfully installed but doesn't start: {}", (Object)e.getMessage());
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException | BundleException e) {
                throw new MarketplaceHandlerException("Cannot install bundle from marketplace cache: " + e.getMessage(), e);
            }
        }
    }

    protected boolean isBundleInstalled(BundleContext bundleContext, String addonId) {
        return bundleContext.getBundle(addonId) != null;
    }

    protected void uninstallBundle(BundleContext bundleContext, String addonId) throws MarketplaceHandlerException {
        try {
            Path addonPath = this.getAddonCacheDirectory(addonId);
            if (Files.isDirectory(addonPath, new LinkOption[0])) {
                Throwable throwable = null;
                Object var5_8 = null;
                try (Stream<Path> files = Files.list(addonPath);){
                    for (Path path : files.toList()) {
                        Files.delete(path);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            Files.delete(addonPath);
        }
        catch (IOException e) {
            throw new MarketplaceHandlerException("Failed to delete bundle-files: " + e.getMessage(), e);
        }
        if (this.isBundleInstalled(bundleContext, addonId)) {
            Bundle bundle = bundleContext.getBundle(addonId);
            try {
                bundle.stop();
                bundle.uninstall();
            }
            catch (BundleException e) {
                throw new MarketplaceHandlerException("Failed uninstalling bundle: " + e.getMessage(), e);
            }
        }
    }

    protected void ensureCachedBundlesAreInstalled(BundleContext bundleContext) {
        if (Files.isDirectory(BUNDLE_CACHE_PATH, new LinkOption[0])) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (Stream<Path> files = Files.list(BUNDLE_CACHE_PATH);){
                    files.filter(path -> Files.isDirectory(path, new LinkOption[0])).map(this::addonIdFromPath).filter(addonId -> !this.isBundleInstalled(bundleContext, (String)addonId)).forEach(addonId -> {
                        this.logger.info("Reinstalling missing marketplace bundle: {}", addonId);
                        try {
                            this.installFromCache(bundleContext, (String)addonId);
                        }
                        catch (MarketplaceHandlerException e) {
                            this.logger.warn("Failed reinstalling add-on from cache", (Throwable)e);
                        }
                    });
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.logger.warn("Failed to re-install bundles: {}", (Object)e.getMessage());
            }
        }
    }

    private String addonIdFromPath(Path path) {
        String pathName = UIDUtils.decode((String)path.getFileName().toString());
        return pathName.contains(":") ? pathName : "marketplace:" + pathName;
    }

    private Path getAddonCacheDirectory(String addonId) {
        String dir = addonId.startsWith("marketplace:") ? addonId.replace("marketplace:", "") : UIDUtils.encode((String)addonId);
        return BUNDLE_CACHE_PATH.resolve(dir);
    }
}

