/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.CoapEndpointHealth;
import org.eclipse.californium.elements.util.SimpleCounterStatistic;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CoapEndpointHealthLogger
implements CoapEndpointHealth {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)(CoapEndpoint.class.getCanonicalName() + ".health"));
    private final SimpleCounterStatistic.AlignGroup align = new SimpleCounterStatistic.AlignGroup();
    private final SimpleCounterStatistic sentRequests = new SimpleCounterStatistic("requests", this.align);
    private final SimpleCounterStatistic sentResponses = new SimpleCounterStatistic("responses", this.align);
    private final SimpleCounterStatistic sentRejects = new SimpleCounterStatistic("rejects", this.align);
    private final SimpleCounterStatistic resentRequests = new SimpleCounterStatistic("request retransmissions", this.align);
    private final SimpleCounterStatistic resentResponses = new SimpleCounterStatistic("response retransmissions", this.align);
    private final SimpleCounterStatistic sendErrors = new SimpleCounterStatistic("errors", this.align);
    private final SimpleCounterStatistic receivedRequests = new SimpleCounterStatistic("requests", this.align);
    private final SimpleCounterStatistic receivedResponses = new SimpleCounterStatistic("responses", this.align);
    private final SimpleCounterStatistic receivedRejects = new SimpleCounterStatistic("rejects", this.align);
    private final SimpleCounterStatistic duplicateRequests = new SimpleCounterStatistic("duplicate requests", this.align);
    private final SimpleCounterStatistic duplicateResponses = new SimpleCounterStatistic("duplicate responses", this.align);

    @Override
    public void dump(String tag) {
        try {
            if (this.receivedRequests.isUsed() || this.receivedResponses.isUsed()) {
                tag = StringUtil.normalizeLoggingTag((String)tag);
                String eol = StringUtil.lineSeparator();
                String head = "   " + tag;
                StringBuilder log = new StringBuilder();
                log.append(tag).append("endpoint statistic:").append(eol);
                log.append(tag).append("send statistic:").append(eol);
                log.append(head).append(this.sentRequests).append(eol);
                log.append(head).append(this.sentResponses).append(eol);
                log.append(head).append(this.sentRejects).append(eol);
                log.append(head).append(this.resentRequests).append(eol);
                log.append(head).append(this.resentResponses).append(eol);
                log.append(head).append(this.sendErrors).append(eol);
                log.append(tag).append("receive statistic:").append(eol);
                log.append(head).append(this.receivedRequests).append(eol);
                log.append(head).append(this.receivedResponses).append(eol);
                log.append(head).append(this.receivedRejects).append(eol);
                log.append(head).append(this.duplicateRequests).append(eol);
                log.append(head).append(this.duplicateResponses);
                LOGGER.debug("{}", (Object)log);
            }
        }
        catch (Throwable e) {
            LOGGER.error("{}", (Object)tag, (Object)e);
        }
    }

    @Override
    public boolean isEnabled() {
        return LOGGER.isDebugEnabled();
    }

    @Override
    public void receivedRequest(boolean duplicate) {
        if (duplicate) {
            this.duplicateRequests.increment();
        } else {
            this.receivedRequests.increment();
        }
    }

    @Override
    public void receivedResponse(boolean duplicate) {
        if (duplicate) {
            this.duplicateResponses.increment();
        } else {
            this.receivedResponses.increment();
        }
    }

    @Override
    public void receivedReject() {
        this.receivedRejects.increment();
    }

    @Override
    public void sentRequest(boolean retransmission) {
        if (retransmission) {
            this.resentRequests.increment();
        } else {
            this.sentRequests.increment();
        }
    }

    @Override
    public void sentResponse(boolean retransmission) {
        if (retransmission) {
            this.resentResponses.increment();
        } else {
            this.sentResponses.increment();
        }
    }

    @Override
    public void sentReject() {
        this.sentRejects.increment();
    }

    @Override
    public void sendError() {
        this.sendErrors.increment();
    }
}

