/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.scan;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.NamedExpression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.expression.aggregation.NamedAggregator;
import org.opensearch.sql.opensearch.request.OpenSearchRequestBuilder;
import org.opensearch.sql.opensearch.response.agg.OpenSearchAggregationResponseParser;
import org.opensearch.sql.opensearch.storage.scan.PushDownQueryBuilder;
import org.opensearch.sql.opensearch.storage.script.aggregation.AggregationQueryBuilder;
import org.opensearch.sql.opensearch.storage.serde.DefaultExpressionSerializer;
import org.opensearch.sql.planner.logical.LogicalAggregation;
import org.opensearch.sql.planner.logical.LogicalFilter;
import org.opensearch.sql.planner.logical.LogicalSort;

class OpenSearchIndexScanAggregationBuilder
implements PushDownQueryBuilder {
    private final OpenSearchRequestBuilder requestBuilder;
    private final List<NamedAggregator> aggregatorList;
    private final List<NamedExpression> groupByList;
    private List<Pair<Sort.SortOption, Expression>> sortList;
    private final boolean bucketNullable;

    OpenSearchIndexScanAggregationBuilder(OpenSearchRequestBuilder requestBuilder, LogicalAggregation aggregation) {
        this.requestBuilder = requestBuilder;
        this.aggregatorList = aggregation.getAggregatorList();
        this.groupByList = aggregation.getGroupByList();
        this.bucketNullable = aggregation.isBucketNullable();
    }

    @Override
    public OpenSearchRequestBuilder build() {
        AggregationQueryBuilder builder = new AggregationQueryBuilder(new DefaultExpressionSerializer());
        Pair<List<AggregationBuilder>, OpenSearchAggregationResponseParser> aggregationBuilder = builder.buildAggregationBuilder(this.aggregatorList, this.groupByList, this.sortList, this.bucketNullable);
        this.requestBuilder.pushDownAggregation(aggregationBuilder);
        this.requestBuilder.pushTypeMapping(builder.buildTypeMapping(this.aggregatorList, this.groupByList));
        return this.requestBuilder;
    }

    @Override
    public boolean pushDownFilter(LogicalFilter filter) {
        return false;
    }

    @Override
    public boolean pushDownSort(LogicalSort sort) {
        if (this.hasAggregatorInSortBy(sort)) {
            return false;
        }
        this.sortList = sort.getSortList();
        return true;
    }

    private boolean hasAggregatorInSortBy(LogicalSort sort) {
        Set aggregatorNames = this.aggregatorList.stream().map(NamedAggregator::getName).collect(Collectors.toSet());
        for (Pair<Sort.SortOption, Expression> sortPair : sort.getSortList()) {
            if (!aggregatorNames.contains(((ReferenceExpression)sortPair.getRight()).getAttr())) continue;
            return true;
        }
        return false;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSearchIndexScanAggregationBuilder)) {
            return false;
        }
        OpenSearchIndexScanAggregationBuilder other = (OpenSearchIndexScanAggregationBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.bucketNullable != other.bucketNullable) {
            return false;
        }
        OpenSearchRequestBuilder this$requestBuilder = this.requestBuilder;
        OpenSearchRequestBuilder other$requestBuilder = other.requestBuilder;
        if (this$requestBuilder == null ? other$requestBuilder != null : !((Object)this$requestBuilder).equals(other$requestBuilder)) {
            return false;
        }
        List<NamedAggregator> this$aggregatorList = this.aggregatorList;
        List<NamedAggregator> other$aggregatorList = other.aggregatorList;
        if (this$aggregatorList == null ? other$aggregatorList != null : !((Object)this$aggregatorList).equals(other$aggregatorList)) {
            return false;
        }
        List<NamedExpression> this$groupByList = this.groupByList;
        List<NamedExpression> other$groupByList = other.groupByList;
        if (this$groupByList == null ? other$groupByList != null : !((Object)this$groupByList).equals(other$groupByList)) {
            return false;
        }
        List<Pair<Sort.SortOption, Expression>> this$sortList = this.sortList;
        List<Pair<Sort.SortOption, Expression>> other$sortList = other.sortList;
        return !(this$sortList == null ? other$sortList != null : !((Object)this$sortList).equals(other$sortList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OpenSearchIndexScanAggregationBuilder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.bucketNullable ? 79 : 97);
        OpenSearchRequestBuilder $requestBuilder = this.requestBuilder;
        result = result * 59 + ($requestBuilder == null ? 43 : ((Object)$requestBuilder).hashCode());
        List<NamedAggregator> $aggregatorList = this.aggregatorList;
        result = result * 59 + ($aggregatorList == null ? 43 : ((Object)$aggregatorList).hashCode());
        List<NamedExpression> $groupByList = this.groupByList;
        result = result * 59 + ($groupByList == null ? 43 : ((Object)$groupByList).hashCode());
        List<Pair<Sort.SortOption, Expression>> $sortList = this.sortList;
        result = result * 59 + ($sortList == null ? 43 : ((Object)$sortList).hashCode());
        return result;
    }
}

