/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.template.mustache;

import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.o19s.es.template.mustache.CustomMustacheFactory;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.Permission;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.SpecialPermission;

public class MustacheUtils {
    public static final String TEMPLATE_LANGUAGE = "mustache";
    private static final Logger logger = LogManager.getLogger(MustacheUtils.class);
    private static final SpecialPermission SPECIAL_PERMS = new SpecialPermission();
    private static final CustomMustacheFactory FACTORY = new CustomMustacheFactory();

    public static Mustache compile(String name, String template) {
        try {
            return FACTORY.compile(new StringReader(template), name);
        }
        catch (MustacheException me) {
            throw new IllegalArgumentException(me.getMessage(), me);
        }
    }

    public static String execute(Mustache template, Map<String, Object> params) {
        StringWriter writer = new StringWriter();
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)SPECIAL_PERMS);
            }
            AccessController.doPrivileged(() -> {
                template.execute((Writer)writer, (Object)params);
                return null;
            });
        }
        catch (Exception e) {
            logger.error(() -> new ParameterizedMessage("Error running {}", (Object)template), (Throwable)e);
            throw new IllegalArgumentException("Error running " + String.valueOf(template), e);
        }
        return writer.toString();
    }
}

