/*
 * Decompiled with CFR 0.152.
 */
package StandardLibrary_mUInt_Compile;

import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;

public class __default {
    public static boolean UInt8Less(byte a, byte b) {
        return Integer.compareUnsigned(a, b) < 0;
    }

    public static <__T> boolean HasUint16Len(TypeDescriptor<__T> _td___T, DafnySequence<? extends __T> s) {
        return BigInteger.valueOf(s.length()).compareTo(__default.UINT16__LIMIT()) < 0;
    }

    public static <__T> boolean HasUint32Len(TypeDescriptor<__T> _td___T, DafnySequence<? extends __T> s) {
        return BigInteger.valueOf(s.length()).compareTo(__default.UINT32__LIMIT()) < 0;
    }

    public static <__T> boolean HasUint64Len(TypeDescriptor<__T> _td___T, DafnySequence<? extends __T> s) {
        return BigInteger.valueOf(s.length()).compareTo(__default.UINT64__LIMIT()) < 0;
    }

    public static boolean HasUint16Size(BigInteger s) {
        return s.compareTo(__default.UINT16__LIMIT()) < 0;
    }

    public static boolean HasUint32Size(BigInteger s) {
        return s.compareTo(__default.UINT32__LIMIT()) < 0;
    }

    public static boolean HasUint64Size(BigInteger s) {
        return s.compareTo(__default.UINT64__LIMIT()) < 0;
    }

    public static DafnySequence<? extends Byte> UInt16ToSeq(short x) {
        byte _0_b0 = (byte)Helpers.divideUnsignedShort((short)x, (short)256);
        byte _1_b1 = (byte)Helpers.remainderUnsignedShort((short)x, (short)256);
        return DafnySequence.of((byte[])new byte[]{_0_b0, _1_b1});
    }

    public static short SeqToUInt16(DafnySequence<? extends Byte> s) {
        short _0_x0 = (short)((short)Byte.toUnsignedInt((Byte)s.select(0)) * 256);
        return (short)(_0_x0 + (short)Byte.toUnsignedInt((Byte)s.select(1)));
    }

    public static short SeqPosToUInt16(DafnySequence<? extends Byte> s, long pos) {
        short _0_x0 = (short)((short)Byte.toUnsignedInt((Byte)s.select(Helpers.unsignedToInt((long)pos))) * 256);
        return (short)(_0_x0 + (short)Byte.toUnsignedInt((Byte)s.select(Helpers.unsignedToInt((long)(pos + 1L)))));
    }

    public static int SeqPosToUInt32(DafnySequence<? extends Byte> s, long pos) {
        int _0_x0 = Byte.toUnsignedInt((Byte)s.select(Helpers.unsignedToInt((long)pos))) * 0x1000000;
        int _1_x1 = _0_x0 + Byte.toUnsignedInt((Byte)s.select(Helpers.unsignedToInt((long)(pos + 1L)))) * 65536;
        int _2_x2 = _1_x1 + Byte.toUnsignedInt((Byte)s.select(Helpers.unsignedToInt((long)(pos + 2L)))) * 256;
        return _2_x2 + Byte.toUnsignedInt((Byte)s.select(Helpers.unsignedToInt((long)(pos + 3L))));
    }

    public static long SeqPosToUInt64(DafnySequence<? extends Byte> s, long pos) {
        long _0_x0 = Byte.toUnsignedLong((Byte)s.select(Helpers.unsignedToInt((long)pos))) * 0x100000000000000L;
        long _1_x1 = _0_x0 + Byte.toUnsignedLong((Byte)s.select(Helpers.unsignedToInt((long)(pos + 1L)))) * 0x1000000000000L;
        long _2_x2 = _1_x1 + Byte.toUnsignedLong((Byte)s.select(Helpers.unsignedToInt((long)(pos + 2L)))) * 0x10000000000L;
        long _3_x3 = _2_x2 + Byte.toUnsignedLong((Byte)s.select(Helpers.unsignedToInt((long)(pos + 3L)))) * 0x100000000L;
        long _4_x4 = _3_x3 + Byte.toUnsignedLong((Byte)s.select(Helpers.unsignedToInt((long)(pos + 4L)))) * 0x1000000L;
        long _5_x5 = _4_x4 + Byte.toUnsignedLong((Byte)s.select(Helpers.unsignedToInt((long)(pos + 5L)))) * 65536L;
        long _6_x6 = _5_x5 + Byte.toUnsignedLong((Byte)s.select(Helpers.unsignedToInt((long)(pos + 6L)))) * 256L;
        long _7_x = _6_x6 + Byte.toUnsignedLong((Byte)s.select(Helpers.unsignedToInt((long)(pos + 7L))));
        return _7_x;
    }

    public static DafnySequence<? extends Byte> UInt32ToSeq(int x) {
        byte _0_b0 = (byte)Integer.divideUnsigned(x, 0x1000000);
        int _1_x0 = x - Byte.toUnsignedInt(_0_b0) * 0x1000000;
        byte _2_b1 = (byte)Integer.divideUnsigned(_1_x0, 65536);
        int _3_x1 = _1_x0 - Byte.toUnsignedInt(_2_b1) * 65536;
        byte _4_b2 = (byte)Integer.divideUnsigned(_3_x1, 256);
        byte _5_b3 = (byte)Integer.remainderUnsigned(_3_x1, 256);
        return DafnySequence.of((byte[])new byte[]{_0_b0, _2_b1, _4_b2, _5_b3});
    }

    public static int SeqToUInt32(DafnySequence<? extends Byte> s) {
        int _0_x0 = Byte.toUnsignedInt((Byte)s.select(0)) * 0x1000000;
        int _1_x1 = _0_x0 + Byte.toUnsignedInt((Byte)s.select(1)) * 65536;
        int _2_x2 = _1_x1 + Byte.toUnsignedInt((Byte)s.select(2)) * 256;
        return _2_x2 + Byte.toUnsignedInt((Byte)s.select(3));
    }

    public static DafnySequence<? extends Byte> UInt64ToSeq(long x) {
        byte _0_b0 = (byte)Long.divideUnsigned(x, 0x100000000000000L);
        long _1_x0 = x - Byte.toUnsignedLong(_0_b0) * 0x100000000000000L;
        byte _2_b1 = (byte)Long.divideUnsigned(_1_x0, 0x1000000000000L);
        long _3_x1 = _1_x0 - Byte.toUnsignedLong(_2_b1) * 0x1000000000000L;
        byte _4_b2 = (byte)Long.divideUnsigned(_3_x1, 0x10000000000L);
        long _5_x2 = _3_x1 - Byte.toUnsignedLong(_4_b2) * 0x10000000000L;
        byte _6_b3 = (byte)Long.divideUnsigned(_5_x2, 0x100000000L);
        long _7_x3 = _5_x2 - Byte.toUnsignedLong(_6_b3) * 0x100000000L;
        byte _8_b4 = (byte)Long.divideUnsigned(_7_x3, 0x1000000L);
        long _9_x4 = _7_x3 - Byte.toUnsignedLong(_8_b4) * 0x1000000L;
        byte _10_b5 = (byte)Long.divideUnsigned(_9_x4, 65536L);
        long _11_x5 = _9_x4 - Byte.toUnsignedLong(_10_b5) * 65536L;
        byte _12_b6 = (byte)Long.divideUnsigned(_11_x5, 256L);
        byte _13_b7 = (byte)Long.remainderUnsigned(_11_x5, 256L);
        return DafnySequence.of((byte[])new byte[]{_0_b0, _2_b1, _4_b2, _6_b3, _8_b4, _10_b5, _12_b6, _13_b7});
    }

    public static long SeqToUInt64(DafnySequence<? extends Byte> s) {
        long _0_x0 = Byte.toUnsignedLong((Byte)s.select(0)) * 0x100000000000000L;
        long _1_x1 = _0_x0 + Byte.toUnsignedLong((Byte)s.select(1)) * 0x1000000000000L;
        long _2_x2 = _1_x1 + Byte.toUnsignedLong((Byte)s.select(2)) * 0x10000000000L;
        long _3_x3 = _2_x2 + Byte.toUnsignedLong((Byte)s.select(3)) * 0x100000000L;
        long _4_x4 = _3_x3 + Byte.toUnsignedLong((Byte)s.select(4)) * 0x1000000L;
        long _5_x5 = _4_x4 + Byte.toUnsignedLong((Byte)s.select(5)) * 65536L;
        long _6_x6 = _5_x5 + Byte.toUnsignedLong((Byte)s.select(6)) * 256L;
        long _7_x = _6_x6 + Byte.toUnsignedLong((Byte)s.select(7));
        return _7_x;
    }

    public static BigInteger UINT16__LIMIT() {
        return Helpers.unsignedToBigInteger((short)BoundedInts_Compile.__default.UINT16__MAX()).add(BigInteger.ONE);
    }

    public static BigInteger UINT32__LIMIT() {
        return Helpers.unsignedToBigInteger((int)BoundedInts_Compile.__default.UINT32__MAX()).add(BigInteger.ONE);
    }

    public static BigInteger UINT64__LIMIT() {
        return Helpers.unsignedToBigInteger((long)BoundedInts_Compile.__default.UINT64__MAX()).add(BigInteger.ONE);
    }

    public static BigInteger INT32__MAX__LIMIT() {
        return BigInteger.valueOf(BoundedInts_Compile.__default.INT32__MAX());
    }

    public static BigInteger INT64__MAX__LIMIT() {
        return BigInteger.valueOf(BoundedInts_Compile.__default.INT64__MAX());
    }

    public static BigInteger UINT64__MAX__LIMIT() {
        return Helpers.unsignedToBigInteger((long)BoundedInts_Compile.__default.UINT64__MAX());
    }

    public String toString() {
        return "StandardLibrary.UInt._default";
    }
}

