/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.agent.tools;

import com.google.gson.reflect.TypeToken;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.agent.tools.utils.PPLExecuteHelper;
import org.opensearch.agent.tools.utils.ToolHelper;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.common.utils.ToolUtils;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.transport.client.Client;

@ToolAnnotation(value="DataDistributionTool")
public class DataDistributionTool
implements Tool {
    @Generated
    private static final Logger log = LogManager.getLogger(DataDistributionTool.class);
    public static final String TYPE = "DataDistributionTool";
    public static final String STRICT_FIELD = "strict";
    private static final String DEFAULT_DESCRIPTION = "This tool analyzes data distribution differences between time ranges or provides single dataset insights.";
    private static final String DEFAULT_TIME_FIELD = "@timestamp";
    private static final String PARAM_INDEX = "index";
    private static final String PARAM_TIME_FIELD = "timeField";
    private static final String PARAM_SELECTION_TIME_RANGE_START = "selectionTimeRangeStart";
    private static final String PARAM_SELECTION_TIME_RANGE_END = "selectionTimeRangeEnd";
    private static final String PARAM_BASELINE_TIME_RANGE_START = "baselineTimeRangeStart";
    private static final String PARAM_BASELINE_TIME_RANGE_END = "baselineTimeRangeEnd";
    private static final String PARAM_SIZE = "size";
    private static final String PARAM_QUERY_TYPE = "queryType";
    private static final String PARAM_FILTER = "filter";
    private static final String PARAM_DSL = "dsl";
    private static final String QUERY_TYPE_PPL = "ppl";
    private static final String QUERY_TYPE_DSL = "dsl";
    private static final String DEFAULT_SIZE = "1000";
    private static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final Set<String> USEFUL_FIELD_TYPES = Set.of("keyword", "boolean", "text", "byte", "short", "integer", "long", "float", "double", "half_float", "scaled_float");
    private static final Set<String> NUMBER_FIELD_TYPES = Set.of("byte", "short", "integer", "long", "float", "double", "half_float", "scaled_float");
    private static final int DEFAULT_COMPARISON_RESULT_LIMIT = 10;
    private static final int DEFAULT_SINGLE_ANALYSIS_RESULT_LIMIT = 30;
    private static final int MIN_CARDINALITY_DIVISOR = 4;
    private static final int MIN_CARDINALITY_BASE = 5;
    private static final int ID_FIELD_MAX_CARDINALITY = 30;
    private static final int DATA_FIELD_MAX_CARDINALITY = 10;
    private static final int DATA_FIELD_CARDINALITY_DIVISOR = 2;
    private static final int NUMERIC_GROUPING_THRESHOLD = 10;
    private static final double PERCENTAGE_MULTIPLIER = 100.0;
    private static final int TOP_CHANGES_LIMIT = 10;
    private static final int MAX_SIZE_LIMIT = 10000;
    public static final String DEFAULT_INPUT_SCHEMA = "{\n    \"type\": \"object\",\n    \"properties\": {\n        \"index\": {\n            \"type\": \"string\",\n            \"description\": \"Target OpenSearch index name\"\n        },\n        \"timeField\": {\n            \"type\": \"string\",\n            \"description\": \"Date/time field for filtering\"\n        },\n        \"selectionTimeRangeStart\": {\n            \"type\": \"string\",\n            \"description\": \"Start time for analysis period\"\n        },\n        \"selectionTimeRangeEnd\": {\n            \"type\": \"string\",\n            \"description\": \"End time for analysis period\"\n        },\n        \"baselineTimeRangeStart\": {\n            \"type\": \"string\",\n            \"description\": \"Start time for baseline period (optional)\"\n        },\n        \"baselineTimeRangeEnd\": {\n            \"type\": \"string\",\n            \"description\": \"End time for baseline period (optional)\"\n        },\n        \"size\": {\n            \"type\": \"integer\",\n            \"description\": \"Maximum number of documents to analyze (default: 1000)\"\n        },\n        \"queryType\": {\n            \"type\": \"string\",\n            \"description\": \"Query type: 'ppl' or 'dsl' (default: 'dsl')\"\n        },\n        \"filter\": {\n            \"type\": \"array\",\n            \"items\": {\n                \"type\": \"string\"\n            },\n            \"description\": \"Additional DSL query conditions for filtering (optional)\"\n        },\n        \"dsl\": {\n            \"type\": \"string\",\n            \"description\": \"Complete raw DSL query as JSON string (optional)\"\n        },\n        \"ppl\": {\n            \"type\": \"string\",\n            \"description\": \"Complete PPL statement without time information (optional)\"\n        }\n    },\n    \"required\": [\"index\", \"selectionTimeRangeStart\", \"selectionTimeRangeEnd\"],\n    \"additionalProperties\": false\n}\n";
    public static final Map<String, Object> DEFAULT_ATTRIBUTES = Map.of("input_schema", "{\n    \"type\": \"object\",\n    \"properties\": {\n        \"index\": {\n            \"type\": \"string\",\n            \"description\": \"Target OpenSearch index name\"\n        },\n        \"timeField\": {\n            \"type\": \"string\",\n            \"description\": \"Date/time field for filtering\"\n        },\n        \"selectionTimeRangeStart\": {\n            \"type\": \"string\",\n            \"description\": \"Start time for analysis period\"\n        },\n        \"selectionTimeRangeEnd\": {\n            \"type\": \"string\",\n            \"description\": \"End time for analysis period\"\n        },\n        \"baselineTimeRangeStart\": {\n            \"type\": \"string\",\n            \"description\": \"Start time for baseline period (optional)\"\n        },\n        \"baselineTimeRangeEnd\": {\n            \"type\": \"string\",\n            \"description\": \"End time for baseline period (optional)\"\n        },\n        \"size\": {\n            \"type\": \"integer\",\n            \"description\": \"Maximum number of documents to analyze (default: 1000)\"\n        },\n        \"queryType\": {\n            \"type\": \"string\",\n            \"description\": \"Query type: 'ppl' or 'dsl' (default: 'dsl')\"\n        },\n        \"filter\": {\n            \"type\": \"array\",\n            \"items\": {\n                \"type\": \"string\"\n            },\n            \"description\": \"Additional DSL query conditions for filtering (optional)\"\n        },\n        \"dsl\": {\n            \"type\": \"string\",\n            \"description\": \"Complete raw DSL query as JSON string (optional)\"\n        },\n        \"ppl\": {\n            \"type\": \"string\",\n            \"description\": \"Complete PPL statement without time information (optional)\"\n        }\n    },\n    \"required\": [\"index\", \"selectionTimeRangeStart\", \"selectionTimeRangeEnd\"],\n    \"additionalProperties\": false\n}\n", "strict", false);
    private String name = "DataDistributionTool";
    private String description = "This tool analyzes data distribution differences between time ranges or provides single dataset insights.";
    private String version;
    private Client client;

    public DataDistributionTool(Client client) {
        this.client = client;
    }

    public String getType() {
        return TYPE;
    }

    public Map<String, Object> getAttributes() {
        return DEFAULT_ATTRIBUTES;
    }

    public void setAttributes(Map<String, Object> map) {
    }

    public boolean validate(Map<String, String> map) {
        try {
            new AnalysisParameters(map).validate();
        }
        catch (Exception e) {
            log.error("Failed to validate the data distribution analysis parameter: {}", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public <T> void run(Map<String, String> originalParameters, ActionListener<T> listener) {
        try {
            Map parameters = ToolUtils.extractInputParameters(originalParameters, DEFAULT_ATTRIBUTES);
            log.debug("Starting data distribution analysis with parameters: {}", parameters.keySet());
            AnalysisParameters params = new AnalysisParameters(parameters);
            if (QUERY_TYPE_PPL.equals(params.queryType)) {
                this.executePPLAnalysis(params, listener);
            } else {
                this.executeDSLAnalysis(params, listener);
            }
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid parameters for DataDistributionTool: {}", (Object)e.getMessage());
            listener.onFailure((Exception)e);
        }
        catch (Exception e) {
            log.error("Unexpected error in DataDistributionTool", (Throwable)e);
            listener.onFailure(e);
        }
    }

    private <T> void executePPLAnalysis(AnalysisParameters params, ActionListener<T> listener) {
        if (params.hasBaselineTime()) {
            this.fetchPPLComparisonData(params, listener);
        } else {
            String pplQuery = this.buildPPLQuery(params.index, params.timeField, params.selectionTimeRangeStart, params.selectionTimeRangeEnd, params.size, params.ppl);
            Function<Map, List> pplResultParser = this::parsePPLResult;
            PPLExecuteHelper.executePPLAndParseResult(this.client, pplQuery, pplResultParser, ActionListener.wrap(data -> {
                try {
                    this.analyzeSingleDataset((List<Map<String, Object>>)data, params.index, (ActionListener<List<SummaryDataItem>>)ActionListener.wrap(result -> listener.onResponse((Object)StringUtils.gson.toJson(Map.of("singleAnalysis", result))), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private <T> void executeDSLAnalysis(AnalysisParameters params, ActionListener<T> listener) {
        if (params.hasBaselineTime()) {
            this.fetchComparisonData(params, listener);
        } else {
            this.getSingleDataDistribution(params, listener);
        }
    }

    private <T> void fetchComparisonData(AnalysisParameters params, ActionListener<T> listener) {
        this.fetchIndexData(params.selectionTimeRangeStart, params.selectionTimeRangeEnd, params, (ActionListener<List<Map<String, Object>>>)ActionListener.wrap(selectionData -> this.fetchIndexData(params.baselineTimeRangeStart, params.baselineTimeRangeEnd, params, (ActionListener<List<Map<String, Object>>>)ActionListener.wrap(baselineData -> {
            try {
                if (selectionData.isEmpty()) {
                    throw new IllegalStateException("No data found for selection time range");
                }
                if (baselineData.isEmpty()) {
                    throw new IllegalStateException("No data found for baseline time range");
                }
                this.getComparisonDataDistribution((List<Map<String, Object>>)selectionData, (List<Map<String, Object>>)baselineData, params.index, (ActionListener<List<SummaryDataItem>>)ActionListener.wrap(result -> listener.onResponse((Object)StringUtils.gson.toJson(Map.of("comparisonAnalysis", result))), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0)));
    }

    private <T> void getSingleDataDistribution(AnalysisParameters params, ActionListener<T> listener) {
        this.fetchIndexData(params.selectionTimeRangeStart, params.selectionTimeRangeEnd, params, (ActionListener<List<Map<String, Object>>>)ActionListener.wrap(data -> {
            try {
                if (data.isEmpty()) {
                    throw new IllegalStateException("No data found for selection time range");
                }
                this.analyzeSingleDataset((List<Map<String, Object>>)data, params.index, (ActionListener<List<SummaryDataItem>>)ActionListener.wrap(result -> listener.onResponse((Object)StringUtils.gson.toJson(Map.of("singleAnalysis", result))), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private String formatTimeString(String timeString) throws DateTimeParseException {
        log.debug("Attempting to parse time string: {}", (Object)timeString);
        try {
            if (timeString.endsWith("Z")) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss'Z'", Locale.ROOT);
                ZonedDateTime dateTime = ZonedDateTime.parse(timeString, formatter.withZone(ZoneOffset.UTC));
                return dateTime.format(DateTimeFormatter.ISO_INSTANT);
            }
        }
        catch (DateTimeParseException e) {
            log.debug("Failed to parse as UTC time: {}", (Object)e.getMessage());
        }
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DATE_FORMAT_PATTERN, Locale.ROOT);
            LocalDateTime localDateTime = LocalDateTime.parse(timeString, formatter);
            ZonedDateTime zonedDateTime = localDateTime.atOffset(ZoneOffset.UTC).toZonedDateTime();
            return zonedDateTime.format(DateTimeFormatter.ISO_INSTANT);
        }
        catch (DateTimeParseException e) {
            log.debug("Failed to parse as local time: {}", (Object)e.getMessage());
            try {
                ZonedDateTime dateTime = ZonedDateTime.parse(timeString);
                return dateTime.format(DateTimeFormatter.ISO_INSTANT);
            }
            catch (DateTimeParseException e2) {
                log.debug("Failed to parse as ISO format: {}", (Object)e2.getMessage());
                throw new DateTimeParseException("Unable to parse time string: " + timeString, timeString, 0);
            }
        }
    }

    private void fetchIndexData(String startTime, String endTime, AnalysisParameters params, ActionListener<List<Map<String, Object>>> listener) {
        try {
            BoolQueryBuilder query;
            String formattedStartTime = this.formatTimeString(startTime);
            String formattedEndTime = this.formatTimeString(endTime);
            if (!Strings.isEmpty((CharSequence)params.dsl)) {
                try {
                    Map dslMap = (Map)StringUtils.gson.fromJson(params.dsl, new TypeToken<Map<String, Object>>(this){}.getType());
                    query = QueryBuilders.boolQuery();
                    if (dslMap.containsKey("query")) {
                        Map queryMap = (Map)dslMap.get("query");
                        log.debug("Processing DSL query with wrapper: {}", (Object)queryMap);
                        this.buildQueryFromMap(queryMap, query);
                        query.filter((QueryBuilder)new RangeQueryBuilder(params.timeField).gte((Object)formattedStartTime).lte((Object)formattedEndTime));
                    } else {
                        log.debug("Processing DSL query without wrapper: {}", (Object)dslMap);
                        this.buildQueryFromMap(dslMap, query);
                        query.filter((QueryBuilder)new RangeQueryBuilder(params.timeField).gte((Object)formattedStartTime).lte((Object)formattedEndTime));
                    }
                    log.debug("Final DSL query: {}", (Object)query.toString());
                }
                catch (Exception e) {
                    log.warn("Failed to parse raw DSL query: {}, falling back to time range only", (Object)params.dsl, (Object)e);
                    query = QueryBuilders.boolQuery().filter((QueryBuilder)new RangeQueryBuilder(params.timeField).gte((Object)formattedStartTime).lte((Object)formattedEndTime));
                }
            } else {
                query = QueryBuilders.boolQuery().filter((QueryBuilder)new RangeQueryBuilder(params.timeField).gte((Object)formattedStartTime).lte((Object)formattedEndTime));
                if (!params.filter.isEmpty()) {
                    for (String filterStr : params.filter) {
                        try {
                            Map filterMap = (Map)StringUtils.gson.fromJson(filterStr, new TypeToken<Map<String, Object>>(this){}.getType());
                            BoolQueryBuilder filterQuery = QueryBuilders.boolQuery();
                            this.buildQueryFromMap(filterMap, filterQuery);
                            query.must((QueryBuilder)filterQuery);
                        }
                        catch (Exception e) {
                            log.warn("Failed to parse filter parameter: {}", (Object)filterStr, (Object)e);
                        }
                    }
                }
            }
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query((QueryBuilder)query).size(params.size);
            SearchRequest request = new SearchRequest(new String[]{params.index}).source(sourceBuilder);
            this.client.search(request, ActionListener.wrap(response -> {
                List data = Arrays.stream(response.getHits().getHits()).map(SearchHit::getSourceAsMap).collect(Collectors.toList());
                listener.onResponse(data);
            }, arg_0 -> listener.onFailure(arg_0)));
        }
        catch (Exception e) {
            log.error("Failed to format time strings: {}", (Object)e.getMessage());
            listener.onFailure((Exception)new IllegalArgumentException("Invalid time format: " + e.getMessage(), e));
        }
    }

    private <T> void fetchPPLComparisonData(AnalysisParameters params, ActionListener<T> listener) {
        String selectionQuery = this.buildPPLQuery(params.index, params.timeField, params.selectionTimeRangeStart, params.selectionTimeRangeEnd, params.size, params.ppl);
        String baselineQuery = this.buildPPLQuery(params.index, params.timeField, params.baselineTimeRangeStart, params.baselineTimeRangeEnd, params.size, params.ppl);
        Function<Map, List> pplResultParser = this::parsePPLResult;
        PPLExecuteHelper.executePPLAndParseResult(this.client, selectionQuery, pplResultParser, ActionListener.wrap(selectionData -> PPLExecuteHelper.executePPLAndParseResult(this.client, baselineQuery, pplResultParser, ActionListener.wrap(baselineData -> {
            try {
                if (selectionData.isEmpty()) {
                    throw new IllegalStateException("No data found for selection time range");
                }
                if (baselineData.isEmpty()) {
                    throw new IllegalStateException("No data found for baseline time range");
                }
                this.getComparisonDataDistribution((List<Map<String, Object>>)selectionData, (List<Map<String, Object>>)baselineData, params.index, (ActionListener<List<SummaryDataItem>>)ActionListener.wrap(result -> listener.onResponse((Object)StringUtils.gson.toJson(Map.of("comparisonAnalysis", result))), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0)));
    }

    private String formatTimeForPPL(String timeString) {
        try {
            ZonedDateTime dateTime = ZonedDateTime.parse(timeString);
            return dateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS", Locale.ROOT));
        }
        catch (DateTimeParseException e) {
            try {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DATE_FORMAT_PATTERN, Locale.ROOT);
                LocalDateTime localDateTime = LocalDateTime.parse(timeString, formatter);
                return localDateTime.format(formatter);
            }
            catch (DateTimeParseException e2) {
                return timeString;
            }
        }
    }

    private String getPPLQueryWithTimeRange(String query, String startTime, String endTime, String timeField) {
        if (Strings.isEmpty((CharSequence)query)) {
            throw new IllegalArgumentException("PPL query cannot be empty");
        }
        if (Strings.isEmpty((CharSequence)timeField)) {
            return query;
        }
        String formattedStartTime = this.formatTimeForPPL(startTime);
        String formattedEndTime = this.formatTimeForPPL(endTime);
        String timePredicate = String.format(Locale.ROOT, "`%s` >= '%s' AND `%s` <= '%s'", timeField, formattedStartTime, timeField, formattedEndTime);
        String[] commands = query.split("\\|");
        ArrayList<Object> commandList = new ArrayList<Object>();
        commandList.add(commands[0].trim());
        commandList.add("WHERE " + timePredicate);
        for (int i = 1; i < commands.length; ++i) {
            String cmd = commands[i].trim();
            if (cmd.isEmpty()) continue;
            commandList.add(cmd);
        }
        return String.join((CharSequence)" | ", commandList);
    }

    private String buildPPLQuery(String index, String timeField, String startTime, String endTime, int size, String customPpl) {
        String baseQuery = !Strings.isEmpty((CharSequence)customPpl) ? this.getPPLQueryWithTimeRange(customPpl, startTime, endTime, timeField) : this.getPPLQueryWithTimeRange(String.format(Locale.ROOT, "source=%s", index), startTime, endTime, timeField);
        return baseQuery + String.format(Locale.ROOT, " | head %d", size);
    }

    private void getComparisonDataDistribution(List<Map<String, Object>> selectionData, List<Map<String, Object>> baselineData, String index, ActionListener<List<SummaryDataItem>> listener) {
        this.getFieldTypes(index, (ActionListener<Map<String, String>>)ActionListener.wrap(fieldTypes -> {
            try {
                List<String> usefulFields = this.getUsefulFields(selectionData, (Map<String, String>)fieldTypes);
                Set<String> numberFields = this.getNumberFields((Map<String, String>)fieldTypes);
                ArrayList<FieldAnalysis> analyses = new ArrayList<FieldAnalysis>();
                for (String field : usefulFields) {
                    Map<String, Double> selectionDist = this.calculateFieldDistribution(selectionData, field);
                    Map<String, Double> baselineDist = this.calculateFieldDistribution(baselineData, field);
                    if (numberFields.contains(field)) {
                        GroupedDistributions grouped = this.groupNumericKeys(selectionDist, baselineDist);
                        selectionDist = grouped.groupedSelectionDist();
                        baselineDist = grouped.groupedBaselineDist();
                    }
                    double divergence = this.calculateMaxDifference(selectionDist, baselineDist);
                    analyses.add(new FieldAnalysis(field, divergence, selectionDist, baselineDist));
                }
                analyses.sort(Comparator.comparingDouble(a -> a.divergence).reversed());
                listener.onResponse(this.formatComparisonSummary(analyses, 10));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void analyzeSingleDataset(List<Map<String, Object>> data, String index, ActionListener<List<SummaryDataItem>> listener) {
        this.getFieldTypes(index, (ActionListener<Map<String, String>>)ActionListener.wrap(fieldTypes -> {
            try {
                List<String> usefulFields = this.getUsefulFields(data, (Map<String, String>)fieldTypes);
                Set<String> numberFields = this.getNumberFields((Map<String, String>)fieldTypes);
                ArrayList<FieldAnalysis> analyses = new ArrayList<FieldAnalysis>();
                for (String field : usefulFields) {
                    Map<String, Double> selectionDist = this.calculateFieldDistribution(data, field);
                    HashMap<String, Double> baselineDist = new HashMap<String, Double>();
                    if (numberFields.contains(field)) {
                        GroupedDistributions grouped = this.groupNumericKeys(selectionDist, baselineDist);
                        selectionDist = grouped.groupedSelectionDist();
                    }
                    double divergence = this.calculateMaxDifference(selectionDist, baselineDist);
                    analyses.add(new FieldAnalysis(field, divergence, selectionDist, baselineDist));
                }
                analyses.sort(Comparator.comparingDouble(a -> a.divergence).reversed());
                listener.onResponse(this.formatComparisonSummary(analyses, 30));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void getFieldTypes(String index, ActionListener<Map<String, String>> listener) {
        try {
            GetMappingsRequest getMappingsRequest = (GetMappingsRequest)new GetMappingsRequest().indices(new String[]{index});
            this.client.admin().indices().getMappings(getMappingsRequest, ActionListener.wrap(response -> {
                try {
                    Map mappings = response.getMappings();
                    if (mappings.isEmpty()) {
                        listener.onResponse(Map.of());
                        return;
                    }
                    MappingMetadata mappingMetadata = (MappingMetadata)mappings.values().iterator().next();
                    Map mappingSource = (Map)mappingMetadata.getSourceAsMap().get("properties");
                    if (mappingSource == null) {
                        listener.onResponse(Map.of());
                        return;
                    }
                    HashMap<String, String> fieldsToType = new HashMap<String, String>();
                    ToolHelper.extractFieldNamesTypes(mappingSource, fieldsToType, "", true);
                    listener.onResponse(fieldsToType);
                }
                catch (Exception e) {
                    log.error("Failed to process field types for index: {}", (Object)index, (Object)e);
                    listener.onResponse(Map.of());
                }
            }, e -> {
                log.error("Failed to get field types for index: {}", (Object)index, e);
                listener.onResponse(Map.of());
            }));
        }
        catch (Exception e2) {
            log.error("Failed to create getMappings request for index: {}", (Object)index, (Object)e2);
            listener.onResponse(Map.of());
        }
    }

    private List<String> getUsefulFields(List<Map<String, Object>> data, Map<String, String> fieldTypes) {
        if (fieldTypes.isEmpty()) {
            log.warn("No field types available, using data-based field detection");
            return this.getFieldsFromData(data);
        }
        HashSet<String> keywordFields = new HashSet<String>();
        HashSet<String> numberFields = new HashSet<String>();
        for (Map.Entry<String, String> entry : fieldTypes.entrySet()) {
            String fieldType = entry.getValue();
            String fieldName = entry.getKey();
            if (USEFUL_FIELD_TYPES.contains(fieldType)) {
                keywordFields.add(fieldName);
            }
            if (!NUMBER_FIELD_TYPES.contains(fieldType)) continue;
            numberFields.add(fieldName);
        }
        Set<String> normalizedFields = keywordFields.stream().map(field -> field.endsWith(".keyword") ? field.replace(".keyword", "") : field).collect(Collectors.toSet());
        HashMap fieldValueSets = new HashMap();
        normalizedFields.forEach(field -> fieldValueSets.put(field, new HashSet()));
        int maxCardinality = Math.max(5, data.size() / 4);
        data.forEach(doc -> normalizedFields.forEach(field -> {
            Object value = this.getFlattenedValue((Map<String, Object>)doc, (String)field);
            if (value != null) {
                ((Set)fieldValueSets.get(field)).add(StringUtils.gson.toJson(value));
            }
        }));
        return normalizedFields.stream().filter(field -> {
            int cardinality = ((Set)fieldValueSets.get(field)).size();
            if (field.toLowerCase(Locale.ROOT).endsWith("id")) {
                return cardinality <= 30 && cardinality > 0;
            }
            if (numberFields.contains(field)) {
                return true;
            }
            return cardinality <= maxCardinality && cardinality > 0;
        }).collect(Collectors.toList());
    }

    private Object getFlattenedValue(Map<String, Object> doc, String field) {
        String[] parts = field.split("\\.");
        Object current = doc;
        for (String part : parts) {
            if (!(current instanceof Map)) {
                if (current instanceof List) {
                    return StringUtils.gson.toJson(current);
                }
                return null;
            }
            current = current.get(part);
        }
        return current;
    }

    private Map<String, Double> calculateFieldDistribution(List<Map<String, Object>> data, String field) {
        if (data == null || data.isEmpty()) {
            return new HashMap<String, Double>();
        }
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (Map<String, Object> doc : data) {
            Object value = this.getFlattenedValue(doc, field);
            if (value == null) continue;
            String strValue = String.valueOf(value);
            counts.merge(strValue, 1, Integer::sum);
        }
        return counts.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (double)((Integer)entry.getValue()).intValue() / (double)data.size()));
    }

    private double calculateMaxDifference(Map<String, Double> selectionDist, Map<String, Double> baselineDist) {
        HashSet<String> allKeys = new HashSet<String>(selectionDist.keySet());
        allKeys.addAll(baselineDist.keySet());
        if (allKeys.isEmpty()) {
            return Double.NEGATIVE_INFINITY;
        }
        return allKeys.stream().mapToDouble(key -> {
            double selectionVal = selectionDist.getOrDefault(key, 0.0);
            double baselineVal = baselineDist.getOrDefault(key, 0.0);
            return Math.abs(selectionVal - baselineVal);
        }).max().orElse(Double.NEGATIVE_INFINITY);
    }

    private List<String> getFieldsFromData(List<Map<String, Object>> data) {
        if (data.isEmpty()) {
            return List.of();
        }
        HashSet<String> allFields = new HashSet<String>();
        for (Map<String, Object> doc : data) {
            allFields.addAll(doc.keySet());
        }
        return allFields.stream().filter(field -> !field.equals(DEFAULT_TIME_FIELD) && !field.equals("_id") && !field.equals("_index")).filter(field -> {
            HashSet<String> values = new HashSet<String>();
            for (Map doc : data) {
                Object value = doc.get(field);
                if (value == null) continue;
                values.add(String.valueOf(value));
            }
            int cardinality = values.size();
            return cardinality > 0 && cardinality <= Math.max(10, data.size() / 2);
        }).collect(Collectors.toList());
    }

    private Set<String> getNumberFields(Map<String, String> fieldTypes) {
        return fieldTypes.entrySet().stream().filter(entry -> NUMBER_FIELD_TYPES.contains(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private GroupedDistributions groupNumericKeys(Map<String, Double> selectionDist, Map<String, Double> baselineDist) {
        HashSet<String> allKeys = new HashSet<String>(selectionDist.keySet());
        allKeys.addAll(baselineDist.keySet());
        if (allKeys.size() <= 10 || allKeys.stream().anyMatch(key -> !NumberUtils.isCreatable((String)key))) {
            return new GroupedDistributions(selectionDist, baselineDist);
        }
        List<Double> numericKeys = allKeys.stream().map(Double::parseDouble).sorted().collect(Collectors.toList());
        Function<Double, String> getGroupLabel = DataDistributionTool.getDoubleStringFunction(numericKeys);
        Map<String, Double> groupedSelectionDist = numericKeys.stream().collect(Collectors.groupingBy(getGroupLabel, Collectors.summingDouble(numKey -> selectionDist.getOrDefault(String.valueOf(numKey), 0.0))));
        Map<String, Double> groupedBaselineDist = numericKeys.stream().collect(Collectors.groupingBy(getGroupLabel, Collectors.summingDouble(numKey -> baselineDist.getOrDefault(String.valueOf(numKey), 0.0))));
        HashSet<String> allGroups = new HashSet<String>();
        allGroups.addAll(groupedSelectionDist.keySet());
        allGroups.addAll(groupedBaselineDist.keySet());
        allGroups.forEach(group -> {
            groupedSelectionDist.putIfAbsent((String)group, 0.0);
            groupedBaselineDist.putIfAbsent((String)group, 0.0);
        });
        return new GroupedDistributions(groupedSelectionDist, groupedBaselineDist);
    }

    private static Function<Double, String> getDoubleStringFunction(List<Double> numericKeys) {
        double min = numericKeys.get(0);
        double max = numericKeys.get(numericKeys.size() - 1);
        double range = max - min;
        int numGroups = 5;
        double groupSize = range / (double)numGroups;
        Function<Double, String> getGroupLabel = numKey -> {
            int groupIndex = numKey == max ? numGroups - 1 : (int)((numKey - min) / groupSize);
            double lowerBound = min + (double)groupIndex * groupSize;
            double upperBound = groupIndex == numGroups - 1 ? max : min + (double)(groupIndex + 1) * groupSize;
            return String.format(Locale.ROOT, "%.1f-%.1f", lowerBound, upperBound);
        };
        return getGroupLabel;
    }

    private List<SummaryDataItem> formatComparisonSummary(List<FieldAnalysis> differences, int maxResults) {
        return differences.stream().filter(diff -> diff.divergence > 0.0).limit(maxResults).map(diff -> {
            HashSet<String> allKeys = new HashSet<String>(diff.selectionDist.keySet());
            allKeys.addAll(diff.baselineDist.keySet());
            boolean hasBaseline = !diff.baselineDist.isEmpty();
            List changes = allKeys.stream().map(value -> {
                double selectionPercentage = (double)Math.round(diff.selectionDist.getOrDefault(value, 0.0) * 100.0) / 100.0;
                Double baselinePercentage = hasBaseline ? Double.valueOf((double)Math.round(diff.baselineDist.getOrDefault(value, 0.0) * 100.0) / 100.0) : null;
                return new ChangeItem((String)value, selectionPercentage, baselinePercentage);
            }).collect(Collectors.toList());
            List<ChangeItem> topChanges = changes.stream().sorted((a, b) -> hasBaseline ? Double.compare(Math.max(b.baselinePercentage != null ? b.baselinePercentage : 0.0, b.selectionPercentage), Math.max(a.baselinePercentage != null ? a.baselinePercentage : 0.0, a.selectionPercentage)) : Double.compare(b.selectionPercentage, a.selectionPercentage)).limit(10L).collect(Collectors.toList());
            return new SummaryDataItem(diff.field, diff.divergence, topChanges);
        }).collect(Collectors.toList());
    }

    private void buildQueryFromMap(Map<String, Object> filterMap, BoolQueryBuilder queryBuilder) {
        log.debug("Building query from map: {}", filterMap);
        block30: for (Map.Entry<String, Object> entry : filterMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            log.debug("Processing query key: {}, value: {}", (Object)key, value);
            switch (key) {
                case "match_all": {
                    log.debug("Adding match_all query");
                    queryBuilder.must((QueryBuilder)QueryBuilders.matchAllQuery());
                    break;
                }
                case "match_none": {
                    log.debug("Adding match_none query");
                    queryBuilder.mustNot((QueryBuilder)QueryBuilders.matchAllQuery());
                    break;
                }
                case "bool": {
                    if (!(value instanceof Map)) continue block30;
                    log.debug("Processing bool query: {}", value);
                    this.processBoolQuery((Map)value, queryBuilder);
                    break;
                }
                case "term": {
                    if (!(value instanceof Map)) continue block30;
                    Map valueMap = (Map)value;
                    log.debug("Adding term query: {}", (Object)valueMap);
                    for (Map.Entry termEntry : valueMap.entrySet()) {
                        log.debug("Term query - field: {}, value: {}", termEntry.getKey(), termEntry.getValue());
                        queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)((String)termEntry.getKey()), termEntry.getValue()));
                    }
                    continue block30;
                }
                case "wildcard": {
                    if (!(value instanceof Map)) continue block30;
                    Map valueMap = (Map)value;
                    log.debug("Adding wildcard query: {}", (Object)valueMap);
                    for (Map.Entry wildcardEntry : valueMap.entrySet()) {
                        log.debug("Wildcard query - field: {}, pattern: {}", wildcardEntry.getKey(), wildcardEntry.getValue());
                        queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)((String)wildcardEntry.getKey()), (String)wildcardEntry.getValue().toString()));
                    }
                    continue block30;
                }
                case "range": {
                    if (!(value instanceof Map)) continue block30;
                    Map valueMap = (Map)value;
                    for (Map.Entry rangeEntry : valueMap.entrySet()) {
                        String field = (String)rangeEntry.getKey();
                        Object rangeValue = rangeEntry.getValue();
                        if (!(rangeValue instanceof Map)) continue;
                        this.processRangeQuery(field, rangeValue, queryBuilder);
                    }
                    continue block30;
                }
                case "match": {
                    if (!(value instanceof Map)) continue block30;
                    Map valueMap = (Map)value;
                    for (Map.Entry matchEntry : valueMap.entrySet()) {
                        queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)((String)matchEntry.getKey()), matchEntry.getValue()));
                    }
                    continue block30;
                }
                case "match_phrase": {
                    if (!(value instanceof Map)) continue block30;
                    Map valueMap = (Map)value;
                    for (Map.Entry matchPhraseEntry : valueMap.entrySet()) {
                        queryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)((String)matchPhraseEntry.getKey()), matchPhraseEntry.getValue()));
                    }
                    continue block30;
                }
                case "prefix": {
                    if (!(value instanceof Map)) continue block30;
                    Map valueMap = (Map)value;
                    for (Map.Entry prefixEntry : valueMap.entrySet()) {
                        queryBuilder.must((QueryBuilder)QueryBuilders.prefixQuery((String)((String)prefixEntry.getKey()), (String)prefixEntry.getValue().toString()));
                    }
                    continue block30;
                }
                case "exists": {
                    Object fieldValue;
                    Map valueMap;
                    if (!(value instanceof Map) || (fieldValue = (valueMap = (Map)value).get("field")) == null) continue block30;
                    queryBuilder.must((QueryBuilder)QueryBuilders.existsQuery((String)fieldValue.toString()));
                    break;
                }
                case "regexp": {
                    if (!(value instanceof Map)) continue block30;
                    Map valueMap = (Map)value;
                    Object fieldValue = valueMap.entrySet().iterator();
                    while (fieldValue.hasNext()) {
                        Map.Entry regexpEntry = (Map.Entry)fieldValue.next();
                        queryBuilder.must((QueryBuilder)QueryBuilders.regexpQuery((String)((String)regexpEntry.getKey()), (String)regexpEntry.getValue().toString()));
                    }
                    continue block30;
                }
                case "terms": {
                    if (!(value instanceof Map)) continue block30;
                    Map valueMap = (Map)value;
                    Object fieldValue = valueMap.entrySet().iterator();
                    while (fieldValue.hasNext()) {
                        Map.Entry termsEntry = (Map.Entry)fieldValue.next();
                        if (!(termsEntry.getValue() instanceof List)) continue;
                        queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)((String)termsEntry.getKey()), (Collection)((List)termsEntry.getValue())));
                    }
                    continue block30;
                }
                case "multi_match": {
                    if (!(value instanceof Map)) continue block30;
                    Map valueMap = (Map)value;
                    Object queryValue = valueMap.get("query");
                    Object fieldsValue = valueMap.get("fields");
                    if (queryValue == null || !(fieldsValue instanceof List)) continue block30;
                    List fields = (List)fieldsValue;
                    queryBuilder.must((QueryBuilder)QueryBuilders.multiMatchQuery(queryValue, (String[])fields.toArray(new String[0])));
                    break;
                }
                default: {
                    Map valueMap;
                    if (value instanceof Map) {
                        valueMap = (Map)value;
                        this.processNestedQuery(key, valueMap, queryBuilder);
                        break;
                    }
                    queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)value));
                }
            }
        }
    }

    private void processBoolQuery(Map<String, Object> boolMap, BoolQueryBuilder queryBuilder) {
        for (Map.Entry<String, Object> boolEntry : boolMap.entrySet()) {
            String boolType = boolEntry.getKey();
            Object boolValue = boolEntry.getValue();
            if (!(boolValue instanceof List)) continue;
            List clauses = (List)boolValue;
            block13: for (Map clause : clauses) {
                BoolQueryBuilder subQuery = QueryBuilders.boolQuery();
                this.buildQueryFromMap(clause, subQuery);
                switch (boolType) {
                    case "must": {
                        queryBuilder.must((QueryBuilder)subQuery);
                        continue block13;
                    }
                    case "should": {
                        queryBuilder.should((QueryBuilder)subQuery);
                        continue block13;
                    }
                    case "must_not": {
                        queryBuilder.mustNot((QueryBuilder)subQuery);
                        continue block13;
                    }
                    case "filter": {
                        queryBuilder.filter((QueryBuilder)subQuery);
                        continue block13;
                    }
                }
                log.warn("Unsupported bool query type: {}", (Object)boolType);
            }
        }
    }

    private void processNestedQuery(String field, Map<String, Object> nestedMap, BoolQueryBuilder queryBuilder) {
        block20: for (Map.Entry<String, Object> nestedEntry : nestedMap.entrySet()) {
            String operator = nestedEntry.getKey();
            Object operatorValue = nestedEntry.getValue();
            switch (operator) {
                case "term": {
                    queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)field, (Object)operatorValue));
                    continue block20;
                }
                case "range": {
                    this.processRangeQuery(field, operatorValue, queryBuilder);
                    continue block20;
                }
                case "match": {
                    queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)field, (Object)operatorValue));
                    continue block20;
                }
                case "match_phrase": {
                    queryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)field, (Object)operatorValue));
                    continue block20;
                }
                case "prefix": {
                    queryBuilder.must((QueryBuilder)QueryBuilders.prefixQuery((String)field, (String)operatorValue.toString()));
                    continue block20;
                }
                case "wildcard": {
                    this.processWildcardQuery(field, operatorValue, queryBuilder);
                    continue block20;
                }
                case "exists": {
                    queryBuilder.must((QueryBuilder)QueryBuilders.existsQuery((String)field));
                    continue block20;
                }
                case "regexp": {
                    this.processRegexpQuery(field, operatorValue, queryBuilder);
                    continue block20;
                }
            }
            if (operatorValue instanceof Map) {
                Map valueMap = (Map)operatorValue;
                BoolQueryBuilder nestedQuery = QueryBuilders.boolQuery();
                this.buildQueryFromMap(Map.of(operator, valueMap), nestedQuery);
                queryBuilder.must((QueryBuilder)nestedQuery);
                continue;
            }
            log.warn("Unsupported query operator: {}", (Object)operator);
        }
    }

    private void processRangeQuery(String field, Object operatorValue, BoolQueryBuilder queryBuilder) {
        if (!(operatorValue instanceof Map)) {
            return;
        }
        Map rangeMap = (Map)operatorValue;
        RangeQueryBuilder rangeQuery = QueryBuilders.rangeQuery((String)field);
        rangeMap.forEach((rangeOp, rangeVal) -> {
            switch (rangeOp) {
                case "gte": {
                    rangeQuery.gte(rangeVal);
                    break;
                }
                case "lte": {
                    rangeQuery.lte(rangeVal);
                    break;
                }
                case "gt": {
                    rangeQuery.gt(rangeVal);
                    break;
                }
                case "lt": {
                    rangeQuery.lt(rangeVal);
                }
            }
        });
        queryBuilder.must((QueryBuilder)rangeQuery);
    }

    private void processWildcardQuery(String field, Object operatorValue, BoolQueryBuilder queryBuilder) {
        if (operatorValue instanceof Map) {
            Map wildcardMap = (Map)operatorValue;
            Object wildcardValue = wildcardMap.get("value");
            if (wildcardValue != null) {
                queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)field, (String)wildcardValue.toString()));
            }
        } else {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)field, (String)operatorValue.toString()));
        }
    }

    private void processRegexpQuery(String field, Object operatorValue, BoolQueryBuilder queryBuilder) {
        if (operatorValue instanceof Map) {
            Map regexpMap = (Map)operatorValue;
            Object regexpValue = regexpMap.get("value");
            if (regexpValue != null) {
                queryBuilder.must((QueryBuilder)QueryBuilders.regexpQuery((String)field, (String)regexpValue.toString()));
            }
        } else {
            queryBuilder.must((QueryBuilder)QueryBuilders.regexpQuery((String)field, (String)operatorValue.toString()));
        }
    }

    private List<Map<String, Object>> parsePPLResult(Map<String, Object> pplResult) {
        Object datarowsObj = pplResult.get("datarows");
        Object schemaObj = pplResult.get("schema");
        if (!(datarowsObj instanceof List) || !(schemaObj instanceof List)) {
            return List.of();
        }
        List dataRows = (List)datarowsObj;
        List schema = (List)schemaObj;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (List row : dataRows) {
            HashMap doc = new HashMap();
            for (int i = 0; i < Math.min(row.size(), schema.size()); ++i) {
                String columnName = (String)((Map)schema.get(i)).get("name");
                if (columnName == null) continue;
                doc.put(columnName, row.get(i));
            }
            result.add(doc);
        }
        return result;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setClient(Client client) {
        this.client = client;
    }

    @Generated
    public Client getClient() {
        return this.client;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    private static class AnalysisParameters {
        final String index;
        final String timeField;
        final String selectionTimeRangeStart;
        final String selectionTimeRangeEnd;
        final String baselineTimeRangeStart;
        final String baselineTimeRangeEnd;
        final int size;
        final String queryType;
        final List<String> filter;
        final String dsl;
        final String ppl;

        AnalysisParameters(Map<String, String> parameters) {
            this.index = parameters.getOrDefault(DataDistributionTool.PARAM_INDEX, "");
            this.timeField = parameters.getOrDefault(DataDistributionTool.PARAM_TIME_FIELD, DataDistributionTool.DEFAULT_TIME_FIELD);
            this.selectionTimeRangeStart = parameters.getOrDefault(DataDistributionTool.PARAM_SELECTION_TIME_RANGE_START, "");
            this.selectionTimeRangeEnd = parameters.getOrDefault(DataDistributionTool.PARAM_SELECTION_TIME_RANGE_END, "");
            this.baselineTimeRangeStart = parameters.getOrDefault(DataDistributionTool.PARAM_BASELINE_TIME_RANGE_START, "");
            this.baselineTimeRangeEnd = parameters.getOrDefault(DataDistributionTool.PARAM_BASELINE_TIME_RANGE_END, "");
            try {
                this.size = Integer.parseInt(parameters.getOrDefault(DataDistributionTool.PARAM_SIZE, DataDistributionTool.DEFAULT_SIZE));
                if (this.size > 10000) {
                    throw new IllegalArgumentException("Size parameter exceeds maximum limit of 10000, got: " + this.size);
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid 'size' parameter: must be a valid integer, got '" + parameters.get(DataDistributionTool.PARAM_SIZE) + "'");
            }
            this.queryType = parameters.getOrDefault(DataDistributionTool.PARAM_QUERY_TYPE, "dsl");
            String filterParam = parameters.getOrDefault(DataDistributionTool.PARAM_FILTER, "");
            if (Strings.isEmpty((CharSequence)filterParam)) {
                this.filter = List.of();
            } else {
                try {
                    this.filter = Arrays.asList((String[])StringUtils.gson.fromJson(filterParam, String[].class));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid 'filter' parameter: must be a valid JSON array of strings, got '" + filterParam + "'. Example: [\"{'term': {'status': 'error'}}\", \"{'range': {'level': {'gte': 3}}}\"]");
                }
            }
            this.dsl = parameters.getOrDefault("dsl", "");
            this.ppl = parameters.getOrDefault(DataDistributionTool.QUERY_TYPE_PPL, "");
        }

        void validate() {
            ArrayList<String> missingParams = new ArrayList<String>();
            if (Strings.isEmpty((CharSequence)this.index)) {
                missingParams.add(DataDistributionTool.PARAM_INDEX);
            }
            if (Strings.isEmpty((CharSequence)this.selectionTimeRangeStart)) {
                missingParams.add(DataDistributionTool.PARAM_SELECTION_TIME_RANGE_START);
            }
            if (Strings.isEmpty((CharSequence)this.selectionTimeRangeEnd)) {
                missingParams.add(DataDistributionTool.PARAM_SELECTION_TIME_RANGE_END);
            }
            if (Strings.isEmpty((CharSequence)this.timeField)) {
                missingParams.add(DataDistributionTool.PARAM_TIME_FIELD);
            }
            if (!missingParams.isEmpty()) {
                throw new IllegalArgumentException("Missing required parameters: " + String.join((CharSequence)", ", missingParams));
            }
        }

        boolean hasBaselineTime() {
            return !Strings.isEmpty((CharSequence)this.baselineTimeRangeStart) && !Strings.isEmpty((CharSequence)this.baselineTimeRangeEnd);
        }
    }

    private record GroupedDistributions(Map<String, Double> groupedSelectionDist, Map<String, Double> groupedBaselineDist) {
    }

    private record FieldAnalysis(String field, double divergence, Map<String, Double> selectionDist, Map<String, Double> baselineDist) {
    }

    private record SummaryDataItem(String field, double divergence, List<ChangeItem> topChanges) {
    }

    private record ChangeItem(String value, double selectionPercentage, Double baselinePercentage) {
    }

    public static class Factory
    implements Tool.Factory<DataDistributionTool> {
        private Client client;
        private static Factory INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<DataDistributionTool> clazz = DataDistributionTool.class;
            synchronized (DataDistributionTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init(Client client) {
            this.client = client;
        }

        public DataDistributionTool create(Map<String, Object> map) {
            return new DataDistributionTool(this.client);
        }

        public String getDefaultDescription() {
            return DataDistributionTool.DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return DataDistributionTool.TYPE;
        }

        public Map<String, Object> getDefaultAttributes() {
            return DEFAULT_ATTRIBUTES;
        }

        public String getDefaultVersion() {
            return null;
        }
    }
}

