/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.agent.tools.utils;

import com.google.common.collect.ImmutableMap;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.agent.tools.utils.ToolHelper;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.sql.plugin.transport.PPLQueryAction;
import org.opensearch.sql.plugin.transport.TransportPPLQueryRequest;
import org.opensearch.sql.plugin.transport.TransportPPLQueryResponse;
import org.opensearch.sql.ppl.domain.PPLQueryRequest;
import org.opensearch.transport.client.Client;

public class PPLExecuteHelper {
    @Generated
    private static final Logger log = LogManager.getLogger(PPLExecuteHelper.class);

    public static <T> void executePPLAndParseResult(Client client, String ppl, Function<Map<String, Object>, T> resultParser, ActionListener<T> listener) {
        try {
            JSONObject jsonContent = new JSONObject((Map)ImmutableMap.of((Object)"query", (Object)ppl));
            PPLQueryRequest pplQueryRequest = new PPLQueryRequest(ppl, jsonContent, null, "jdbc");
            TransportPPLQueryRequest transportPPLQueryRequest = new TransportPPLQueryRequest(pplQueryRequest);
            client.execute((ActionType)PPLQueryAction.INSTANCE, (ActionRequest)transportPPLQueryRequest, ToolHelper.getPPLTransportActionListener((ActionListener<TransportPPLQueryResponse>)ActionListener.wrap(transportPPLQueryResponse -> {
                String result = transportPPLQueryResponse.getResult();
                if (Strings.isEmpty((CharSequence)result)) {
                    listener.onFailure((Exception)new RuntimeException("Empty PPL response"));
                } else {
                    Map pplResult = (Map)StringUtils.gson.fromJson(result, new TypeToken<Map<String, Object>>(){}.getType());
                    if (pplResult.containsKey("error")) {
                        Map errorMap;
                        Object reason;
                        Object errorObj = pplResult.get("error");
                        String errorDetail = errorObj instanceof Map ? ((reason = (errorMap = (Map)errorObj).get("reason")) != null ? reason.toString() : errorMap.toString()) : (errorObj != null ? errorObj.toString() : "Unknown error");
                        throw new RuntimeException("PPL query error: " + errorDetail);
                    }
                    Object datarowsObj = pplResult.get("datarows");
                    if (!(datarowsObj instanceof List)) {
                        throw new IllegalStateException("Invalid PPL response format: missing or invalid datarows");
                    }
                    listener.onResponse(resultParser.apply(pplResult));
                }
            }, error -> {
                log.error("PPL execution failed: {}", (Object)error.getMessage());
                listener.onFailure((Exception)new RuntimeException("PPL execution failed: " + error.getMessage(), (Throwable)error));
            })));
        }
        catch (Exception e) {
            String errorMessage = String.format(Locale.ROOT, "Failed to execute PPL query: %s", e.getMessage());
            log.error(errorMessage, (Throwable)e);
            listener.onFailure((Exception)new RuntimeException(errorMessage, e));
        }
    }

    public static <T> Function<Map<String, Object>, T> dataRowsParser(Function<List<List<Object>>, T> rowParser) {
        return pplResult -> {
            Object datarowsObj = pplResult.get("datarows");
            List dataRows = (List)datarowsObj;
            if (dataRows.isEmpty()) {
                log.debug("PPL query returned no data rows for the specified criteria");
            }
            return rowParser.apply(dataRows);
        };
    }
}

