/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.client;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.ml.client.MachineLearningClient;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLConfig;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.MLTask;
import org.opensearch.ml.common.ToolMetadata;
import org.opensearch.ml.common.agent.MLAgent;
import org.opensearch.ml.common.input.Input;
import org.opensearch.ml.common.input.InputHelper;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.input.parameter.MLAlgoParams;
import org.opensearch.ml.common.output.MLOutput;
import org.opensearch.ml.common.transport.MLTaskResponse;
import org.opensearch.ml.common.transport.agent.MLAgentDeleteAction;
import org.opensearch.ml.common.transport.agent.MLAgentDeleteRequest;
import org.opensearch.ml.common.transport.agent.MLAgentGetAction;
import org.opensearch.ml.common.transport.agent.MLAgentGetRequest;
import org.opensearch.ml.common.transport.agent.MLAgentGetResponse;
import org.opensearch.ml.common.transport.agent.MLRegisterAgentAction;
import org.opensearch.ml.common.transport.agent.MLRegisterAgentRequest;
import org.opensearch.ml.common.transport.agent.MLRegisterAgentResponse;
import org.opensearch.ml.common.transport.config.MLConfigGetAction;
import org.opensearch.ml.common.transport.config.MLConfigGetRequest;
import org.opensearch.ml.common.transport.config.MLConfigGetResponse;
import org.opensearch.ml.common.transport.connector.MLConnectorDeleteAction;
import org.opensearch.ml.common.transport.connector.MLConnectorDeleteRequest;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorAction;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorInput;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorRequest;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorResponse;
import org.opensearch.ml.common.transport.deploy.MLDeployModelAction;
import org.opensearch.ml.common.transport.deploy.MLDeployModelRequest;
import org.opensearch.ml.common.transport.deploy.MLDeployModelResponse;
import org.opensearch.ml.common.transport.execute.MLExecuteTaskAction;
import org.opensearch.ml.common.transport.execute.MLExecuteTaskRequest;
import org.opensearch.ml.common.transport.execute.MLExecuteTaskResponse;
import org.opensearch.ml.common.transport.model.MLModelDeleteAction;
import org.opensearch.ml.common.transport.model.MLModelDeleteRequest;
import org.opensearch.ml.common.transport.model.MLModelGetAction;
import org.opensearch.ml.common.transport.model.MLModelGetRequest;
import org.opensearch.ml.common.transport.model.MLModelGetResponse;
import org.opensearch.ml.common.transport.model.MLModelSearchAction;
import org.opensearch.ml.common.transport.model_group.MLRegisterModelGroupAction;
import org.opensearch.ml.common.transport.model_group.MLRegisterModelGroupInput;
import org.opensearch.ml.common.transport.model_group.MLRegisterModelGroupRequest;
import org.opensearch.ml.common.transport.model_group.MLRegisterModelGroupResponse;
import org.opensearch.ml.common.transport.prediction.MLPredictionTaskAction;
import org.opensearch.ml.common.transport.prediction.MLPredictionTaskRequest;
import org.opensearch.ml.common.transport.register.MLRegisterModelAction;
import org.opensearch.ml.common.transport.register.MLRegisterModelInput;
import org.opensearch.ml.common.transport.register.MLRegisterModelRequest;
import org.opensearch.ml.common.transport.register.MLRegisterModelResponse;
import org.opensearch.ml.common.transport.task.MLTaskDeleteAction;
import org.opensearch.ml.common.transport.task.MLTaskDeleteRequest;
import org.opensearch.ml.common.transport.task.MLTaskGetAction;
import org.opensearch.ml.common.transport.task.MLTaskGetRequest;
import org.opensearch.ml.common.transport.task.MLTaskGetResponse;
import org.opensearch.ml.common.transport.task.MLTaskSearchAction;
import org.opensearch.ml.common.transport.tools.MLGetToolAction;
import org.opensearch.ml.common.transport.tools.MLListToolsAction;
import org.opensearch.ml.common.transport.tools.MLToolGetRequest;
import org.opensearch.ml.common.transport.tools.MLToolGetResponse;
import org.opensearch.ml.common.transport.tools.MLToolsListRequest;
import org.opensearch.ml.common.transport.tools.MLToolsListResponse;
import org.opensearch.ml.common.transport.training.MLTrainingTaskAction;
import org.opensearch.ml.common.transport.training.MLTrainingTaskRequest;
import org.opensearch.ml.common.transport.trainpredict.MLTrainAndPredictionTaskAction;
import org.opensearch.ml.common.transport.undeploy.MLUndeployModelsAction;
import org.opensearch.ml.common.transport.undeploy.MLUndeployModelsRequest;
import org.opensearch.ml.common.transport.undeploy.MLUndeployModelsResponse;
import org.opensearch.transport.client.Client;

public class MachineLearningNodeClient
implements MachineLearningClient {
    private final Client client;

    @Override
    public void predict(String modelId, String tenantId, MLInput mlInput, ActionListener<MLOutput> listener) {
        this.validateMLInput(mlInput, true);
        MLPredictionTaskRequest predictionRequest = MLPredictionTaskRequest.builder().mlInput(mlInput).modelId(modelId).dispatchTask(true).tenantId(tenantId).build();
        this.client.execute((ActionType)MLPredictionTaskAction.INSTANCE, (ActionRequest)predictionRequest, this.getMlPredictionTaskResponseActionListener(listener));
    }

    @Override
    public void trainAndPredict(MLInput mlInput, ActionListener<MLOutput> listener) {
        this.validateMLInput(mlInput, true);
        MLTrainingTaskRequest request = MLTrainingTaskRequest.builder().mlInput(mlInput).dispatchTask(true).build();
        this.client.execute((ActionType)MLTrainAndPredictionTaskAction.INSTANCE, (ActionRequest)request, this.getMlPredictionTaskResponseActionListener(listener));
    }

    @Override
    public void train(MLInput mlInput, boolean asyncTask, ActionListener<MLOutput> listener) {
        this.validateMLInput(mlInput, true);
        MLTrainingTaskRequest trainingTaskRequest = MLTrainingTaskRequest.builder().mlInput(mlInput).async(asyncTask).dispatchTask(true).build();
        this.client.execute((ActionType)MLTrainingTaskAction.INSTANCE, (ActionRequest)trainingTaskRequest, this.getMlPredictionTaskResponseActionListener(listener));
    }

    @Override
    public void run(MLInput mlInput, Map<String, Object> args, ActionListener<MLOutput> listener) {
        String action = InputHelper.getAction(args);
        if (action == null) {
            throw new IllegalArgumentException("The parameter action is required.");
        }
        FunctionName functionName = InputHelper.getFunctionName(args);
        MLAlgoParams mlAlgoParams = InputHelper.convertArgumentToMLParameter(args, functionName);
        mlInput.setAlgorithm(functionName);
        mlInput.setParameters(mlAlgoParams);
        switch (action) {
            case "train": {
                boolean asyncTask = args.containsKey("async") && (Boolean)args.get("async") != false;
                this.train(mlInput, asyncTask, listener);
                break;
            }
            case "predict": {
                String modelId = (String)args.get("modelid");
                if (modelId == null) {
                    throw new IllegalArgumentException("The model ID is required for prediction.");
                }
                this.predict(modelId, mlInput, listener);
                break;
            }
            case "trainandpredict": {
                this.trainAndPredict(mlInput, listener);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported action.");
            }
        }
    }

    @Override
    public void getModel(String modelId, String tenantId, ActionListener<MLModel> listener) {
        MLModelGetRequest mlModelGetRequest = MLModelGetRequest.builder().modelId(modelId).tenantId(tenantId).build();
        this.client.execute((ActionType)MLModelGetAction.INSTANCE, (ActionRequest)mlModelGetRequest, this.getMlGetModelResponseActionListener(listener));
    }

    private ActionListener<MLModelGetResponse> getMlGetModelResponseActionListener(ActionListener<MLModel> listener) {
        ActionListener internalListener = ActionListener.wrap(predictionResponse -> listener.onResponse((Object)predictionResponse.getMlModel()), arg_0 -> listener.onFailure(arg_0));
        return this.wrapActionListener(internalListener, MLModelGetResponse::fromActionResponse);
    }

    @Override
    public void deleteModel(String modelId, String tenantId, ActionListener<DeleteResponse> listener) {
        MLModelDeleteRequest mlModelDeleteRequest = MLModelDeleteRequest.builder().modelId(modelId).tenantId(tenantId).build();
        this.client.execute((ActionType)MLModelDeleteAction.INSTANCE, (ActionRequest)mlModelDeleteRequest, ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void searchModel(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        this.client.execute((ActionType)MLModelSearchAction.INSTANCE, (ActionRequest)searchRequest, ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void registerModelGroup(MLRegisterModelGroupInput mlRegisterModelGroupInput, ActionListener<MLRegisterModelGroupResponse> listener) {
        MLRegisterModelGroupRequest mlRegisterModelGroupRequest = new MLRegisterModelGroupRequest(mlRegisterModelGroupInput);
        this.client.execute((ActionType)MLRegisterModelGroupAction.INSTANCE, (ActionRequest)mlRegisterModelGroupRequest, this.getMlRegisterModelGroupResponseActionListener(listener));
    }

    @Override
    public void execute(FunctionName name, Input input, ActionListener<MLExecuteTaskResponse> listener) {
        MLExecuteTaskRequest mlExecuteTaskRequest = new MLExecuteTaskRequest(name, input);
        this.client.execute((ActionType)MLExecuteTaskAction.INSTANCE, (ActionRequest)mlExecuteTaskRequest, this.getMLExecuteResponseActionListener(listener));
    }

    @Override
    public void getTask(String taskId, ActionListener<MLTask> listener) {
        MLTaskGetRequest mlTaskGetRequest = MLTaskGetRequest.builder().taskId(taskId).build();
        this.client.execute((ActionType)MLTaskGetAction.INSTANCE, (ActionRequest)mlTaskGetRequest, this.getMLTaskResponseActionListener(listener));
    }

    @Override
    public void getTask(String taskId, String tenantId, ActionListener<MLTask> listener) {
        MLTaskGetRequest mlTaskGetRequest = MLTaskGetRequest.builder().taskId(taskId).tenantId(tenantId).build();
        this.client.execute((ActionType)MLTaskGetAction.INSTANCE, (ActionRequest)mlTaskGetRequest, this.getMLTaskResponseActionListener(listener));
    }

    @Override
    public void deleteTask(String taskId, ActionListener<DeleteResponse> listener) {
        MLTaskDeleteRequest mlTaskDeleteRequest = MLTaskDeleteRequest.builder().taskId(taskId).build();
        this.client.execute((ActionType)MLTaskDeleteAction.INSTANCE, (ActionRequest)mlTaskDeleteRequest, ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void deleteTask(String taskId, String tenantId, ActionListener<DeleteResponse> listener) {
        MLTaskDeleteRequest mlTaskDeleteRequest = MLTaskDeleteRequest.builder().taskId(taskId).tenantId(tenantId).build();
        this.client.execute((ActionType)MLTaskDeleteAction.INSTANCE, (ActionRequest)mlTaskDeleteRequest, ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void searchTask(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        this.client.execute((ActionType)MLTaskSearchAction.INSTANCE, (ActionRequest)searchRequest, ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void register(MLRegisterModelInput mlInput, ActionListener<MLRegisterModelResponse> listener) {
        MLRegisterModelRequest registerRequest = new MLRegisterModelRequest(mlInput);
        this.client.execute((ActionType)MLRegisterModelAction.INSTANCE, (ActionRequest)registerRequest, this.getMLRegisterModelResponseActionListener(listener));
    }

    @Override
    public void deploy(String modelId, String tenantId, ActionListener<MLDeployModelResponse> listener) {
        MLDeployModelRequest deployModelRequest = new MLDeployModelRequest(modelId, tenantId, false);
        this.client.execute((ActionType)MLDeployModelAction.INSTANCE, (ActionRequest)deployModelRequest, this.getMlDeployModelResponseActionListener(listener));
    }

    @Override
    public void undeploy(String[] modelIds, String[] nodeIds, String tenantId, ActionListener<MLUndeployModelsResponse> listener) {
        MLUndeployModelsRequest undeployModelRequest = new MLUndeployModelsRequest(modelIds, nodeIds, tenantId);
        this.client.execute((ActionType)MLUndeployModelsAction.INSTANCE, (ActionRequest)undeployModelRequest, this.getMlUndeployModelsResponseActionListener(listener));
    }

    @Override
    public void createConnector(MLCreateConnectorInput mlCreateConnectorInput, ActionListener<MLCreateConnectorResponse> listener) {
        MLCreateConnectorRequest createConnectorRequest = new MLCreateConnectorRequest(mlCreateConnectorInput);
        this.client.execute((ActionType)MLCreateConnectorAction.INSTANCE, (ActionRequest)createConnectorRequest, this.getMlCreateConnectorResponseActionListener(listener));
    }

    @Override
    public void deleteConnector(String connectorId, String tenantId, ActionListener<DeleteResponse> listener) {
        MLConnectorDeleteRequest connectorDeleteRequest = new MLConnectorDeleteRequest(connectorId, tenantId);
        this.client.execute((ActionType)MLConnectorDeleteAction.INSTANCE, (ActionRequest)connectorDeleteRequest, ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void registerAgent(MLAgent mlAgent, ActionListener<MLRegisterAgentResponse> listener) {
        MLRegisterAgentRequest mlRegisterAgentRequest = MLRegisterAgentRequest.builder().mlAgent(mlAgent).build();
        this.client.execute((ActionType)MLRegisterAgentAction.INSTANCE, (ActionRequest)mlRegisterAgentRequest, this.getMLRegisterAgentResponseActionListener(listener));
    }

    @Override
    public void getAgent(String agentId, ActionListener<MLAgentGetResponse> listener) {
        MLAgentGetRequest mlAgentGetRequest = MLAgentGetRequest.builder().agentId(agentId).build();
        this.client.execute((ActionType)MLAgentGetAction.INSTANCE, (ActionRequest)mlAgentGetRequest, this.getMlGetAgentResponseActionListener(listener));
    }

    @Override
    public void deleteAgent(String agentId, String tenantId, ActionListener<DeleteResponse> listener) {
        MLAgentDeleteRequest agentDeleteRequest = new MLAgentDeleteRequest(agentId, tenantId);
        this.client.execute((ActionType)MLAgentDeleteAction.INSTANCE, (ActionRequest)agentDeleteRequest, ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void listTools(ActionListener<List<ToolMetadata>> listener) {
        MLToolsListRequest mlToolsListRequest = MLToolsListRequest.builder().build();
        this.client.execute((ActionType)MLListToolsAction.INSTANCE, (ActionRequest)mlToolsListRequest, this.getMlListToolsResponseActionListener(listener));
    }

    @Override
    public void getTool(String toolName, ActionListener<ToolMetadata> listener) {
        MLToolGetRequest mlToolGetRequest = MLToolGetRequest.builder().toolName(toolName).build();
        this.client.execute((ActionType)MLGetToolAction.INSTANCE, (ActionRequest)mlToolGetRequest, this.getMlGetToolResponseActionListener(listener));
    }

    @Override
    public void getConfig(String configId, String tenantId, ActionListener<MLConfig> listener) {
        MLConfigGetRequest mlConfigGetRequest = MLConfigGetRequest.builder().configId(configId).tenantId(tenantId).build();
        this.client.execute((ActionType)MLConfigGetAction.INSTANCE, (ActionRequest)mlConfigGetRequest, this.getMlGetConfigResponseActionListener(listener));
    }

    private ActionListener<MLToolsListResponse> getMlListToolsResponseActionListener(ActionListener<List<ToolMetadata>> listener) {
        ActionListener internalListener = ActionListener.wrap(mlModelListResponse -> listener.onResponse(mlModelListResponse.getToolMetadataList()), arg_0 -> listener.onFailure(arg_0));
        return this.wrapActionListener(internalListener, MLToolsListResponse::fromActionResponse);
    }

    private ActionListener<MLToolGetResponse> getMlGetToolResponseActionListener(ActionListener<ToolMetadata> listener) {
        ActionListener internalListener = ActionListener.wrap(mlModelGetResponse -> listener.onResponse((Object)mlModelGetResponse.getToolMetadata()), arg_0 -> listener.onFailure(arg_0));
        return this.wrapActionListener(internalListener, MLToolGetResponse::fromActionResponse);
    }

    private ActionListener<MLConfigGetResponse> getMlGetConfigResponseActionListener(ActionListener<MLConfig> listener) {
        ActionListener internalListener = ActionListener.wrap(mlConfigGetResponse -> listener.onResponse((Object)mlConfigGetResponse.getMlConfig()), arg_0 -> listener.onFailure(arg_0));
        return this.wrapActionListener(internalListener, MLConfigGetResponse::fromActionResponse);
    }

    private ActionListener<MLRegisterAgentResponse> getMLRegisterAgentResponseActionListener(ActionListener<MLRegisterAgentResponse> listener) {
        return this.wrapActionListener(listener, MLRegisterAgentResponse::fromActionResponse);
    }

    private ActionListener<MLAgentGetResponse> getMlGetAgentResponseActionListener(ActionListener<MLAgentGetResponse> listener) {
        return this.wrapActionListener(listener, MLAgentGetResponse::fromActionResponse);
    }

    private ActionListener<MLExecuteTaskResponse> getMLExecuteResponseActionListener(ActionListener<MLExecuteTaskResponse> listener) {
        return this.wrapActionListener(listener, MLExecuteTaskResponse::fromActionResponse);
    }

    private ActionListener<MLTaskGetResponse> getMLTaskResponseActionListener(ActionListener<MLTask> listener) {
        ActionListener internalListener = ActionListener.wrap(getResponse -> listener.onResponse((Object)getResponse.getMlTask()), arg_0 -> listener.onFailure(arg_0));
        return this.wrapActionListener(internalListener, MLTaskGetResponse::fromActionResponse);
    }

    private ActionListener<MLDeployModelResponse> getMlDeployModelResponseActionListener(ActionListener<MLDeployModelResponse> listener) {
        return this.wrapActionListener(listener, MLDeployModelResponse::fromActionResponse);
    }

    private ActionListener<MLUndeployModelsResponse> getMlUndeployModelsResponseActionListener(ActionListener<MLUndeployModelsResponse> listener) {
        return this.wrapActionListener(listener, MLUndeployModelsResponse::fromActionResponse);
    }

    private ActionListener<MLCreateConnectorResponse> getMlCreateConnectorResponseActionListener(ActionListener<MLCreateConnectorResponse> listener) {
        return this.wrapActionListener(listener, MLCreateConnectorResponse::fromActionResponse);
    }

    private ActionListener<MLRegisterModelGroupResponse> getMlRegisterModelGroupResponseActionListener(ActionListener<MLRegisterModelGroupResponse> listener) {
        return this.wrapActionListener(listener, MLRegisterModelGroupResponse::fromActionResponse);
    }

    private ActionListener<MLTaskResponse> getMlPredictionTaskResponseActionListener(ActionListener<MLOutput> listener) {
        ActionListener internalListener = ActionListener.wrap(predictionResponse -> listener.onResponse((Object)predictionResponse.getOutput()), arg_0 -> listener.onFailure(arg_0));
        return this.wrapActionListener(internalListener, MLTaskResponse::fromActionResponse);
    }

    private ActionListener<MLRegisterModelResponse> getMLRegisterModelResponseActionListener(ActionListener<MLRegisterModelResponse> listener) {
        return this.wrapActionListener(listener, MLRegisterModelResponse::fromActionResponse);
    }

    private <T extends ActionResponse> ActionListener<T> wrapActionListener(ActionListener<T> listener, Function<ActionResponse, T> recreate) {
        return ActionListener.wrap(r -> listener.onResponse((Object)((ActionResponse)recreate.apply((ActionResponse)r))), arg_0 -> listener.onFailure(arg_0));
    }

    private void validateMLInput(MLInput mlInput, boolean requireInput) {
        if (mlInput == null) {
            throw new IllegalArgumentException("ML Input can't be null");
        }
        if (requireInput && mlInput.getInputDataset() == null) {
            throw new IllegalArgumentException("input data set can't be null");
        }
    }

    @Generated
    public MachineLearningNodeClient(Client client) {
        this.client = client;
    }
}

