/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.controller.MLController;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.controller.MLControllerDeleteRequest;
import org.opensearch.ml.common.transport.controller.MLUndeployControllerAction;
import org.opensearch.ml.common.transport.controller.MLUndeployControllerNodesRequest;
import org.opensearch.ml.common.transport.controller.MLUndeployControllerNodesResponse;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.model.MLModelCacheHelper;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class DeleteControllerTransportAction
extends HandledTransportAction<ActionRequest, DeleteResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(DeleteControllerTransportAction.class);
    private Client client;
    private NamedXContentRegistry xContentRegistry;
    private ClusterService clusterService;
    private MLModelManager mlModelManager;
    private MLModelCacheHelper mlModelCacheHelper;
    private ModelAccessControlHelper modelAccessControlHelper;
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public DeleteControllerTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, NamedXContentRegistry xContentRegistry, ClusterService clusterService, MLModelManager mlModelManager, MLModelCacheHelper mlModelCacheHelper, ModelAccessControlHelper modelAccessControlHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/controllers/delete", transportService, actionFilters, MLControllerDeleteRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.mlModelManager = mlModelManager;
        this.mlModelCacheHelper = mlModelCacheHelper;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<DeleteResponse> actionListener) {
        MLControllerDeleteRequest controllerDeleteRequest = MLControllerDeleteRequest.fromActionRequest((ActionRequest)request);
        String modelId = controllerDeleteRequest.getModelId();
        User user = RestActionUtils.getUserContext(this.client);
        String[] excludes = new String[]{"model_content", "content"};
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            if (!this.mlFeatureEnabledSetting.isControllerEnabled().booleanValue()) {
                throw new IllegalStateException("Controller is currently disabled. To enable it, update the setting \"plugins.ml_commons.controller_enabled\" to true.");
            }
            ActionListener wrappedListener = ActionListener.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            this.mlModelManager.getModel(modelId, null, excludes, (ActionListener<MLModel>)ActionListener.wrap(mlModel -> {
                Boolean isHidden = mlModel.getIsHidden();
                this.modelAccessControlHelper.validateModelGroupAccess(user, mlModel.getModelGroupId(), "cluster:admin/opensearch/ml/controllers/delete", this.client, (ActionListener<Boolean>)ActionListener.wrap(hasPermission -> {
                    if (hasPermission.booleanValue()) {
                        this.mlModelManager.getController(modelId, (ActionListener<MLController>)ActionListener.wrap(controller -> this.deleteControllerWithDeployedModel(modelId, mlModel.getIsHidden(), (ActionListener<DeleteResponse>)wrappedListener), deleteException -> {
                            log.error(deleteException);
                            wrappedListener.onFailure(deleteException);
                        }));
                    } else {
                        wrappedListener.onFailure((Exception)new OpenSearchStatusException(StringUtils.getErrorMessage((String)"User doesn't have privilege to perform this operation on this model controller.", (String)modelId, (Boolean)isHidden), RestStatus.FORBIDDEN, new Object[0]));
                    }
                }, exception -> {
                    log.error(StringUtils.getErrorMessage((String)"Permission denied: Unable to delete the model controller with the provided model. Details: ", (String)modelId, (Boolean)isHidden), (Throwable)exception);
                    wrappedListener.onFailure(exception);
                }));
            }, e -> {
                log.warn("Failed to find corresponding model during deleting the model controller. Now trying to delete the model controller alone.");
                this.mlModelManager.getController(modelId, (ActionListener<MLController>)ActionListener.wrap(controller -> this.deleteControllerWithDeployedModel(modelId, Boolean.TRUE, (ActionListener<DeleteResponse>)wrappedListener), deleteException -> {
                    log.error(deleteException);
                    wrappedListener.onFailure(deleteException);
                }));
            }));
        }
        catch (Exception e2) {
            log.error("Failed to delete model controller for the given model", (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }

    private void deleteControllerWithDeployedModel(String modelId, Boolean isHidden, ActionListener<DeleteResponse> actionListener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            if (!ArrayUtils.isEmpty((Object[])this.mlModelCacheHelper.getWorkerNodes(modelId))) {
                log.info("Model has already been deployed in ML cache, need undeploy model controller before sending delete request.");
                String[] targetNodeIds = this.getAllNodes();
                MLUndeployControllerNodesRequest undeployControllerNodesRequest = new MLUndeployControllerNodesRequest(targetNodeIds, modelId);
                this.client.execute((ActionType)MLUndeployControllerAction.INSTANCE, (ActionRequest)undeployControllerNodesRequest, ActionListener.runBefore((ActionListener)ActionListener.wrap(nodesResponse -> {
                    if (nodesResponse != null && this.isUndeployControllerSuccessOnAllNodes((MLUndeployControllerNodesResponse)nodesResponse)) {
                        log.info(StringUtils.getErrorMessage((String)"Successfully undeploy model controller from cache. Start to delete the model controller", (String)modelId, (Boolean)isHidden));
                        this.deleteController(modelId, isHidden, actionListener);
                    } else {
                        Object[] nodeIds = this.getUndeployControllerFailedNodesList((MLUndeployControllerNodesResponse)nodesResponse);
                        String errorMessage = StringUtils.getErrorMessage((String)("Failed to undeploy model controller with the given model on following nodes " + Arrays.toString(nodeIds) + ", deletion is aborted. Please retry or undeploy the model manually and then perform the deletion."), (String)modelId, (Boolean)isHidden);
                        log.error(errorMessage);
                        actionListener.onFailure((Exception)new RuntimeException(errorMessage));
                    }
                }, e -> {
                    log.error(StringUtils.getErrorMessage((String)"Failed to undeploy model controller from cache and delete the model controller", (String)modelId, (Boolean)isHidden));
                    actionListener.onFailure(e);
                }), () -> ((ThreadContext.StoredContext)context).restore()));
            } else {
                this.deleteController(modelId, isHidden, actionListener);
            }
        }
        catch (Exception e2) {
            log.error("Failed to delete model controller", (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }

    private void deleteController(final String modelId, final Boolean isHidden, final ActionListener<DeleteResponse> actionListener) {
        DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(".plugins-ml-controller", modelId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.client.delete(deleteRequest, (ActionListener)new ActionListener<DeleteResponse>(this){
            final /* synthetic */ DeleteControllerTransportAction this$0;
            {
                this.this$0 = this$0;
            }

            public void onResponse(DeleteResponse deleteResponse) {
                log.info(StringUtils.getErrorMessage((String)"Model controller for the provided successfully deleted from index, result: {}", (String)modelId, (Boolean)isHidden), (Object)deleteResponse.getResult());
                this.this$0.mlModelManager.updateModel(modelId, isHidden, Map.of("is_controller_enabled", false));
                actionListener.onResponse((Object)deleteResponse);
            }

            public void onFailure(Exception e) {
                log.error(StringUtils.getErrorMessage((String)"Failed to delete model controller for the provided model.", (String)modelId, (Boolean)isHidden), (Throwable)e);
                actionListener.onFailure(e);
            }
        });
    }

    private boolean isUndeployControllerSuccessOnAllNodes(MLUndeployControllerNodesResponse undeployControllerNodesResponse) {
        return undeployControllerNodesResponse.failures() == null || undeployControllerNodesResponse.failures().isEmpty();
    }

    private String[] getUndeployControllerFailedNodesList(MLUndeployControllerNodesResponse undeployControllerNodesResponse) {
        if (undeployControllerNodesResponse == null) {
            return this.getAllNodes();
        }
        ArrayList<String> nodeIds = new ArrayList<String>();
        for (FailedNodeException failedNodeException : undeployControllerNodesResponse.failures()) {
            nodeIds.add(failedNodeException.nodeId());
        }
        return nodeIds.toArray(new String[0]);
    }

    private String[] getAllNodes() {
        Iterator iterator = this.clusterService.state().nodes().iterator();
        ArrayList<String> nodeIds = new ArrayList<String>();
        while (iterator.hasNext()) {
            nodeIds.add(((DiscoveryNode)iterator.next()).getId());
        }
        return nodeIds.toArray(new String[0]);
    }
}

