/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.response.agg;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.opensearch.search.SearchHits;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.opensearch.search.aggregations.bucket.histogram.InternalAutoDateHistogram;
import org.opensearch.search.aggregations.bucket.range.Range;
import org.opensearch.search.aggregations.bucket.terms.InternalMultiTerms;
import org.opensearch.sql.opensearch.response.agg.MetricParser;
import org.opensearch.sql.opensearch.response.agg.MetricParserHelper;
import org.opensearch.sql.opensearch.response.agg.OpenSearchAggregationResponseParser;

public class BucketAggregationParser
implements OpenSearchAggregationResponseParser {
    private final MetricParserHelper metricsParser;
    private List<String> countAggNameList = List.of();

    public BucketAggregationParser(MetricParser ... metricParserList) {
        this.metricsParser = new MetricParserHelper(Arrays.asList(metricParserList));
    }

    public BucketAggregationParser(List<MetricParser> metricParserList) {
        this.metricsParser = new MetricParserHelper(metricParserList);
    }

    public BucketAggregationParser(List<MetricParser> metricParserList, List<String> countAggNameList) {
        this.metricsParser = new MetricParserHelper(metricParserList, countAggNameList);
        this.countAggNameList = countAggNameList;
    }

    @Override
    public List<Map<String, Object>> parse(Aggregations aggregations) {
        Aggregation agg = (Aggregation)aggregations.asList().getFirst();
        return ((MultiBucketsAggregation)agg).getBuckets().stream().map(b -> this.parseBucket((MultiBucketsAggregation.Bucket)b, agg.getName())).filter(Objects::nonNull).flatMap(Collection::stream).toList();
    }

    private List<Map<String, Object>> parseBucket(MultiBucketsAggregation.Bucket bucket, String name) {
        if ((bucket instanceof Range.Bucket || bucket instanceof InternalAutoDateHistogram.Bucket) && bucket.getDocCount() == 0L) {
            return null;
        }
        Aggregations aggregations = bucket.getAggregations();
        List<Map<String, Object>> results = this.isLeafAgg(aggregations) ? this.parseLeafAgg(aggregations, bucket.getDocCount()) : this.parse(aggregations);
        Optional<Map<String, Object>> common = this.extract(bucket, name);
        common.ifPresent(commonMap -> results.forEach(r -> r.putAll(commonMap)));
        return results;
    }

    private boolean isLeafAgg(Aggregations aggregations) {
        return aggregations.asList().size() != 1 || !(aggregations.asList().get(0) instanceof MultiBucketsAggregation);
    }

    private List<Map<String, Object>> parseLeafAgg(Aggregations aggregations, long docCount) {
        List<Map<String, Object>> resultMapList = this.metricsParser.parse(aggregations);
        List<Map<String, Object>> maps = resultMapList.isEmpty() ? List.of(new HashMap()) : resultMapList;
        this.countAggNameList.forEach(countAggName -> maps.forEach(map -> map.put(countAggName, docCount)));
        return maps;
    }

    @Override
    public List<Map<String, Object>> parse(SearchHits hits) {
        throw new UnsupportedOperationException("BucketAggregationParser doesn't support parse(SearchHits)");
    }

    protected Optional<Map<String, Object>> extract(MultiBucketsAggregation.Bucket bucket, String name) {
        Map<String, Object> extracted;
        if (bucket instanceof CompositeAggregation.Bucket) {
            CompositeAggregation.Bucket compositeBucket = (CompositeAggregation.Bucket)bucket;
            extracted = compositeBucket.getKey();
        } else if (bucket instanceof InternalMultiTerms.Bucket) {
            List<String> keys = Arrays.asList(name.split("\\|"));
            extracted = IntStream.range(0, keys.size()).boxed().collect(Collectors.toMap(keys::get, ((List)bucket.getKey())::get));
        } else {
            extracted = Map.of(name, bucket.getKey());
        }
        return Optional.ofNullable(extracted);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BucketAggregationParser)) {
            return false;
        }
        BucketAggregationParser other = (BucketAggregationParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MetricParserHelper this$metricsParser = this.getMetricsParser();
        MetricParserHelper other$metricsParser = other.getMetricsParser();
        if (this$metricsParser == null ? other$metricsParser != null : !((Object)this$metricsParser).equals(other$metricsParser)) {
            return false;
        }
        List<String> this$countAggNameList = this.countAggNameList;
        List<String> other$countAggNameList = other.countAggNameList;
        return !(this$countAggNameList == null ? other$countAggNameList != null : !((Object)this$countAggNameList).equals(other$countAggNameList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BucketAggregationParser;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MetricParserHelper $metricsParser = this.getMetricsParser();
        result = result * 59 + ($metricsParser == null ? 43 : ((Object)$metricsParser).hashCode());
        List<String> $countAggNameList = this.countAggNameList;
        result = result * 59 + ($countAggNameList == null ? 43 : ((Object)$countAggNameList).hashCode());
        return result;
    }

    @Generated
    public MetricParserHelper getMetricsParser() {
        return this.metricsParser;
    }
}

