/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.sql.parser;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.opensearch.sql.ast.dsl.AstDSL;
import org.opensearch.sql.ast.expression.Argument;
import org.opensearch.sql.ast.expression.Field;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.sql.antlr.parser.OpenSearchSQLParser;
import org.opensearch.sql.sql.antlr.parser.OpenSearchSQLParserBaseVisitor;
import org.opensearch.sql.sql.parser.context.QuerySpecification;
import shaded.com.google.common.collect.ImmutableList;

public class AstSortBuilder
extends OpenSearchSQLParserBaseVisitor<UnresolvedPlan> {
    private final QuerySpecification querySpec;

    @Override
    public UnresolvedPlan visitOrderByClause(OpenSearchSQLParser.OrderByClauseContext ctx) {
        return new Sort(this.createSortFields());
    }

    private List<Field> createSortFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        List<UnresolvedExpression> items = this.querySpec.getOrderByItems();
        List<Sort.SortOption> options = this.querySpec.getOrderByOptions();
        for (int i = 0; i < items.size(); ++i) {
            fields.add(new Field(this.querySpec.replaceIfAliasOrOrdinal(items.get(i)), this.createSortArguments(options.get(i))));
        }
        return fields;
    }

    private List<Argument> createSortArguments(Sort.SortOption option) {
        Sort.SortOrder sortOrder = option.getSortOrder();
        Sort.NullOrder nullOrder = option.getNullOrder();
        ImmutableList.Builder args = ImmutableList.builder();
        args.add((Object)new Argument("asc", AstDSL.booleanLiteral(sortOrder != Sort.SortOrder.DESC)));
        if (nullOrder != null) {
            args.add((Object)new Argument("nullFirst", AstDSL.booleanLiteral(nullOrder == Sort.NullOrder.NULL_FIRST)));
        }
        return args.build();
    }

    @Generated
    public AstSortBuilder(QuerySpecification querySpec) {
        this.querySpec = querySpec;
    }
}

