/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.transport.handler;

import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.util.RestHandlerUtils;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.client.SearchDataObjectRequest;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.transport.client.Client;

public class SearchHandler {
    private final Logger logger = LogManager.getLogger(SearchHandler.class);
    private final Client client;
    private final SdkClient sdkClient;
    private volatile Boolean filterByBackendRole;

    public SearchHandler(Settings settings, ClusterService clusterService, Client client, SdkClient sdkClient, Setting<Boolean> filterByBackendRoleSetting) {
        this.client = client;
        this.sdkClient = sdkClient;
        this.filterByBackendRole = (Boolean)filterByBackendRoleSetting.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(filterByBackendRoleSetting, it -> {
            this.filterByBackendRole = it;
        });
    }

    public void search(SearchRequest request, String tenantId, String resourceType, ActionListener<SearchResponse> actionListener) {
        User user = ParseUtils.getUserContext(this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.logger.info("Searching workflows in global context");
            SearchSourceBuilder searchSourceBuilder = request.source();
            searchSourceBuilder.fetchSource(RestHandlerUtils.getSourceContext(user, searchSourceBuilder));
            this.validateRole(request, tenantId, user, resourceType, actionListener, context);
        }
        catch (Exception e) {
            this.logger.error("Failed to search workflows in global context", (Throwable)e);
            actionListener.onFailure(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validateRole(SearchRequest request, String tenantId, User user, String resourceType, ActionListener<SearchResponse> listener, ThreadContext.StoredContext context) {
        block6: {
            block5: {
                if (ParseUtils.shouldUseResourceAuthz(resourceType)) {
                    this.doSearch(request, tenantId, (ActionListener<SearchResponse>)ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore()));
                    return;
                }
                if (user == null || !this.filterByBackendRole.booleanValue()) break block5;
                if (!ParseUtils.isAdmin(user)) break block6;
            }
            this.doSearch(request, tenantId, (ActionListener<SearchResponse>)ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore()));
            return;
        }
        try {
            ParseUtils.addUserBackendRolesFilter(user, request.source());
            this.logger.debug("Filtering result by {}", (Object)user.getBackendRoles());
            this.doSearch(request, tenantId, (ActionListener<SearchResponse>)ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore()));
            return;
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void doSearch(SearchRequest request, String tenantId, ActionListener<SearchResponse> listener) {
        SearchDataObjectRequest searchRequest = SearchDataObjectRequest.builder().indices(request.indices()).tenantId(tenantId).searchSourceBuilder(request.source()).build();
        this.sdkClient.searchDataObjectAsync(searchRequest).whenComplete((r, throwable) -> {
            if (throwable == null) {
                try {
                    SearchResponse searchResponse = SearchResponse.fromXContent((XContentParser)r.parser());
                    this.logger.info(Arrays.toString(request.indices()) + " search complete: {}", (Object)searchResponse.getHits().getTotalHits());
                    listener.onResponse((Object)searchResponse);
                }
                catch (Exception e) {
                    this.logger.error("Failed to parse search response", (Throwable)e);
                    listener.onFailure((Exception)((Object)new FlowFrameworkException("Failed to parse search response", RestStatus.INTERNAL_SERVER_ERROR)));
                }
            } else {
                Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                this.logger.error("Search failed for indices: {}", (Object)Arrays.toString(request.indices()), (Object)cause);
                listener.onFailure(cause);
            }
        });
    }
}

