/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.opensearch.core.common.Strings;
import org.opensearch.flowframework.common.CommonValue;

public final class JsonToJsonTransformer {
    private static final ObjectMapper MAPPER;
    private static final Configuration JSON_PATH_CFG;
    private static final Pattern EXPLICIT_INDEX_PATTERN;
    private static final Pattern WILDCARD_PATTERN;

    private JsonToJsonTransformer() {
    }

    public static String transform(String inputJson, String mappingRules) throws IllegalArgumentException, JsonProcessingException {
        String document;
        if (Strings.isNullOrEmpty((String)inputJson)) {
            throw new IllegalArgumentException("inputJson must not be null or empty");
        }
        if (Strings.isNullOrEmpty((String)mappingRules)) {
            throw new IllegalArgumentException("mappingRules must not be null or empty");
        }
        JsonNode mappingNode = MAPPER.readTree(mappingRules);
        try {
            document = JsonPath.using((Configuration)JSON_PATH_CFG).parse(inputJson).jsonString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid input JSON for JsonPath parsing", e);
        }
        ObjectNode outputRoot = MAPPER.createObjectNode();
        JsonToJsonTransformer.buildOutputFromMapping(outputRoot, mappingNode, document);
        return MAPPER.writeValueAsString((Object)outputRoot);
    }

    private static void buildOutputFromMapping(ObjectNode outputNode, JsonNode mappingNode, String inputDocument) {
        if (mappingNode.isTextual()) {
            throw new IllegalArgumentException("Root mapping cannot be a JsonPath string - it must be an object");
        }
        if (!mappingNode.isObject()) {
            throw new IllegalArgumentException("Mapping contains unsupported node type: " + String.valueOf(mappingNode.getNodeType()));
        }
        Iterator fields = mappingNode.fields();
        while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            String propertyKey = (String)entry.getKey();
            JsonNode propertyValue = (JsonNode)entry.getValue();
            if (JsonToJsonTransformer.isArrayProperty(propertyKey)) {
                JsonToJsonTransformer.processArrayProperty(outputNode, propertyKey, propertyValue, inputDocument);
                continue;
            }
            if (propertyValue.isTextual()) {
                JsonToJsonTransformer.processSimpleProperty(outputNode, propertyKey, propertyValue, inputDocument);
                continue;
            }
            if (propertyValue.isObject()) {
                ObjectNode nestedOutputNode = outputNode.withObject(propertyKey);
                JsonToJsonTransformer.buildOutputFromMapping(nestedOutputNode, propertyValue, inputDocument);
                continue;
            }
            throw new IllegalArgumentException("Property '" + propertyKey + "' has unsupported value type: " + String.valueOf(propertyValue.getNodeType()));
        }
    }

    private static void processSimpleProperty(ObjectNode outputNode, String propertyKey, JsonNode jsonPathNode, String inputDocument) {
        String jsonPath = jsonPathNode.asText();
        List extracted = (List)JsonPath.using((Configuration)JSON_PATH_CFG).parse(inputDocument).read(jsonPath, new Predicate[0]);
        if (extracted == null || extracted.isEmpty()) {
            return;
        }
        boolean shouldBeArray = jsonPath.endsWith("[*]");
        if (shouldBeArray || extracted.size() > 1) {
            ArrayNode arrayNode = MAPPER.createArrayNode();
            for (Object value : extracted) {
                arrayNode.add(MAPPER.valueToTree(value));
            }
            outputNode.set(propertyKey, (JsonNode)arrayNode);
        } else {
            outputNode.set(propertyKey, MAPPER.valueToTree(extracted.get(0)));
        }
    }

    private static void processArrayProperty(ObjectNode outputNode, String arrayPropertyKey, JsonNode elementMapping, String inputDocument) {
        ArrayKeyInfo keyInfo = JsonToJsonTransformer.parseArrayKey(arrayPropertyKey);
        ArrayNode arrayNode = outputNode.withArray(keyInfo.propertyName);
        if (keyInfo.isWildcard) {
            int arraySize = JsonToJsonTransformer.determineArraySize(elementMapping, inputDocument);
            for (int i = 0; i < arraySize; ++i) {
                ObjectNode elementNode = MAPPER.createObjectNode();
                arrayNode.add((JsonNode)elementNode);
                JsonNode processedMapping = JsonToJsonTransformer.substituteWildcardsInMapping(elementMapping, i);
                JsonToJsonTransformer.buildOutputFromMapping(elementNode, processedMapping, inputDocument);
            }
        } else {
            int targetIndex = keyInfo.explicitIndex;
            while (arrayNode.size() <= targetIndex) {
                arrayNode.add((JsonNode)MAPPER.createObjectNode());
            }
            ObjectNode elementNode = (ObjectNode)arrayNode.get(targetIndex);
            JsonToJsonTransformer.buildOutputFromMapping(elementNode, elementMapping, inputDocument);
        }
    }

    private static boolean isArrayProperty(String key) {
        return key.contains("[") && key.contains("]");
    }

    private static ArrayKeyInfo parseArrayKey(String arrayKey) {
        int bracketPos = arrayKey.indexOf(91);
        String propertyName = arrayKey.substring(0, bracketPos);
        String indexToken = arrayKey.substring(bracketPos);
        if ("[*]".equals(indexToken)) {
            return new ArrayKeyInfo(propertyName, true, -1);
        }
        if (EXPLICIT_INDEX_PATTERN.matcher(indexToken).matches()) {
            int index = Integer.parseInt(indexToken.substring(1, indexToken.length() - 1));
            return new ArrayKeyInfo(propertyName, false, index);
        }
        throw new IllegalArgumentException("Unsupported array index format: " + arrayKey);
    }

    private static JsonNode substituteWildcardsInMapping(JsonNode mapping, int index) {
        if (mapping.isTextual()) {
            String jsonPath = mapping.asText();
            String substituted = WILDCARD_PATTERN.matcher(jsonPath).replaceFirst("[" + index + "]");
            return MAPPER.getNodeFactory().textNode(substituted);
        }
        if (mapping.isObject()) {
            ObjectNode result = MAPPER.createObjectNode();
            Iterator fields = mapping.fields();
            while (fields.hasNext()) {
                Map.Entry entry = (Map.Entry)fields.next();
                result.set((String)entry.getKey(), JsonToJsonTransformer.substituteWildcardsInMapping((JsonNode)entry.getValue(), index));
            }
            return result;
        }
        return mapping;
    }

    private static int determineArraySize(JsonNode elementMapping, String inputDocument) {
        String samplePath = JsonToJsonTransformer.findFirstWildcardPath(elementMapping);
        if (samplePath != null) {
            List matches = (List)JsonPath.using((Configuration)JSON_PATH_CFG).parse(inputDocument).read(samplePath, new Predicate[0]);
            return matches != null ? matches.size() : 0;
        }
        return 0;
    }

    private static String findFirstWildcardPath(JsonNode mapping) {
        if (mapping.isTextual()) {
            String path = mapping.asText();
            return path.contains("[*]") ? path : null;
        }
        if (mapping.isObject()) {
            for (JsonNode element : mapping) {
                String result = JsonToJsonTransformer.findFirstWildcardPath(element);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    static {
        EXPLICIT_INDEX_PATTERN = Pattern.compile("\\[\\d+\\]");
        WILDCARD_PATTERN = Pattern.compile("\\[\\*\\]");
        StreamReadConstraints constraints = StreamReadConstraints.builder().maxNestingDepth(CommonValue.MAX_JSON_NESTING_DEPTH).maxStringLength(CommonValue.MAX_JSON_SIZE).maxNameLength(CommonValue.MAX_JSON_NAME_LENGTH).build();
        MAPPER = new ObjectMapper();
        MAPPER.getFactory().setStreamReadConstraints(constraints);
        JSON_PATH_CFG = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonProvider(MAPPER)).mappingProvider((MappingProvider)new JacksonMappingProvider(MAPPER)).options(new Option[]{Option.ALWAYS_RETURN_LIST, Option.SUPPRESS_EXCEPTIONS}).build();
    }

    private static class ArrayKeyInfo {
        final String propertyName;
        final boolean isWildcard;
        final int explicitIndex;

        ArrayKeyInfo(String propertyName, boolean isWildcard, int explicitIndex) {
            this.propertyName = propertyName;
            this.isWildcard = isWildcard;
            this.explicitIndex = explicitIndex;
        }
    }
}

