/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jobscheduler.rest.action;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.jobscheduler.spi.LockModel;
import org.opensearch.jobscheduler.spi.utils.LockService;
import org.opensearch.jobscheduler.utils.JobDetailsService;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.transport.client.node.NodeClient;

public class RestReleaseLockAction
extends BaseRestHandler {
    public static final String RELEASE_LOCK_ACTION = "release_lock_action";
    private final Logger logger = LogManager.getLogger(RestReleaseLockAction.class);
    private LockService lockService;

    public RestReleaseLockAction(LockService lockService) {
        this.lockService = lockService;
    }

    public String getName() {
        return RELEASE_LOCK_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, String.format(Locale.ROOT, "%s/%s/{%s}", "/_plugins/_job_scheduler", "_release_lock", "lock_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient nodeClient) throws IOException {
        LockModel releaseLock;
        String lockId = restRequest.param("lock_id");
        if (lockId == null || lockId.isEmpty()) {
            throw new IOException("lockId cannot be null or empty");
        }
        final CompletableFuture releaseLockInProgressFuture = new CompletableFuture();
        CompletableFuture findInProgressFuture = new CompletableFuture();
        this.lockService.findLock(lockId, ActionListener.wrap(lock -> findInProgressFuture.complete(lock), exception -> {
            this.logger.error("Could not find lock model with lockId " + lockId, (Throwable)exception);
            findInProgressFuture.completeExceptionally((Throwable)exception);
        }));
        try {
            releaseLock = (LockModel)findInProgressFuture.orTimeout(JobDetailsService.TIME_OUT_FOR_REQUEST, TimeUnit.SECONDS).get();
        }
        catch (InterruptedException | CompletionException | ExecutionException e) {
            if (e.getCause() instanceof TimeoutException) {
                this.logger.error(" Finding lock timed out ", (Throwable)e);
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        if (releaseLock != null) {
            this.lockService.release(releaseLock, (ActionListener)new ActionListener<Boolean>(this){
                final /* synthetic */ RestReleaseLockAction this$0;
                {
                    this.this$0 = this$0;
                }

                public void onResponse(Boolean response) {
                    releaseLockInProgressFuture.complete(response);
                }

                public void onFailure(Exception e) {
                    this.this$0.logger.error("Releasing lock failed with an exception", (Throwable)e);
                    releaseLockInProgressFuture.completeExceptionally(e);
                }
            });
            try {
                releaseLockInProgressFuture.orTimeout(JobDetailsService.TIME_OUT_FOR_REQUEST, TimeUnit.SECONDS);
            }
            catch (CompletionException e) {
                if (e.getCause() instanceof TimeoutException) {
                    this.logger.error("Release lock timed out ", (Throwable)e);
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        }
        return channel -> {
            BytesRestResponse bytesRestResponse;
            boolean releaseResponse = false;
            try {
                releaseResponse = (Boolean)releaseLockInProgressFuture.get();
            }
            catch (Exception e) {
                this.logger.error("Exception occured in releasing lock ", (Throwable)e);
            }
            XContentBuilder builder = channel.newBuilder();
            RestStatus restStatus = RestStatus.OK;
            String restResponseString = releaseResponse ? "success" : "failed";
            try {
                builder.startObject();
                builder.field("release-lock", restResponseString);
                if (restResponseString.equals("failed")) {
                    restStatus = RestStatus.INTERNAL_SERVER_ERROR;
                }
                builder.endObject();
                bytesRestResponse = new BytesRestResponse(restStatus, builder);
            }
            finally {
                builder.close();
            }
            channel.sendResponse((RestResponse)bytesRestResponse);
        };
    }
}

