/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.correlation;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.MultiSearchResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.cluster.routing.Preference;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.commons.alerting.model.Finding;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.MatchQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.securityanalytics.correlation.index.query.CorrelationQueryBuilder;
import org.opensearch.securityanalytics.model.CustomLogType;
import org.opensearch.securityanalytics.transport.TransportCorrelateFindingAction;
import org.opensearch.transport.client.Client;

public class VectorEmbeddingsEngine {
    private final Client client;
    private final TransportCorrelateFindingAction.AsyncCorrelateFindingAction correlateFindingAction;
    private volatile TimeValue indexTimeout;
    private volatile long corrTimeWindow;
    private static final Logger log = LogManager.getLogger(VectorEmbeddingsEngine.class);

    public VectorEmbeddingsEngine(Client client, TimeValue indexTimeout, long corrTimeWindow, TransportCorrelateFindingAction.AsyncCorrelateFindingAction correlateFindingAction) {
        this.client = client;
        this.indexTimeout = indexTimeout;
        this.corrTimeWindow = corrTimeWindow;
        this.correlateFindingAction = correlateFindingAction;
    }

    public void insertCorrelatedFindings(String detectorType, Finding finding, String logType, List<String> correlatedFindings, float timestampFeature, List<String> correlationRules, Map<String, CustomLogType> logTypes) {
        SearchRequest searchRequest = this.getSearchMetadataIndexRequest(detectorType, finding, logTypes);
        Map<String, Object> tags = logTypes.get(detectorType).getTags();
        String correlationId = tags.get("correlation_id").toString();
        long findingTimestamp = finding.getTimestamp().toEpochMilli();
        this.client.search(searchRequest, ActionListener.wrap(response -> {
            if (response.isTimedOut()) {
                this.onFailure((Exception)new OpenSearchStatusException("Search request timed out", RestStatus.REQUEST_TIMEOUT, new Object[0]));
            }
            if (response.getHits().getHits().length == 0) {
                this.onFailure((Exception)new ResourceNotFoundException("Failed to find hits in metadata index for finding id {}", new Object[]{finding.getId()}));
            }
            Map hitSource = response.getHits().getHits()[0].getSourceAsMap();
            long counter = Long.parseLong(hitSource.get("counter").toString());
            MultiSearchRequest mSearchRequest = new MultiSearchRequest();
            for (String correlatedFinding : correlatedFindings) {
                BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"finding1", (Object)correlatedFinding)).must((QueryBuilder)QueryBuilders.matchQuery((String)"finding2", (Object)""));
                SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
                searchSourceBuilder.query((QueryBuilder)queryBuilder);
                searchSourceBuilder.fetchSource(true);
                searchSourceBuilder.size(10000);
                SearchRequest request = new SearchRequest();
                request.indices(new String[]{".opensearch-sap-correlation-history*"});
                request.source(searchSourceBuilder);
                request.preference(Preference.PRIMARY_FIRST.type());
                request.setCancelAfterTimeInterval(TimeValue.timeValueSeconds((long)30L));
                mSearchRequest.add(request);
            }
            this.client.multiSearch(mSearchRequest, ActionListener.wrap(items -> {
                MultiSearchResponse.Item[] responses = items.getResponses();
                BulkRequest bulkRequest = new BulkRequest();
                bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                long prevCounter = -1L;
                long totalNeighbors = 0L;
                for (MultiSearchResponse.Item item : responses) {
                    if (item.isFailure()) {
                        log.info(item.getFailureMessage());
                        continue;
                    }
                    long totalHits = item.getResponse().getHits().getHits().length;
                    totalNeighbors += totalHits;
                    int idx = 0;
                    while ((long)idx < totalHits) {
                        SearchHit hit = item.getResponse().getHits().getHits()[idx];
                        Map sourceAsMap = hit.getSourceAsMap();
                        long neighborCounter = Long.parseLong(sourceAsMap.get("counter").toString());
                        String correlatedFinding = sourceAsMap.get("finding1").toString();
                        try {
                            IndexRequest indexRequest;
                            float[] corrVector = new float[3];
                            if (counter != prevCounter) {
                                for (int i = 0; i < 2; ++i) {
                                    corrVector[i] = (float)counter - 50.0f;
                                }
                                corrVector[0] = counter;
                                corrVector[2] = timestampFeature;
                                XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
                                builder.field("root", false);
                                builder.field("counter", counter);
                                builder.field("finding1", finding.getId());
                                builder.field("finding2", "");
                                builder.field("logType", correlationId);
                                builder.field("timestamp", findingTimestamp);
                                builder.field("corr_vector", (Object)corrVector);
                                builder.field("recordType", "finding");
                                builder.field("scoreTimestamp", 0L);
                                builder.endObject();
                                indexRequest = (IndexRequest)new IndexRequest(".opensearch-sap-correlation-history-write").source(builder).timeout(this.indexTimeout);
                                bulkRequest.add(indexRequest);
                            }
                            corrVector = new float[3];
                            for (int i = 0; i < 2; ++i) {
                                corrVector[i] = (float)counter - 50.0f;
                            }
                            corrVector[0] = (2.0f * (float)counter - 50.0f) / 2.0f;
                            corrVector[1] = (2.0f * (float)neighborCounter - 50.0f) / 2.0f;
                            corrVector[2] = timestampFeature;
                            XContentBuilder corrBuilder = XContentFactory.jsonBuilder().startObject();
                            corrBuilder.field("root", false);
                            corrBuilder.field("counter", (long)((2.0f * (float)counter - 50.0f) / 2.0f));
                            corrBuilder.field("finding1", finding.getId());
                            corrBuilder.field("finding2", correlatedFinding);
                            corrBuilder.field("logType", String.format(Locale.ROOT, "%s-%s", detectorType, logType));
                            corrBuilder.field("timestamp", findingTimestamp);
                            corrBuilder.field("corr_vector", (Object)corrVector);
                            corrBuilder.field("recordType", "finding-finding");
                            corrBuilder.field("scoreTimestamp", 0L);
                            corrBuilder.field("corrRules", (Iterable)correlationRules);
                            corrBuilder.endObject();
                            indexRequest = (IndexRequest)new IndexRequest(".opensearch-sap-correlation-history-write").source(corrBuilder).timeout(this.indexTimeout);
                            bulkRequest.add(indexRequest);
                        }
                        catch (Exception ex) {
                            this.onFailure(ex);
                        }
                        prevCounter = counter;
                        ++idx;
                    }
                }
                if (totalNeighbors > 0L) {
                    this.client.bulk(bulkRequest, ActionListener.wrap(bulkResponse -> {
                        if (bulkResponse.hasFailures()) {
                            this.onFailure((Exception)new OpenSearchStatusException("Correlation of finding failed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                        }
                        this.correlateFindingAction.onOperation();
                    }, this::onFailure));
                } else {
                    this.insertOrphanFindings(detectorType, finding, timestampFeature, logTypes);
                }
            }, this::onFailure));
        }, this::onFailure));
    }

    public void insertOrphanFindings(String detectorType, Finding finding, float timestampFeature, Map<String, CustomLogType> logTypes) {
        if (logTypes.get(detectorType) == null) {
            log.debug("Missing detector type {} in the log types index for finding id {}. Keys in the index: {}", (Object)detectorType, (Object)finding.getId(), (Object)Arrays.toString(logTypes.keySet().toArray()));
            this.onFailure((Exception)new OpenSearchStatusException("insertOrphanFindings null log types for detector type: " + detectorType, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
        }
        SearchRequest searchRequest = this.getSearchMetadataIndexRequest(detectorType, finding, logTypes);
        Map<String, Object> tags = logTypes.get(detectorType).getTags();
        String correlationId = tags.get("correlation_id").toString();
        long findingTimestamp = finding.getTimestamp().toEpochMilli();
        this.client.search(searchRequest, ActionListener.wrap(response -> {
            if (response.isTimedOut()) {
                this.onFailure((Exception)new OpenSearchStatusException("Search request timed out", RestStatus.REQUEST_TIMEOUT, new Object[0]));
            }
            try {
                Map hitSource = response.getHits().getHits()[0].getSourceAsMap();
                String id = response.getHits().getHits()[0].getId();
                long counter = Long.parseLong(hitSource.get("counter").toString());
                long timestamp = Long.parseLong(hitSource.get("timestamp").toString());
                if (counter == 0L) {
                    XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
                    builder.field("root", true);
                    builder.field("counter", 50L);
                    builder.field("finding1", "");
                    builder.field("finding2", "");
                    builder.field("logType", "");
                    builder.field("timestamp", findingTimestamp);
                    builder.field("scoreTimestamp", 0L);
                    builder.endObject();
                    IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest(".opensearch-sap-correlation-metadata").id(id).source(builder).timeout(this.indexTimeout)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                    this.client.index(indexRequest, ActionListener.wrap(indexResponse -> {
                        if (indexResponse.status().equals((Object)RestStatus.OK)) {
                            try {
                                float[] corrVector = new float[3];
                                corrVector[0] = 50.0f;
                                corrVector[2] = timestampFeature;
                                XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().startObject();
                                xContentBuilder.field("root", false);
                                xContentBuilder.field("counter", 50L);
                                xContentBuilder.field("finding1", finding.getId());
                                xContentBuilder.field("finding2", "");
                                xContentBuilder.field("logType", correlationId);
                                xContentBuilder.field("timestamp", findingTimestamp);
                                xContentBuilder.field("corr_vector", (Object)corrVector);
                                xContentBuilder.field("recordType", "finding");
                                xContentBuilder.field("scoreTimestamp", 0L);
                                xContentBuilder.endObject();
                                this.indexCorrelatedFindings(xContentBuilder);
                            }
                            catch (Exception ex) {
                                this.onFailure(ex);
                            }
                        } else {
                            this.onFailure((Exception)new OpenSearchStatusException("Indexing failed with response {} ", indexResponse.status(), new Object[]{indexResponse.toString()}));
                        }
                    }, this::onFailure));
                } else if (findingTimestamp - timestamp > this.corrTimeWindow) {
                    XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
                    builder.field("root", true);
                    builder.field("counter", 50L);
                    builder.field("finding1", "");
                    builder.field("finding2", "");
                    builder.field("logType", "");
                    builder.field("timestamp", findingTimestamp);
                    builder.field("scoreTimestamp", 0L);
                    builder.endObject();
                    IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest(".opensearch-sap-correlation-metadata").id(id).source(builder).timeout(this.indexTimeout)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                    this.client.index(indexRequest, ActionListener.wrap(indexResponse -> {
                        if (indexResponse.status().equals((Object)RestStatus.OK)) {
                            this.correlateFindingAction.onOperation();
                            try {
                                float[] corrVector = new float[3];
                                corrVector[0] = 50.0f;
                                corrVector[2] = timestampFeature;
                                XContentBuilder contentBuilder = XContentFactory.jsonBuilder().startObject();
                                contentBuilder.field("root", false);
                                contentBuilder.field("counter", 50L);
                                contentBuilder.field("finding1", finding.getId());
                                contentBuilder.field("finding2", "");
                                contentBuilder.field("logType", Integer.valueOf(((CustomLogType)logTypes.get(detectorType)).getTags().get("correlation_id").toString()).toString());
                                contentBuilder.field("timestamp", findingTimestamp);
                                contentBuilder.field("corr_vector", (Object)corrVector);
                                contentBuilder.field("recordType", "finding");
                                contentBuilder.field("scoreTimestamp", 0L);
                                contentBuilder.endObject();
                                this.indexCorrelatedFindings(contentBuilder);
                            }
                            catch (Exception ex) {
                                this.onFailure(ex);
                            }
                        } else {
                            this.onFailure((Exception)new OpenSearchStatusException("Indexing failed with response {} ", indexResponse.status(), new Object[]{indexResponse.toString()}));
                        }
                    }, this::onFailure));
                } else {
                    float[] query = new float[3];
                    for (int i = 0; i < 2; ++i) {
                        query[i] = (2.0f * (float)counter - 50.0f) / 2.0f;
                    }
                    query[2] = timestampFeature;
                    CorrelationQueryBuilder correlationQueryBuilder = new CorrelationQueryBuilder("corr_vector", query, 100, (QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"finding1", (Object)"")).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"finding2", (Object)"")).filter((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp").gte((Object)(findingTimestamp - this.corrTimeWindow)).lte((Object)(findingTimestamp + this.corrTimeWindow))));
                    SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
                    searchSourceBuilder.query((QueryBuilder)correlationQueryBuilder);
                    searchSourceBuilder.fetchSource(true);
                    searchSourceBuilder.size(1);
                    SearchRequest request = new SearchRequest();
                    request.indices(new String[]{".opensearch-sap-correlation-history*"});
                    request.source(searchSourceBuilder);
                    request.preference(Preference.PRIMARY_FIRST.type());
                    request.setCancelAfterTimeInterval(TimeValue.timeValueSeconds((long)30L));
                    this.client.search(request, ActionListener.wrap(searchResponse -> {
                        long totalHits;
                        if (searchResponse.isTimedOut()) {
                            this.onFailure((Exception)new OpenSearchStatusException("Search request timed out", RestStatus.REQUEST_TIMEOUT, new Object[0]));
                        }
                        SearchHit hit = (totalHits = (long)searchResponse.getHits().getHits().length) > 0L ? searchResponse.getHits().getHits()[0] : null;
                        long existCounter = 0L;
                        if (hit != null) {
                            Map sourceAsMap = searchResponse.getHits().getHits()[0].getSourceAsMap();
                            existCounter = Long.parseLong(sourceAsMap.get("counter").toString());
                        }
                        if (totalHits == 0L || (float)existCounter != (float)((long)(2.0f * (float)counter - 50.0f)) / 2.0f) {
                            try {
                                float[] corrVector = new float[3];
                                for (int i = 0; i < 2; ++i) {
                                    corrVector[i] = (float)counter - 50.0f;
                                }
                                corrVector[0] = counter;
                                corrVector[2] = timestampFeature;
                                XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
                                builder.field("root", false);
                                builder.field("counter", counter);
                                builder.field("finding1", finding.getId());
                                builder.field("finding2", "");
                                builder.field("logType", Integer.valueOf(((CustomLogType)logTypes.get(detectorType)).getTags().get("correlation_id").toString()).toString());
                                builder.field("timestamp", findingTimestamp);
                                builder.field("corr_vector", (Object)corrVector);
                                builder.field("recordType", "finding");
                                builder.field("scoreTimestamp", 0L);
                                builder.endObject();
                                this.indexCorrelatedFindings(builder);
                            }
                            catch (Exception ex) {
                                this.onFailure(ex);
                            }
                        } else {
                            try {
                                XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
                                builder.field("root", true);
                                builder.field("counter", counter + 50L);
                                builder.field("finding1", "");
                                builder.field("finding2", "");
                                builder.field("logType", "");
                                builder.field("timestamp", findingTimestamp);
                                builder.field("scoreTimestamp", 0L);
                                builder.endObject();
                                IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest(".opensearch-sap-correlation-metadata").id(id).source(builder).timeout(this.indexTimeout)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                                this.client.index(indexRequest, ActionListener.wrap(indexResponse -> {
                                    if (indexResponse.status().equals((Object)RestStatus.OK)) {
                                        try {
                                            float[] corrVector = new float[3];
                                            for (int i = 0; i < 2; ++i) {
                                                corrVector[i] = counter;
                                            }
                                            corrVector[0] = (float)counter + 50.0f;
                                            corrVector[2] = timestampFeature;
                                            XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().startObject();
                                            xContentBuilder.field("root", false);
                                            xContentBuilder.field("counter", counter + 50L);
                                            xContentBuilder.field("finding1", finding.getId());
                                            xContentBuilder.field("finding2", "");
                                            xContentBuilder.field("logType", Integer.valueOf(((CustomLogType)logTypes.get(detectorType)).getTags().get("correlation_id").toString()).toString());
                                            xContentBuilder.field("timestamp", findingTimestamp);
                                            xContentBuilder.field("corr_vector", (Object)corrVector);
                                            xContentBuilder.field("recordType", "finding");
                                            xContentBuilder.field("scoreTimestamp", 0L);
                                            xContentBuilder.endObject();
                                            this.indexCorrelatedFindings(xContentBuilder);
                                        }
                                        catch (Exception ex) {
                                            this.onFailure(ex);
                                        }
                                    } else {
                                        this.onFailure((Exception)new OpenSearchStatusException("Indexing failed with response {} ", indexResponse.status(), new Object[]{indexResponse.toString()}));
                                    }
                                }, this::onFailure));
                            }
                            catch (Exception ex) {
                                this.onFailure(ex);
                            }
                        }
                    }, this::onFailure));
                }
            }
            catch (Exception ex) {
                this.onFailure(ex);
            }
        }, this::onFailure));
    }

    private void indexCorrelatedFindings(XContentBuilder builder) {
        IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest(".opensearch-sap-correlation-history-write").source(builder).timeout(this.indexTimeout)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.client.index(indexRequest, ActionListener.wrap(response -> {
            if (response.status().equals((Object)RestStatus.CREATED)) {
                this.correlateFindingAction.onOperation();
            } else {
                this.onFailure((Exception)new OpenSearchStatusException("Indexing failed with response {} ", response.status(), new Object[]{response.toString()}));
            }
        }, this::onFailure));
    }

    private SearchRequest getSearchMetadataIndexRequest(String detectorType, Finding finding, Map<String, CustomLogType> logTypes) {
        if (logTypes.get(detectorType) == null) {
            throw new OpenSearchStatusException("LogTypes Index is missing the detector type", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        Map<String, Object> tags = logTypes.get(detectorType).getTags();
        MatchQueryBuilder queryBuilder = QueryBuilders.matchQuery((String)"root", (Object)true);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.fetchSource(true);
        searchSourceBuilder.size(1);
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.indices(new String[]{".opensearch-sap-correlation-metadata"});
        searchRequest.source(searchSourceBuilder);
        searchRequest.preference(Preference.PRIMARY_FIRST.type());
        searchRequest.setCancelAfterTimeInterval(TimeValue.timeValueSeconds((long)30L));
        return searchRequest;
    }

    private void onFailure(Exception e) {
        this.correlateFindingAction.onFailures(e);
    }
}

