/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class FindingWithScore
implements Writeable,
ToXContentObject {
    protected static final String FINDING = "finding";
    protected static final String DETECTOR_TYPE = "detector_type";
    protected static final String SCORE = "score";
    protected static final String RULES = "rules";
    private String finding;
    private String detectorType;
    private Double score;
    private List<String> rules;

    public FindingWithScore(String finding, String detectorType, Double score, List<String> rules) {
        this.finding = finding;
        this.detectorType = detectorType;
        this.score = score;
        this.rules = rules;
    }

    public FindingWithScore(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readString(), sin.readDouble(), sin.readStringList());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.finding);
        out.writeString(this.detectorType);
        out.writeDouble(this.score.doubleValue());
        out.writeStringCollection(this.rules);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field(FINDING, this.finding).field(DETECTOR_TYPE, this.detectorType).field(SCORE, this.score).field(RULES, this.rules).endObject();
        return builder;
    }

    public static FindingWithScore parse(XContentParser xcp) throws IOException {
        String finding = null;
        String detectorType = null;
        Double score = null;
        ArrayList<String> rules = new ArrayList<String>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block12: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "finding": {
                    finding = xcp.text();
                    continue block12;
                }
                case "detector_type": {
                    detectorType = xcp.text();
                    continue block12;
                }
                case "score": {
                    score = xcp.doubleValue();
                    continue block12;
                }
                case "rules": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        rules.add(xcp.text());
                    }
                    continue block12;
                }
            }
            xcp.skipChildren();
        }
        return new FindingWithScore(finding, detectorType, score, rules);
    }

    public static FindingWithScore readFrom(StreamInput sin) throws IOException {
        return new FindingWithScore(sin);
    }
}

