/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.resthandler;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.securityanalytics.action.IndexCorrelationRuleAction;
import org.opensearch.securityanalytics.action.IndexCorrelationRuleRequest;
import org.opensearch.securityanalytics.action.IndexCorrelationRuleResponse;
import org.opensearch.securityanalytics.model.CorrelationRule;
import org.opensearch.transport.client.node.NodeClient;

public class RestIndexCorrelationRuleAction
extends BaseRestHandler {
    private static final Logger log = LogManager.getLogger(RestIndexCorrelationRuleAction.class);

    public String getName() {
        return "index_correlation_rule_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_plugins/_security_analytics/correlation/rules"), new RestHandler.Route(RestRequest.Method.PUT, String.format(Locale.getDefault(), "%s/{%s}", "/_plugins/_security_analytics/correlation/rules", "correlation_rule_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        log.debug(String.format(Locale.ROOT, "%s %s", request.method(), "/_plugins/_security_analytics/correlation/rules"));
        String id = request.param("correlation_rule_id", "");
        XContentParser xcp = request.contentParser();
        CorrelationRule correlationRule = CorrelationRule.parse(xcp, id, null);
        IndexCorrelationRuleRequest indexCorrelationRuleRequest = new IndexCorrelationRuleRequest(id, correlationRule, request.method());
        return channel -> client.execute((ActionType)IndexCorrelationRuleAction.INSTANCE, (ActionRequest)indexCorrelationRuleRequest, this.indexCorrelationRuleResponse((RestChannel)channel, request.method()));
    }

    private RestResponseListener<IndexCorrelationRuleResponse> indexCorrelationRuleResponse(RestChannel channel, final RestRequest.Method restMethod) {
        return new RestResponseListener<IndexCorrelationRuleResponse>(this, channel){

            public RestResponse buildResponse(IndexCorrelationRuleResponse response) throws Exception {
                RestStatus returnStatus = RestStatus.CREATED;
                if (restMethod == RestRequest.Method.PUT) {
                    returnStatus = RestStatus.OK;
                }
                BytesRestResponse restResponse = new BytesRestResponse(returnStatus, response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
                if (restMethod == RestRequest.Method.POST) {
                    String location = String.format(Locale.ROOT, "%s/%s", "/_plugins/_security_analytics/correlation/rules", response.getId());
                    restResponse.addHeader("Location", location);
                }
                return restResponse;
            }
        };
    }
}

