/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.rules.types;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.securityanalytics.rules.exceptions.SigmaTypeError;
import org.opensearch.securityanalytics.rules.types.SigmaType;

public class SigmaCIDRExpression
implements SigmaType {
    private String cidr;

    public SigmaCIDRExpression(String cidr) throws SigmaTypeError {
        this.cidr = cidr;
        if (!SigmaCIDRExpression.isIPv4AddressValid(this.cidr)) {
            throw new SigmaTypeError("Invalid IPv4 CIDR expression");
        }
    }

    public String convert() {
        return this.cidr;
    }

    private static boolean isIPv4AddressValid(String cidr) {
        int prefix;
        if (cidr == null) {
            return false;
        }
        String[] values = cidr.split("/");
        Pattern ipv4Pattern = Pattern.compile("(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])");
        Matcher mm = ipv4Pattern.matcher(values[0]);
        if (!mm.matches()) {
            return false;
        }
        return values.length < 2 || (prefix = Integer.parseInt(values[1])) >= 0 && prefix <= 32;
    }

    public String getCidr() {
        return this.cidr;
    }
}

