/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.action;

import java.io.IOException;
import java.util.List;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.securityanalytics.threatIntel.common.ParameterValidator;

public class PutTIFJobRequest
extends ActionRequest {
    private static final ParameterValidator VALIDATOR = new ParameterValidator();
    private String name;
    private TimeValue updateInterval;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public TimeValue getUpdateInterval() {
        return this.updateInterval;
    }

    public PutTIFJobRequest(String name, TimeValue updateInterval) {
        this.name = name;
        this.updateInterval = updateInterval;
    }

    public PutTIFJobRequest(StreamInput in) throws IOException {
        super(in);
        this.name = in.readString();
        this.updateInterval = in.readTimeValue();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.name);
        out.writeTimeValue(this.updateInterval);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException errors = new ActionRequestValidationException();
        List<String> errorMsgs = VALIDATOR.validateTIFJobName(this.name);
        if (!errorMsgs.isEmpty()) {
            errorMsgs.stream().forEach(msg -> errors.addValidationError(msg));
        }
        return errors.validationErrors().isEmpty() ? null : errors;
    }
}

