/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.model;

import java.io.IOException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.securityanalytics.threatIntel.model.Source;

public class CustomSchemaIocUploadSource
extends Source
implements Writeable,
ToXContent {
    public static final String IOCS_FIELD = "iocs";
    public static final String FILE_NAME_FIELD = "file_name";
    private String fileName;
    private String iocs;

    public CustomSchemaIocUploadSource(String fileName, String iocs) {
        this.fileName = fileName;
        this.iocs = iocs;
    }

    public CustomSchemaIocUploadSource(StreamInput sin) throws IOException {
        this(sin.readOptionalString(), sin.readOptionalString());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.fileName);
        out.writeOptionalString(this.iocs);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("custom_schema_ioc_upload");
        if (this.fileName != null) {
            builder.field(FILE_NAME_FIELD, this.fileName);
        }
        if (this.iocs != null) {
            builder.field(IOCS_FIELD, this.iocs);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    @Override
    String name() {
        return "custom_schema_ioc_upload";
    }

    public static CustomSchemaIocUploadSource parse(XContentParser xcp) throws IOException {
        String fileName = null;
        String iocs = null;
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "file_name": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        fileName = null;
                        break;
                    }
                    fileName = xcp.text();
                    break;
                }
                case "iocs": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        iocs = null;
                        break;
                    }
                    iocs = xcp.text();
                    break;
                }
            }
        }
        return new CustomSchemaIocUploadSource(fileName, iocs);
    }

    public String getIocs() {
        return this.iocs;
    }

    public void setIocs(String iocs) {
        this.iocs = iocs;
    }

    public String getFileName() {
        return this.fileName;
    }
}

