/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (i64vec3(-1333333333333333259l, 85l, 94l) << u64vec3(46ul, 50ul, 0ul)) => i64vec3(-6143683947919310848l, 95701492081623040l, 94l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) << u64vec3(52ul, 23ul, 5ul)) => i64vec3(-5814147118935310336l, 713031680l, 3008l)
 * (i64vec3(167l, 66l, 187l) << u64vec3(46ul, 50ul, 0ul)) => i64vec3(11751580277669888l, 74309393851613184l, 187l)
 * (i64vec3(167l, 66l, 187l) << u64vec3(52ul, 23ul, 5ul)) => i64vec3(752101137770872832l, 553648128l, 5984l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) << u64vec3(46ul, 50ul, 0ul)), i64vec3(-6143683947919310848l, 95701492081623040l, 94l))) ? 1 : -1] array0;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) << u64vec3(52ul, 23ul, 5ul)), i64vec3(-5814147118935310336l, 713031680l, 3008l))) ? 1 : -1] array1;
  float[all(equal((i64vec3(167l, 66l, 187l) << u64vec3(46ul, 50ul, 0ul)), i64vec3(11751580277669888l, 74309393851613184l, 187l))) ? 1 : -1] array2;
  float[all(equal((i64vec3(167l, 66l, 187l) << u64vec3(52ul, 23ul, 5ul)), i64vec3(752101137770872832l, 553648128l, 5984l))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
