/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec4(165ul, 133ul, 193ul, 76ul) >> ivec4(16, 24, 23, 25)) => u64vec4(0ul, 0ul, 0ul, 0ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) >> ivec4(23, 12, 14, 19)) => u64vec4(0ul, 0ul, 0ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) >> ivec4(16, 24, 23, 25)) => u64vec4(0ul, 0ul, 0ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) >> ivec4(23, 12, 14, 19)) => u64vec4(0ul, 0ul, 0ul, 0ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) >> ivec4(16, 24, 23, 25)), u64vec4(0ul, 0ul, 0ul, 0ul))) ? 1 : -1] array0;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) >> ivec4(23, 12, 14, 19)), u64vec4(0ul, 0ul, 0ul, 0ul))) ? 1 : -1] array1;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) >> ivec4(16, 24, 23, 25)), u64vec4(0ul, 0ul, 0ul, 0ul))) ? 1 : -1] array2;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) >> ivec4(23, 12, 14, 19)), u64vec4(0ul, 0ul, 0ul, 0ul))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
