/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * distance(0.0, 0.0) => 0.0
 * distance(0.0, -1.33) => 1.33
 * distance(0.0, 0.85) => 0.85
 * distance(-1.33, 0.0) => 1.33
 * distance(-1.33, -1.33) => 0.0
 * distance(-1.33, 0.85) => 2.18
 * distance(0.85, 0.0) => 0.85
 * distance(0.85, -1.33) => 2.18
 * distance(0.85, 0.85) => 0.0
 */
#version 120

void main()
{
  float[0.0 <= distance(0.0, 0.0) && distance(0.0, 0.0) <= 0.0 ? 1 : -1] array0;
  float[1.3299866914749146 <= distance(0.0, -1.33) && distance(0.0, -1.33) <= 1.330013394355774 ? 1 : -1] array1;
  float[0.849991500377655 <= distance(0.0, 0.85) && distance(0.0, 0.85) <= 0.8500085473060608 ? 1 : -1] array2;
  float[1.3299866914749146 <= distance(-1.33, 0.0) && distance(-1.33, 0.0) <= 1.330013394355774 ? 1 : -1] array3;
  float[0.0 <= distance(-1.33, -1.33) && distance(-1.33, -1.33) <= 0.0 ? 1 : -1] array4;
  float[2.179978370666504 <= distance(-1.33, 0.85) && distance(-1.33, 0.85) <= 2.1800217628479004 ? 1 : -1] array5;
  float[0.849991500377655 <= distance(0.85, 0.0) && distance(0.85, 0.0) <= 0.8500085473060608 ? 1 : -1] array6;
  float[2.179978370666504 <= distance(0.85, -1.33) && distance(0.85, -1.33) <= 2.1800217628479004 ? 1 : -1] array7;
  float[0.0 <= distance(0.85, 0.85) && distance(0.85, 0.85) <= 0.0 ? 1 : -1] array8;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length());
}
