/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec2(38u, 35u) * uvec2(38u, 35u)) => uvec2(1444u, 1225u)
 * (uvec2(38u, 35u) * uvec2(64u, 9u)) => uvec2(2432u, 315u)
 * (uvec2(64u, 9u) * uvec2(38u, 35u)) => uvec2(2432u, 315u)
 * (uvec2(64u, 9u) * uvec2(64u, 9u)) => uvec2(4096u, 81u)
 */
#version 130

void main()
{
  float[all(equal((uvec2(38u, 35u) * uvec2(38u, 35u)), uvec2(1444u, 1225u))) ? 1 : -1] array0;
  float[all(equal((uvec2(38u, 35u) * uvec2(64u, 9u)), uvec2(2432u, 315u))) ? 1 : -1] array1;
  float[all(equal((uvec2(64u, 9u) * uvec2(38u, 35u)), uvec2(2432u, 315u))) ? 1 : -1] array2;
  float[all(equal((uvec2(64u, 9u) * uvec2(64u, 9u)), uvec2(4096u, 81u))) ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
