/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec2(38u, 35u) | (~ 0u)) => uvec2(4294967295u, 4294967295u)
 * (uvec2(38u, 35u) | (~ 6u)) => uvec2(4294967295u, 4294967291u)
 * (uvec2(38u, 35u) | (~ 12u)) => uvec2(4294967287u, 4294967283u)
 * (uvec2(38u, 35u) | (~ 32u)) => uvec2(4294967295u, 4294967295u)
 * (uvec2(38u, 35u) | (~ 74u)) => uvec2(4294967223u, 4294967223u)
 * (uvec2(64u, 9u) | (~ 0u)) => uvec2(4294967295u, 4294967295u)
 * (uvec2(64u, 9u) | (~ 6u)) => uvec2(4294967289u, 4294967289u)
 * (uvec2(64u, 9u) | (~ 12u)) => uvec2(4294967283u, 4294967291u)
 * (uvec2(64u, 9u) | (~ 32u)) => uvec2(4294967263u, 4294967263u)
 * (uvec2(64u, 9u) | (~ 74u)) => uvec2(4294967285u, 4294967229u)
 */
#version 150

void main()
{
  float[all(equal((uvec2(38u, 35u) | (~ 0u)), uvec2(4294967295u, 4294967295u))) ? 1 : -1] array0;
  float[all(equal((uvec2(38u, 35u) | (~ 6u)), uvec2(4294967295u, 4294967291u))) ? 1 : -1] array1;
  float[all(equal((uvec2(38u, 35u) | (~ 12u)), uvec2(4294967287u, 4294967283u))) ? 1 : -1] array2;
  float[all(equal((uvec2(38u, 35u) | (~ 32u)), uvec2(4294967295u, 4294967295u))) ? 1 : -1] array3;
  float[all(equal((uvec2(38u, 35u) | (~ 74u)), uvec2(4294967223u, 4294967223u))) ? 1 : -1] array4;
  float[all(equal((uvec2(64u, 9u) | (~ 0u)), uvec2(4294967295u, 4294967295u))) ? 1 : -1] array5;
  float[all(equal((uvec2(64u, 9u) | (~ 6u)), uvec2(4294967289u, 4294967289u))) ? 1 : -1] array6;
  float[all(equal((uvec2(64u, 9u) | (~ 12u)), uvec2(4294967283u, 4294967291u))) ? 1 : -1] array7;
  float[all(equal((uvec2(64u, 9u) | (~ 32u)), uvec2(4294967263u, 4294967263u))) ? 1 : -1] array8;
  float[all(equal((uvec2(64u, 9u) | (~ 74u)), uvec2(4294967285u, 4294967229u))) ? 1 : -1] array9;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
