/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.interpreter;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonIdeLanguageCustomization;
import com.jetbrains.python.inspections.PyAsyncFileInspectionRunner;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.interpreter.InterpreterSettingsQuickFix;
import com.jetbrains.python.inspections.interpreter.PyInterpreterInspectionKt;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J,\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/python/inspections/interpreter/PyInterpreterInspectionVisitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "asyncFileInspectionRunner", "Lcom/jetbrains/python/inspections/PyAsyncFileInspectionRunner;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;Lcom/jetbrains/python/inspections/PyAsyncFileInspectionRunner;)V", "visitPyFile", "", "node", "Lcom/jetbrains/python/psi/PyFile;", "registerProblemWithCommonFixes", "message", "", "module", "Lcom/intellij/openapi/module/Module;", "pyCharm", "", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyInterpreterInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyInterpreterInspection.kt\ncom/jetbrains/python/inspections/interpreter/PyInterpreterInspectionVisitor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,256:1\n37#2,2:257\n*S KotlinDebug\n*F\n+ 1 PyInterpreterInspection.kt\ncom/jetbrains/python/inspections/interpreter/PyInterpreterInspectionVisitor\n*L\n93#1:257,2\n*E\n"})
final class PyInterpreterInspectionVisitor
extends PyInspectionVisitor {
    @NotNull
    private final PyAsyncFileInspectionRunner asyncFileInspectionRunner;

    public PyInterpreterInspectionVisitor(@Nullable ProblemsHolder holder, @NotNull TypeEvalContext context, @NotNull PyAsyncFileInspectionRunner asyncFileInspectionRunner2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)asyncFileInspectionRunner2, (String)"asyncFileInspectionRunner");
        super(holder, context);
        this.asyncFileInspectionRunner = asyncFileInspectionRunner2;
    }

    public void visitPyFile(@NotNull PyFile node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (PyInterpreterInspectionKt.access$isFileIgnored(node)) {
            return;
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)node));
        Sdk sdk2 = PyBuiltinCache.Companion.findSdkForFile((PsiFileSystemItem)node);
        boolean pyCharm = PythonIdeLanguageCustomization.isMainlyPythonIde();
        if (sdk2 == null) {
            String string = pyCharm ? PyPsiBundle.message((String)"INSP.interpreter.no.python.interpreter.configured.for.project", (Object[])new Object[0]) : PyPsiBundle.message((String)"INSP.interpreter.no.python.interpreter.configured.for.module", (Object[])new Object[0]);
            Intrinsics.checkNotNull((Object)string);
            String message = string;
            this.registerProblemWithCommonFixes(node, message, module2, pyCharm);
        }
    }

    private final void registerProblemWithCommonFixes(PyFile node, @InspectionMessage String message, Module module2, boolean pyCharm) {
        if (module2 != null && pyCharm) {
            List<LocalQuickFix> list = this.asyncFileInspectionRunner.runInspection(node, module2);
            if (list != null) {
                List<LocalQuickFix> fixes = list;
                boolean bl = false;
                Collection $this$toTypedArray$iv = fixes;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
                this.registerProblem((PsiElement)node, message, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
            }
        } else {
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new InterpreterSettingsQuickFix(module2)};
            this.registerProblem((PsiElement)node, message, localQuickFixArray);
        }
    }
}

